package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AnalyzeDAOAbstract<E extends Analyze> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Analyze.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Analyze;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<AnalyzeFile> list = getContext()
                                                    .getDAO(AnalyzeFile.class)
                                                    .findAllByProperties(AnalyzeFile.PROPERTY_ANALYZE, entity);
                                            for (AnalyzeFile item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getAnalyze())) {
                                                    item.setAnalyze(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByCreationDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_CREATION_DATE, v);
        return result;
    }

    public List<E> findAllByCreationDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_CREATION_DATE, v);
        return result;
    }

    public E findBySentDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_SENT_DATE, v);
        return result;
    }

    public List<E> findAllBySentDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_SENT_DATE, v);
        return result;
    }

    public E findByReceiptLimitDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_RECEIPT_LIMIT_DATE, v);
        return result;
    }

    public List<E> findAllByReceiptLimitDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_RECEIPT_LIMIT_DATE, v);
        return result;
    }

    public E findByReceiptDate(Date v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_RECEIPT_DATE, v);
        return result;
    }

    public List<E> findAllByReceiptDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_RECEIPT_DATE, v);
        return result;
    }

    public E findBySynthesis(String v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_SYNTHESIS, v);
        return result;
    }

    public List<E> findAllBySynthesis(String v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_SYNTHESIS, v);
        return result;
    }

    public E findByAnalyzeType(AnalyzeType v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_ANALYZE_TYPE, v);
        return result;
    }

    public List<E> findAllByAnalyzeType(AnalyzeType v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_ANALYZE_TYPE, v);
        return result;
    }

    public E findByBatch(Batch v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_BATCH, v);
        return result;
    }

    public List<E> findAllByBatch(Batch v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_BATCH, v);
        return result;
    }

    public E findBySupplier(Supplier v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_SUPPLIER, v);
        return result;
    }

    public List<E> findAllBySupplier(Supplier v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_SUPPLIER, v);
        return result;
    }

    public E findBySynthesisMention(SynthesisMention v) throws TopiaException {
        E result = findByProperty(Analyze.PROPERTY_SYNTHESIS_MENTION, v);
        return result;
    }

    public List<E> findAllBySynthesisMention(SynthesisMention v) throws TopiaException {
        List<E> result = findAllByProperty(Analyze.PROPERTY_SYNTHESIS_MENTION, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == AnalyzeFile.class) {
            AnalyzeFileDAO dao = (AnalyzeFileDAO)
                getContext().getDAO(AnalyzeFile.class);
            tmp = dao.findAllByAnalyze(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(AnalyzeFile.class, entity);
        if (!list.isEmpty()) {
            result.put(AnalyzeFile.class, list);
        }

        return result;
    }

} //AnalyzeDAOAbstract<E extends Analyze>
