package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class AnalyzeAbstract extends TopiaEntityAbstract implements Analyze {

    /**
     * Nom de l'attribut en BD : creationDate
     */
    protected Date creationDate;

    /**
     * Nom de l'attribut en BD : sentDate
     */
    protected Date sentDate;

    /**
     * Nom de l'attribut en BD : receiptLimitDate
     */
    protected Date receiptLimitDate;

    /**
     * Nom de l'attribut en BD : receiptDate
     */
    protected Date receiptDate;

    /**
     * Nom de l'attribut en BD : synthesis
     */
    protected String synthesis;

    /**
     * Nom de l'attribut en BD : analyzeType
     */
    protected AnalyzeType analyzeType;

    /**
     * Nom de l'attribut en BD : batch
     */
    protected Batch batch;

    /**
     * Nom de l'attribut en BD : supplier
     */
    protected Supplier supplier;

    /**
     * Nom de l'attribut en BD : synthesisMention
     */
    protected SynthesisMention synthesisMention;

    private static final long serialVersionUID = 7017512233592108646L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CREATION_DATE, Date.class, creationDate);
        visitor.visit(this, PROPERTY_SENT_DATE, Date.class, sentDate);
        visitor.visit(this, PROPERTY_RECEIPT_LIMIT_DATE, Date.class, receiptLimitDate);
        visitor.visit(this, PROPERTY_RECEIPT_DATE, Date.class, receiptDate);
        visitor.visit(this, PROPERTY_SYNTHESIS, String.class, synthesis);
        visitor.visit(this, PROPERTY_ANALYZE_TYPE, AnalyzeType.class, analyzeType);
        visitor.visit(this, PROPERTY_BATCH, Batch.class, batch);
        visitor.visit(this, PROPERTY_SUPPLIER, Supplier.class, supplier);
        visitor.visit(this, PROPERTY_SYNTHESIS_MENTION, SynthesisMention.class, synthesisMention);
        visitor.end(this);
    }

    @Override
    public void setCreationDate(Date creationDate) {
        Date oldValue = this.creationDate;
        fireOnPreWrite(PROPERTY_CREATION_DATE, oldValue, creationDate);
        this.creationDate = creationDate;
        fireOnPostWrite(PROPERTY_CREATION_DATE, oldValue, creationDate);
    }

    @Override
    public Date getCreationDate() {
        fireOnPreRead(PROPERTY_CREATION_DATE, creationDate);
        Date result = this.creationDate;
        fireOnPostRead(PROPERTY_CREATION_DATE, creationDate);
        return result;
    }

    @Override
    public void setSentDate(Date sentDate) {
        Date oldValue = this.sentDate;
        fireOnPreWrite(PROPERTY_SENT_DATE, oldValue, sentDate);
        this.sentDate = sentDate;
        fireOnPostWrite(PROPERTY_SENT_DATE, oldValue, sentDate);
    }

    @Override
    public Date getSentDate() {
        fireOnPreRead(PROPERTY_SENT_DATE, sentDate);
        Date result = this.sentDate;
        fireOnPostRead(PROPERTY_SENT_DATE, sentDate);
        return result;
    }

    @Override
    public void setReceiptLimitDate(Date receiptLimitDate) {
        Date oldValue = this.receiptLimitDate;
        fireOnPreWrite(PROPERTY_RECEIPT_LIMIT_DATE, oldValue, receiptLimitDate);
        this.receiptLimitDate = receiptLimitDate;
        fireOnPostWrite(PROPERTY_RECEIPT_LIMIT_DATE, oldValue, receiptLimitDate);
    }

    @Override
    public Date getReceiptLimitDate() {
        fireOnPreRead(PROPERTY_RECEIPT_LIMIT_DATE, receiptLimitDate);
        Date result = this.receiptLimitDate;
        fireOnPostRead(PROPERTY_RECEIPT_LIMIT_DATE, receiptLimitDate);
        return result;
    }

    @Override
    public void setReceiptDate(Date receiptDate) {
        Date oldValue = this.receiptDate;
        fireOnPreWrite(PROPERTY_RECEIPT_DATE, oldValue, receiptDate);
        this.receiptDate = receiptDate;
        fireOnPostWrite(PROPERTY_RECEIPT_DATE, oldValue, receiptDate);
    }

    @Override
    public Date getReceiptDate() {
        fireOnPreRead(PROPERTY_RECEIPT_DATE, receiptDate);
        Date result = this.receiptDate;
        fireOnPostRead(PROPERTY_RECEIPT_DATE, receiptDate);
        return result;
    }

    @Override
    public void setSynthesis(String synthesis) {
        String oldValue = this.synthesis;
        fireOnPreWrite(PROPERTY_SYNTHESIS, oldValue, synthesis);
        this.synthesis = synthesis;
        fireOnPostWrite(PROPERTY_SYNTHESIS, oldValue, synthesis);
    }

    @Override
    public String getSynthesis() {
        fireOnPreRead(PROPERTY_SYNTHESIS, synthesis);
        String result = this.synthesis;
        fireOnPostRead(PROPERTY_SYNTHESIS, synthesis);
        return result;
    }

    @Override
    public void setAnalyzeType(AnalyzeType analyzeType) {
        AnalyzeType oldValue = this.analyzeType;
        fireOnPreWrite(PROPERTY_ANALYZE_TYPE, oldValue, analyzeType);
        this.analyzeType = analyzeType;
        fireOnPostWrite(PROPERTY_ANALYZE_TYPE, oldValue, analyzeType);
    }

    @Override
    public AnalyzeType getAnalyzeType() {
        fireOnPreRead(PROPERTY_ANALYZE_TYPE, analyzeType);
        AnalyzeType result = this.analyzeType;
        fireOnPostRead(PROPERTY_ANALYZE_TYPE, analyzeType);
        return result;
    }

    @Override
    public void setBatch(Batch batch) {
        Batch oldValue = this.batch;
        fireOnPreWrite(PROPERTY_BATCH, oldValue, batch);
        this.batch = batch;
        fireOnPostWrite(PROPERTY_BATCH, oldValue, batch);
    }

    @Override
    public Batch getBatch() {
        fireOnPreRead(PROPERTY_BATCH, batch);
        Batch result = this.batch;
        fireOnPostRead(PROPERTY_BATCH, batch);
        return result;
    }

    @Override
    public void setSupplier(Supplier supplier) {
        Supplier oldValue = this.supplier;
        fireOnPreWrite(PROPERTY_SUPPLIER, oldValue, supplier);
        this.supplier = supplier;
        fireOnPostWrite(PROPERTY_SUPPLIER, oldValue, supplier);
    }

    @Override
    public Supplier getSupplier() {
        fireOnPreRead(PROPERTY_SUPPLIER, supplier);
        Supplier result = this.supplier;
        fireOnPostRead(PROPERTY_SUPPLIER, supplier);
        return result;
    }

    @Override
    public void setSynthesisMention(SynthesisMention synthesisMention) {
        SynthesisMention oldValue = this.synthesisMention;
        fireOnPreWrite(PROPERTY_SYNTHESIS_MENTION, oldValue, synthesisMention);
        this.synthesisMention = synthesisMention;
        fireOnPostWrite(PROPERTY_SYNTHESIS_MENTION, oldValue, synthesisMention);
    }

    @Override
    public SynthesisMention getSynthesisMention() {
        fireOnPreRead(PROPERTY_SYNTHESIS_MENTION, synthesisMention);
        SynthesisMention result = this.synthesisMention;
        fireOnPostRead(PROPERTY_SYNTHESIS_MENTION, synthesisMention);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //AnalyzeAbstract
