/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAOAbstract;
import com.herbocailleau.sgq.entities.Presentation;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;

public class BatchDAOImpl<E extends Batch>
extends BatchDAOAbstract<E> {
    public int getNextRangeIdBetween(int start, int end) throws TopiaException {
        String query = "select min(main.number + 1) from " + Batch.class.getName() + " as main," + " " + Batch.class.getName() + " as sub" + " where :start < main." + "number" + " and main." + "number" + " < :end" + " and main." + "number" + " + 1 not in (sub.number) ";
        Number id = (Number)this.context.findUnique(query, new Object[]{"start", start, "end", end});
        int result = 0;
        result = id == null ? start : id.intValue();
        return result;
    }

    public List<Batch> findAllBetweenNumbers(int start, int end) throws TopiaException {
        String query = " from " + Batch.class.getName() + " where :start <= " + "number" + " and " + "number" + " <= :end";
        List result = this.context.findAll(query, new Object[]{"start", start, "end", end});
        return result;
    }

    public List<BatchModel> findAllWithQuantity(SearchModel search) throws TopiaException {
        String query = "select B, sum(P.quantity) from " + Batch.class.getName() + " B, " + Presentation.class.getName() + " P" + " where B = P." + "batch";
        query = query + " and (B.number = :batch";
        query = query + " or B.product.name like :query)";
        query = query + " group by B";
        query = query + " order by B.number ASC";
        int batch = -1;
        try {
            batch = Integer.parseInt(search.getQuery());
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        List beanAndQts = this.context.findAll(query, new Object[]{"batch", batch, "query", "%" + search.getQuery() + "%"});
        ArrayList<BatchModel> results = new ArrayList<BatchModel>(beanAndQts.size());
        for (Object[] beanAndQt : beanAndQts) {
            results.add(new BatchModel((Batch)beanAndQt[0], (Double)beanAndQt[1]));
        }
        return results;
    }
}

