/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import au.com.bytecode.opencsv.CSVReader;
import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Sale;
import com.herbocailleau.sgq.entities.SaleDAO;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class ProductionService
extends SgqService {
    private static final Log log = LogFactory.getLog(ProductionService.class);

    public Date getProductionStartDate() {
        return null;
    }

    public Date getSaleStartDate() {
        return null;
    }

    public void importLabelsFile(String fileFilename, File file) {
        String productionFileName = this.config.getLabelProductionFilename();
        if (productionFileName.equalsIgnoreCase(productionFileName)) {
            this.importLabelsProductionFile(file);
        } else {
            String expeditionFileName = this.config.getLabelProductionFilename();
            if (expeditionFileName.equalsIgnoreCase(productionFileName)) {
                this.importLabelsExpeditionFile(file);
            } else {
                throw new SgqBusinessException(I18n._((String)"Invalid name '%s' for label file", (Object[])new Object[]{fileFilename}));
            }
        }
    }

    protected void importLabelsProductionFile(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing production file : " + file));
        }
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(file));
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            SaleDAO saleDAO = this.daoHelper.getSaleDAO();
            Object[] data = null;
            while ((data = reader.readNext()) != null) {
                if (data.length <= 1) continue;
                String dateddMMyy = data[1];
                String clientId = data[5];
                String productId = data[7];
                String batchId = data[9];
                String quantityStr = data[11];
                Date date = df.parse(dateddMMyy);
                Object batch = batchDAO.findByNumber(Integer.parseInt(batchId));
                if (batch == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Can't find batch " + batchId));
                    continue;
                }
                char presentationChar = productId.charAt(0);
                PresentationCode presentationCode = PresentationCode.getPresentationCodeFor(presentationChar);
                double quantity = Double.parseDouble(quantityStr);
                int client = Integer.parseInt(clientId);
                List presentations = presentationDAO.findAllByBatch((Batch)batch);
                boolean originPresentationFound = false;
                Presentation destPresentation = null;
                for (Presentation presentation : presentations) {
                    if (presentation.getPresentationCode() == PresentationCode._) {
                        originPresentationFound = true;
                        double presQuantity = presentation.getQuantity();
                        presentation.setQuantity(presQuantity -= quantity);
                        presentationDAO.update(presentation);
                    }
                    if (presentationCode != presentation.getPresentationCode()) continue;
                    destPresentation = presentation;
                }
                if (SgqUtils.isInternalClient(this.config, client)) {
                    if (!originPresentationFound && log.isWarnEnabled()) {
                        log.warn((Object)("Can't find original presentation for row " + Arrays.toString(data)));
                    }
                    if (destPresentation == null) {
                        destPresentation = (Presentation)presentationDAO.create(new Object[0]);
                        destPresentation.setBatch((Batch)batch);
                        destPresentation.setName(batch.getProduct().getName());
                        destPresentation.setPresentationCode(presentationCode);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("New presentation for batch " + batch.getNumber()));
                        }
                    }
                    double presQuantity = destPresentation.getQuantity();
                    destPresentation.setQuantity(presQuantity += quantity);
                    presentationDAO.update(destPresentation);
                    continue;
                }
                if (destPresentation == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Can't find expedition presentation for batch " + batch.getNumber()));
                    continue;
                }
                double presQuantity = destPresentation.getQuantity();
                destPresentation.setQuantity(presQuantity += quantity);
                presentationDAO.update(destPresentation);
                Sale sale = (Sale)saleDAO.create(new Object[0]);
                sale.setDate(date);
                sale.setPresentation(destPresentation);
                sale.setQuantity(quantity);
                saleDAO.update(sale);
            }
            reader.close();
            this.daoHelper.commit();
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't import label file", ex);
        }
        catch (ParseException ex) {
            throw new SgqBusinessException("Can't import label file", ex);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't import label file", ex);
        }
    }

    protected void importLabelsExpeditionFile(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing expedition file : " + file));
        }
    }
}

