/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business;

import com.herbocailleau.sgq.business.SgqBusinessException;
import java.util.Properties;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;

public class SgqBusinessConfig {
    protected ApplicationConfig config = new ApplicationConfig();

    public SgqBusinessConfig() {
        for (SgqBusinessOption o : SgqBusinessOption.values()) {
            if (o.defaultValue == null) continue;
            this.config.setDefaultOption(o.key, o.defaultValue);
        }
    }

    public void parse() {
        try {
            this.config.parse(new String[0]);
        }
        catch (ArgumentsParserException ex) {
            throw new SgqBusinessException("Can't load configuration", ex);
        }
    }

    public Properties getFlatOptions() {
        return this.config.getFlatOptions();
    }

    public int getBatchRangeNonBioStart() {
        return this.config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_NONBIO_START.key);
    }

    public int getBatchRangeNonBioEnd() {
        return this.config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_NONBIO_END.key);
    }

    public int getBatchRangeBioStart() {
        return this.config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_BIO_START.key);
    }

    public int getBatchRangeBioEnd() {
        return this.config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_BIO_END.key);
    }

    public String getLabelProductionFilename() {
        return this.config.getOption(SgqBusinessOption.LABEL_PRODUCTION_FILENAME.key);
    }

    public String getLabelExpeditionFilename() {
        return this.config.getOption(SgqBusinessOption.LABEL_EXPEDITION_FILENAME.key);
    }

    public int getClientInternalSite1() {
        return this.config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_SITE1.key);
    }

    public int getClientInternalSite2() {
        return this.config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_SITE2.key);
    }

    public int getClientInternalSite3() {
        return this.config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_SITE3.key);
    }

    static enum SgqBusinessOption {
        CONFIG_FILE("config.file", "sgqweb.properties"),
        SGQ_DIRECTORY("sgq.directory", "${java.io.tmpdir}/sgq"),
        HIBERNATE_DIALECT("hibernate.dialect", "org.hibernate.dialect.H2Dialect"),
        HIBERNATE_CONNECTION_DRIVER("hibernate.dialect", "org.hibernate.dialect.H2Dialect"),
        HIBERNATE_CONNECTION_URL("hibernate.connection.url", "jdbc:h2:file:${sgq.directory}/data/sgq"),
        HIBERNATE_CONNETION_USERNAME("hibernate.connection.username", "sa"),
        HIBERNATE_CONNECTION_PASSWORD("hibernate.connection.password", ""),
        HIBERNATE_HBM2DLL_AUTO("hibernate.hbm2ddl.auto", "update"),
        CLIENT_INTERNAL_SITE1("client.internal.site1", "99997"),
        CLIENT_INTERNAL_SITE2("client.internal.site2", "99998"),
        CLIENT_INTERNAL_SITE3("client.internal.site3", "99999"),
        BATCH_RANGE_NONBIO_START("batch.range.nonbio.start", "20000"),
        BATCH_RANGE_NONBIO_END("batch.range.nonbio.end", "69999"),
        BATCH_RANGE_BIO_START("batch.range.bio.start", "71000"),
        BATCH_RANGE_BIO_END("batch.range.bio.end", "89999"),
        LABEL_PRODUCTION_FILENAME("label.production.filename", "FIF_HIST.txt"),
        LABEL_EXPEDITION_FILENAME("label.expedition.filename", "FIC_HIST.txt");

        protected String key;
        protected String defaultValue;

        private SgqBusinessOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }
    }
}

