package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ProductAbstract extends TopiaEntityAbstract implements Product {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : category
     */
    protected String category;

    /**
     * Nom de l'attribut en BD : latinName
     */
    protected String latinName;

    /**
     * Nom de l'attribut en BD : family
     */
    protected String family;

    /**
     * Nom de l'attribut en BD : status
     */
    protected String status;

    /**
     * Nom de l'attribut en BD : analyzes
     */
    protected String analyzes;

    /**
     * Nom de l'attribut en BD : botanicControl
     */
    protected boolean botanicControl;

    /**
     * Nom de l'attribut en BD : identificationControl
     */
    protected boolean identificationControl;

    private static final long serialVersionUID = 3546919190825886769L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_CATEGORY, String.class, category);
        visitor.visit(this, PROPERTY_LATIN_NAME, String.class, latinName);
        visitor.visit(this, PROPERTY_FAMILY, String.class, family);
        visitor.visit(this, PROPERTY_STATUS, String.class, status);
        visitor.visit(this, PROPERTY_ANALYZES, String.class, analyzes);
        visitor.visit(this, PROPERTY_BOTANIC_CONTROL, boolean.class, botanicControl);
        visitor.visit(this, PROPERTY_IDENTIFICATION_CONTROL, boolean.class, identificationControl);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(PROPERTY_CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(PROPERTY_CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(PROPERTY_CODE, code);
        String result = this.code;
        fireOnPostRead(PROPERTY_CODE, code);
        return result;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setCategory(String category) {
        String oldValue = this.category;
        fireOnPreWrite(PROPERTY_CATEGORY, oldValue, category);
        this.category = category;
        fireOnPostWrite(PROPERTY_CATEGORY, oldValue, category);
    }

    @Override
    public String getCategory() {
        fireOnPreRead(PROPERTY_CATEGORY, category);
        String result = this.category;
        fireOnPostRead(PROPERTY_CATEGORY, category);
        return result;
    }

    @Override
    public void setLatinName(String latinName) {
        String oldValue = this.latinName;
        fireOnPreWrite(PROPERTY_LATIN_NAME, oldValue, latinName);
        this.latinName = latinName;
        fireOnPostWrite(PROPERTY_LATIN_NAME, oldValue, latinName);
    }

    @Override
    public String getLatinName() {
        fireOnPreRead(PROPERTY_LATIN_NAME, latinName);
        String result = this.latinName;
        fireOnPostRead(PROPERTY_LATIN_NAME, latinName);
        return result;
    }

    @Override
    public void setFamily(String family) {
        String oldValue = this.family;
        fireOnPreWrite(PROPERTY_FAMILY, oldValue, family);
        this.family = family;
        fireOnPostWrite(PROPERTY_FAMILY, oldValue, family);
    }

    @Override
    public String getFamily() {
        fireOnPreRead(PROPERTY_FAMILY, family);
        String result = this.family;
        fireOnPostRead(PROPERTY_FAMILY, family);
        return result;
    }

    @Override
    public void setStatus(String status) {
        String oldValue = this.status;
        fireOnPreWrite(PROPERTY_STATUS, oldValue, status);
        this.status = status;
        fireOnPostWrite(PROPERTY_STATUS, oldValue, status);
    }

    @Override
    public String getStatus() {
        fireOnPreRead(PROPERTY_STATUS, status);
        String result = this.status;
        fireOnPostRead(PROPERTY_STATUS, status);
        return result;
    }

    @Override
    public void setAnalyzes(String analyzes) {
        String oldValue = this.analyzes;
        fireOnPreWrite(PROPERTY_ANALYZES, oldValue, analyzes);
        this.analyzes = analyzes;
        fireOnPostWrite(PROPERTY_ANALYZES, oldValue, analyzes);
    }

    @Override
    public String getAnalyzes() {
        fireOnPreRead(PROPERTY_ANALYZES, analyzes);
        String result = this.analyzes;
        fireOnPostRead(PROPERTY_ANALYZES, analyzes);
        return result;
    }

    @Override
    public void setBotanicControl(boolean botanicControl) {
        boolean oldValue = this.botanicControl;
        fireOnPreWrite(PROPERTY_BOTANIC_CONTROL, oldValue, botanicControl);
        this.botanicControl = botanicControl;
        fireOnPostWrite(PROPERTY_BOTANIC_CONTROL, oldValue, botanicControl);
    }

    @Override
    public boolean isBotanicControl() {
        fireOnPreRead(PROPERTY_BOTANIC_CONTROL, botanicControl);
        boolean result = this.botanicControl;
        fireOnPostRead(PROPERTY_BOTANIC_CONTROL, botanicControl);
        return result;
    }

    @Override
    public boolean getBotanicControl() {
        fireOnPreRead(PROPERTY_BOTANIC_CONTROL, botanicControl);
        boolean result = this.botanicControl;
        fireOnPostRead(PROPERTY_BOTANIC_CONTROL, botanicControl);
        return result;
    }

    @Override
    public void setIdentificationControl(boolean identificationControl) {
        boolean oldValue = this.identificationControl;
        fireOnPreWrite(PROPERTY_IDENTIFICATION_CONTROL, oldValue, identificationControl);
        this.identificationControl = identificationControl;
        fireOnPostWrite(PROPERTY_IDENTIFICATION_CONTROL, oldValue, identificationControl);
    }

    @Override
    public boolean isIdentificationControl() {
        fireOnPreRead(PROPERTY_IDENTIFICATION_CONTROL, identificationControl);
        boolean result = this.identificationControl;
        fireOnPostRead(PROPERTY_IDENTIFICATION_CONTROL, identificationControl);
        return result;
    }

    @Override
    public boolean getIdentificationControl() {
        fireOnPreRead(PROPERTY_IDENTIFICATION_CONTROL, identificationControl);
        boolean result = this.identificationControl;
        fireOnPostRead(PROPERTY_IDENTIFICATION_CONTROL, identificationControl);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //ProductAbstract
