package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class BatchDAOAbstract<E extends Batch> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Batch.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Batch;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Analyze> list = getContext()
                                                    .getDAO(Analyze.class)
                                                    .findAllByProperties(Analyze.PROPERTY_BATCH, entity);
                                            for (Analyze item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Presentation> list = getContext()
                                                    .getDAO(Presentation.class)
                                                    .findAllByProperties(Presentation.PROPERTY_BATCH, entity);
                                            for (Presentation item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(int number) throws TopiaException {
        return findByProperties(Batch.PROPERTY_NUMBER, number);
    }

    public boolean existByNaturalId(int number) throws TopiaException {
        return existByProperties(Batch.PROPERTY_NUMBER, number);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param number 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(int number) throws TopiaException {
        return create(Batch.PROPERTY_NUMBER, number);
    }

    public E createByNaturalId(int number) throws TopiaException {
        return create(Batch.PROPERTY_NUMBER, number);
    }

    public E createByNotNull(int number) throws TopiaException {
        return create(Batch.PROPERTY_NUMBER, number);
    }

    public E findByNumber(int v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_NUMBER, v);
        return result;
    }

    public List<E> findAllByNumber(int v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_NUMBER, v);
        return result;
    }

    public E findByEntryDate(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_ENTRY_DATE, v);
        return result;
    }

    public List<E> findAllByEntryDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_ENTRY_DATE, v);
        return result;
    }

    public E findByDmes(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DMES, v);
        return result;
    }

    public List<E> findAllByDmes(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DMES, v);
        return result;
    }

    public E findByDpmes(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DPMES, v);
        return result;
    }

    public List<E> findAllByDpmes(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DPMES, v);
        return result;
    }

    public E findByDluo(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DLUO, v);
        return result;
    }

    public List<E> findAllByDluo(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DLUO, v);
        return result;
    }

    public E findBySpentDate(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_SPENT_DATE, v);
        return result;
    }

    public List<E> findAllBySpentDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_SPENT_DATE, v);
        return result;
    }

    public E findByQuantity(double v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_QUANTITY, v);
        return result;
    }

    public List<E> findAllByQuantity(double v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_QUANTITY, v);
        return result;
    }

    public E findByPackageCount(int v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_PACKAGE_COUNT, v);
        return result;
    }

    public List<E> findAllByPackageCount(int v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_PACKAGE_COUNT, v);
        return result;
    }

    public E findBySupplier(Supplier v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_SUPPLIER, v);
        return result;
    }

    public List<E> findAllBySupplier(Supplier v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_SUPPLIER, v);
        return result;
    }

    public E findByProduct(Product v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_PRODUCT, v);
        return result;
    }

    public List<E> findAllByProduct(Product v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_PRODUCT, v);
        return result;
    }

    public E findByDedicatedClient(Client v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DEDICATED_CLIENT, v);
        return result;
    }

    public List<E> findAllByDedicatedClient(Client v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DEDICATED_CLIENT, v);
        return result;
    }

    public E findContainsAnalyzeFile(AnalyzeFile v) throws TopiaException {
        E result = findContains(Batch.PROPERTY_ANALYZE_FILE, v);
        return result;
    }

    public List<E> findAllContainsAnalyzeFile(AnalyzeFile v) throws TopiaException {
        List<E> result = findAllContains(Batch.PROPERTY_ANALYZE_FILE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Presentation.class) {
            PresentationDAO dao = (PresentationDAO)
                getContext().getDAO(Presentation.class);
            tmp = dao.findAllByBatch(entity);
            result.addAll(tmp);
        }

        if (type == Analyze.class) {
            AnalyzeDAO dao = (AnalyzeDAO)
                getContext().getDAO(Analyze.class);
            tmp = dao.findAllByBatch(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Presentation.class, entity);
        if (!list.isEmpty()) {
            result.put(Presentation.class, list);
        }

        list = findUsages(Analyze.class, entity);
        if (!list.isEmpty()) {
            result.put(Analyze.class, list);
        }

        return result;
    }

} //BatchDAOAbstract<E extends Batch>
