package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class ProductAbstract extends TopiaEntityAbstract implements Product {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : latinName
     */
    protected String latinName;

    /**
     * Nom de l'attribut en BD : family
     */
    protected String family;

    private static final long serialVersionUID = 3546919190825886769L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, CODE, String.class, code);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, LATIN_NAME, String.class, latinName);
        visitor.visit(this, FAMILY, String.class, family);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(CODE, code);
        String result = this.code;
        fireOnPostRead(CODE, code);
        return result;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
    }

    @Override
    public void setLatinName(String latinName) {
        String oldValue = this.latinName;
        fireOnPreWrite(LATIN_NAME, oldValue, latinName);
        this.latinName = latinName;
        fireOnPostWrite(LATIN_NAME, oldValue, latinName);
    }

    @Override
    public String getLatinName() {
        fireOnPreRead(LATIN_NAME, latinName);
        String result = this.latinName;
        fireOnPostRead(LATIN_NAME, latinName);
        return result;
    }

    @Override
    public void setFamily(String family) {
        String oldValue = this.family;
        fireOnPreWrite(FAMILY, oldValue, family);
        this.family = family;
        fireOnPostWrite(FAMILY, oldValue, family);
    }

    @Override
    public String getFamily() {
        fireOnPreRead(FAMILY, family);
        String result = this.family;
        fireOnPostRead(FAMILY, family);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(CODE, this.code).
            append(NAME, this.name).
            append(LATIN_NAME, this.latinName).
            append(FAMILY, this.family).
         toString();
        return result;
    }

} //ProductAbstract
