package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class BatchDAOAbstract<E extends Batch> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Batch.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Batch;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Analyze> list = getContext()
                                                    .getDAO(Analyze.class)
                                                    .findAllByProperties(Analyze.BATCH, entity);
                                            for (Analyze item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Presentation> list = getContext()
                                                    .getDAO(Presentation.class)
                                                    .findAllByProperties(Presentation.BATCH, entity);
                                            for (Presentation item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Analyze> list = getContext()
                                                    .getDAO(Analyze.class)
                                                    .findAllByProperties(Analyze.BATCH, entity);
                                            for (Analyze item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Presentation> list = getContext()
                                                    .getDAO(Presentation.class)
                                                    .findAllByProperties(Presentation.BATCH, entity);
                                            for (Presentation item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNumber(int v) throws TopiaException {
        E result = findByProperty(Batch.NUMBER, v);
        return result;
    }

    public List<E> findAllByNumber(int v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.NUMBER, v);
        return result;
    }

    public E findByEntryDate(Date v) throws TopiaException {
        E result = findByProperty(Batch.ENTRY_DATE, v);
        return result;
    }

    public List<E> findAllByEntryDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.ENTRY_DATE, v);
        return result;
    }

    public E findByDmes(Date v) throws TopiaException {
        E result = findByProperty(Batch.DMES, v);
        return result;
    }

    public List<E> findAllByDmes(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.DMES, v);
        return result;
    }

    public E findByDpmes(Date v) throws TopiaException {
        E result = findByProperty(Batch.DPMES, v);
        return result;
    }

    public List<E> findAllByDpmes(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.DPMES, v);
        return result;
    }

    public E findByDluo(Date v) throws TopiaException {
        E result = findByProperty(Batch.DLUO, v);
        return result;
    }

    public List<E> findAllByDluo(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.DLUO, v);
        return result;
    }

    public E findBySpentDate(Date v) throws TopiaException {
        E result = findByProperty(Batch.SPENT_DATE, v);
        return result;
    }

    public List<E> findAllBySpentDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.SPENT_DATE, v);
        return result;
    }

    public E findByNewAttr(int v) throws TopiaException {
        E result = findByProperty(Batch.NEW_ATTR, v);
        return result;
    }

    public List<E> findAllByNewAttr(int v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.NEW_ATTR, v);
        return result;
    }

    public E findContainsAnalyze(Analyze v) throws TopiaException {
        E result = findContains(Batch.ANALYZE, v);
        return result;
    }

    public List<E> findAllContainsAnalyze(Analyze v) throws TopiaException {
        List<E> result = findAllContains(Batch.ANALYZE, v);
        return result;
    }

    public E findContainsPresentation(Presentation v) throws TopiaException {
        E result = findContains(Batch.PRESENTATION, v);
        return result;
    }

    public List<E> findAllContainsPresentation(Presentation v) throws TopiaException {
        List<E> result = findAllContains(Batch.PRESENTATION, v);
        return result;
    }

    public E findBySupplier(Supplier v) throws TopiaException {
        E result = findByProperty(Batch.SUPPLIER, v);
        return result;
    }

    public List<E> findAllBySupplier(Supplier v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.SUPPLIER, v);
        return result;
    }

    public E findByProduct(Product v) throws TopiaException {
        E result = findByProperty(Batch.PRODUCT, v);
        return result;
    }

    public List<E> findAllByProduct(Product v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PRODUCT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Presentation.class) {
            PresentationDAO dao = (PresentationDAO)
                getContext().getDAO(Presentation.class);
            tmp = dao.findAllByBatch(entity);
            result.addAll(tmp);
        }

        if (type == Analyze.class) {
            AnalyzeDAO dao = (AnalyzeDAO)
                getContext().getDAO(Analyze.class);
            tmp = dao.findAllByBatch(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Presentation.class, entity);
        if (!list.isEmpty()) {
            result.put(Presentation.class, list);
        }

        list = findUsages(Analyze.class, entity);
        if (!list.isEmpty()) {
            result.put(Analyze.class, list);
        }

        return result;
    }

} //BatchDAOAbstract<E extends Batch>
