/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.locale;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class LocaleParser {
    private static final LocaleParser INSTANCE = new LocaleParser();

    private LocaleParser() {
    }

    public static @Nullable Number parse(String string, @NonNull Locale locale) {
        return LocaleParser.parse(string, locale, (Number)null);
    }

    public static @Nullable Number parse(String string, @NonNull Locale locale, @Nullable Number number) {
        return LocaleParser.parse(string, NumberFormat.getInstance(locale), number);
    }

    public static @Nullable Number parse(@Nullable String string, @NonNull NumberFormat numberFormat) {
        return LocaleParser.parse(string, numberFormat, (Number)null);
    }

    public static @Nullable Number parse(@Nullable String string, @NonNull NumberFormat numberFormat, @Nullable Number number) {
        ValueEnforcer.notNull((Object)numberFormat, (String)"NumberFormat");
        if (string != null) {
            try {
                return numberFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return number;
    }

    public static float parseFloat(@Nullable String string, @NonNull Locale locale, float f) {
        return LocaleParser.parseFloat(string, NumberFormat.getInstance(locale), f);
    }

    public static float parseFloat(@Nullable String string, @NonNull NumberFormat numberFormat, float f) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? f : number.floatValue();
    }

    public static double parseDouble(@Nullable String string, @NonNull Locale locale, double d) {
        return LocaleParser.parseDouble(string, NumberFormat.getInstance(locale), d);
    }

    public static double parseDouble(@Nullable String string, @NonNull NumberFormat numberFormat, double d) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? d : number.doubleValue();
    }

    public static byte parseByte(@Nullable String string, @NonNull Locale locale, byte by) {
        return LocaleParser.parseByte(string, NumberFormat.getIntegerInstance(locale), by);
    }

    public static byte parseByte(@Nullable String string, @NonNull NumberFormat numberFormat, byte by) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? by : number.byteValue();
    }

    public static int parseInt(@Nullable String string, @NonNull Locale locale, int n) {
        return LocaleParser.parseInt(string, NumberFormat.getIntegerInstance(locale), n);
    }

    public static int parseInt(@Nullable String string, @NonNull NumberFormat numberFormat, int n) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? n : number.intValue();
    }

    public static long parseLong(@Nullable String string, @NonNull Locale locale, long l) {
        return LocaleParser.parseLong(string, NumberFormat.getIntegerInstance(locale), l);
    }

    public static long parseLong(@Nullable String string, @NonNull NumberFormat numberFormat, long l) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? l : number.longValue();
    }

    public static short parseShort(@Nullable String string, @NonNull Locale locale, short s) {
        return LocaleParser.parseShort(string, NumberFormat.getIntegerInstance(locale), s);
    }

    public static short parseShort(@Nullable String string, @NonNull NumberFormat numberFormat, short s) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? s : number.shortValue();
    }

    public static @Nullable BigDecimal parseBigDecimal(@Nullable String string, @NonNull Locale locale) {
        return LocaleParser.parseBigDecimal(string, locale, (BigDecimal)null);
    }

    public static @Nullable BigDecimal parseBigDecimal(@Nullable String string, @NonNull Locale locale, @Nullable BigDecimal bigDecimal) {
        return LocaleParser.parseBigDecimal(string, NumberFormat.getInstance(locale), bigDecimal);
    }

    public static @Nullable BigDecimal parseBigDecimal(@Nullable String string, @NonNull DecimalFormat decimalFormat) {
        return LocaleParser.parseBigDecimal(string, decimalFormat, (BigDecimal)null);
    }

    public static @Nullable BigDecimal parseBigDecimal(@Nullable String string, @NonNull DecimalFormat decimalFormat, @Nullable BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)decimalFormat, (String)"NumberFormat");
        decimalFormat.setParseBigDecimal(true);
        return (BigDecimal)LocaleParser.parse(string, decimalFormat, (Number)bigDecimal);
    }

    public static @Nullable BigDecimal parseBigDecimal(@Nullable String string, @NonNull NumberFormat numberFormat) {
        return LocaleParser.parseBigDecimal(string, numberFormat, (BigDecimal)null);
    }

    public static @Nullable BigDecimal parseBigDecimal(@Nullable String string, @NonNull NumberFormat numberFormat, @Nullable BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = null;
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            bigDecimal2 = LocaleParser.parseBigDecimal(string, decimalFormat);
        } else {
            Number number = LocaleParser.parse(string, numberFormat);
            if (number != null) {
                bigDecimal2 = BigDecimal.valueOf(number.doubleValue());
            }
        }
        return bigDecimal2 == null ? bigDecimal : bigDecimal2;
    }
}

