/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.domain;

import com.helger.base.enforce.ValueEnforcer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IHasDeletionDateTime {
    public @Nullable LocalDateTime getDeletionDateTime();

    default public boolean hasDeletionDateTime() {
        return this.getDeletionDateTime() != null;
    }

    default public @Nullable LocalDate getDeletionDate() {
        LocalDateTime localDateTime = this.getDeletionDateTime();
        return localDateTime == null ? null : localDateTime.toLocalDate();
    }

    default public @Nullable LocalTime getDeletionTime() {
        LocalDateTime localDateTime = this.getDeletionDateTime();
        return localDateTime == null ? null : localDateTime.toLocalTime();
    }

    default public boolean isDeletedAt(@NonNull LocalDateTime localDateTime) {
        ValueEnforcer.notNull((Object)localDateTime, (String)"LocalDateTime");
        return this.hasDeletionDateTime() && this.getDeletionDateTime().compareTo(localDateTime) <= 0;
    }
}

