/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.commons;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.state.EChange;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsCollection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ICommonsList<ELEMENTTYPE>
extends List<ELEMENTTYPE>,
ICommonsCollection<ELEMENTTYPE>,
ICloneable<ICommonsList<ELEMENTTYPE>> {
    @ReturnsMutableCopy
    default public <T> @NonNull ICommonsList<T> createInstance() {
        return new CommonsArrayList();
    }

    @ReturnsMutableCopy
    default public @NonNull ICommonsList<ELEMENTTYPE> getAll(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return (ICommonsList)this.getClone();
        }
        ICommonsList iCommonsList = this.createInstance();
        this.findAll(predicate, iCommonsList::add);
        return iCommonsList;
    }

    @ReturnsMutableCopy
    default public <DSTTYPE> @NonNull ICommonsList<DSTTYPE> getAllMapped(@NonNull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllMapped(function, iCommonsList::add);
        return iCommonsList;
    }

    @ReturnsMutableCopy
    default public <DSTTYPE> @NonNull ICommonsList<DSTTYPE> getAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @NonNull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllMapped(predicate, function, iCommonsList::add);
        return iCommonsList;
    }

    @ReturnsMutableCopy
    default public <DSTTYPE extends ELEMENTTYPE> @NonNull ICommonsList<DSTTYPE> getAllInstanceOf(@NonNull Class<DSTTYPE> clazz) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllInstanceOf(clazz, iCommonsList::add);
        return iCommonsList;
    }

    default public @Nullable ELEMENTTYPE getFirstOrNull() {
        return this.getFirst(null);
    }

    default public @Nullable ELEMENTTYPE getFirst(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(this.isEmpty() ? ELEMENTTYPE : this.get(0));
    }

    default public @Nullable ELEMENTTYPE getLastOrNull() {
        return this.getLast(null);
    }

    default public @Nullable ELEMENTTYPE getLast(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        int n = this.size();
        return (ELEMENTTYPE)(n == 0 ? ELEMENTTYPE : this.get(n - 1));
    }

    @Override
    default public @Nullable ELEMENTTYPE getAtIndex(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(n >= 0 && n < this.size() ? this.get(n) : ELEMENTTYPE);
    }

    default public @Nullable ELEMENTTYPE setFirst(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.set(0, ELEMENTTYPE);
    }

    default public @Nullable ELEMENTTYPE setLast(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.set(this.size() - 1, ELEMENTTYPE);
    }

    default public @NonNull EChange removeAtIndex(int n) {
        if (n < 0 || n >= this.size()) {
            return EChange.UNCHANGED;
        }
        this.remove(n);
        return EChange.CHANGED;
    }

    default public @Nullable ELEMENTTYPE removeAndReturnElementAtIndex(int n) {
        return n < 0 || n >= this.size() ? null : (ELEMENTTYPE)this.remove(n);
    }

    default public @Nullable ELEMENTTYPE removeFirstOrNull() {
        return this.isEmpty() ? null : (ELEMENTTYPE)this.remove(0);
    }

    default public @Nullable ELEMENTTYPE removeLastOrNull() {
        int n = this.size();
        return n == 0 ? null : (ELEMENTTYPE)this.remove(n - 1);
    }

    @Override
    @CodingStyleguideUnaware
    default public @NonNull List<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableList(this);
    }

    default public @NonNull ICommonsList<ELEMENTTYPE> getSortedInline(@NonNull Comparator<? super ELEMENTTYPE> comparator) {
        this.sort(comparator);
        return this;
    }

    default public @NonNull ICommonsList<ELEMENTTYPE> reverse() {
        Collections.reverse(this);
        return this;
    }

    default public @NonNull ICommonsList<ELEMENTTYPE> swapItems(int n, int n2) {
        if (n != n2) {
            Object e = this.get(n);
            this.set(n, this.get(n2));
            this.set(n2, e);
        }
        return this;
    }
}

