/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.genericdao.search.hibernate;

import com.googlecode.genericdao.search.ExampleOptions;
import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.SearchFacade;
import com.googlecode.genericdao.search.SearchResult;
import com.googlecode.genericdao.search.hibernate.HibernateSearchProcessor;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateSearchFacade
implements SearchFacade {
    private SessionFactory sessionFactory;
    private HibernateSearchProcessor processor;

    public HibernateSearchFacade() {
    }

    public HibernateSearchFacade(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.processor = HibernateSearchProcessor.getInstanceForSessionFactory(sessionFactory);
        this.sessionFactory = sessionFactory;
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected HibernateSearchProcessor getProcessor() {
        return this.processor;
    }

    public List search(ISearch search) {
        return this.processor.search(this.getSession(), search);
    }

    public List search(Class<?> searchClass, ISearch search) {
        return this.processor.search(this.getSession(), searchClass, search);
    }

    public int count(ISearch search) {
        return this.processor.count(this.getSession(), search);
    }

    public int count(Class<?> searchClass, ISearch search) {
        return this.processor.count(this.getSession(), searchClass, search);
    }

    public SearchResult searchAndCount(ISearch search) {
        return this.processor.searchAndCount(this.getSession(), search);
    }

    public SearchResult searchAndCount(Class<?> searchClass, ISearch search) {
        return this.processor.searchAndCount(this.getSession(), searchClass, search);
    }

    public Object searchUnique(ISearch search) {
        return this.processor.searchUnique(this.getSession(), search);
    }

    public Object searchUnique(Class<?> searchClass, ISearch search) {
        return this.processor.searchUnique(this.getSession(), searchClass, search);
    }

    public Filter getFilterFromExample(Object example) {
        return this.processor.getFilterFromExample(example);
    }

    public Filter getFilterFromExample(Object example, ExampleOptions options) {
        return this.processor.getFilterFromExample(example, options);
    }
}

