/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReplaceStrings
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType BAD_REPLACEMENT_CONFIGURATION = DiagnosticType.warning("JSC_BAD_REPLACEMENT_CONFIGURATION", "Bad replacement configuration.");
    private static final String DEFAULT_PLACEHOLDER_TOKEN = "`";
    private final String placeholderToken;
    private static final String REPLACE_ONE_MARKER = "?";
    private static final String REPLACE_ALL_MARKER = "*";
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final Map<String, Config> functions = Maps.newHashMap();
    private final Multimap<String, String> methods = HashMultimap.create();
    private final NameGenerator nameGenerator;
    private final Map<String, Result> results = Maps.newLinkedHashMap();
    static final Predicate<Result> USED_RESULTS = new Predicate<Result>(){

        public boolean apply(Result result) {
            return !result.replacementLocations.isEmpty();
        }
    };

    ReplaceStrings(AbstractCompiler compiler, String placeholderToken, List<String> functionsToInspect, Set<String> blacklisted, VariableMap previousMappings) {
        this.compiler = compiler;
        this.placeholderToken = placeholderToken.isEmpty() ? DEFAULT_PLACEHOLDER_TOKEN : placeholderToken;
        this.registry = compiler.getTypeRegistry();
        Iterable<String> reservedNames = blacklisted;
        if (previousMappings != null) {
            Set<String> previous = previousMappings.getOriginalNameToNewNameMap().keySet();
            reservedNames = Iterables.concat(blacklisted, previous);
            this.initMapping(previousMappings, blacklisted);
        }
        this.nameGenerator = ReplaceStrings.createNameGenerator(reservedNames);
        this.parseConfiguration(functionsToInspect);
    }

    private void initMapping(VariableMap previousVarMap, Set<String> reservedNames) {
        Map<String, String> previous = previousVarMap.getOriginalNameToNewNameMap();
        for (Map.Entry<String, String> entry : previous.entrySet()) {
            String key = entry.getKey();
            if (reservedNames.contains(key)) continue;
            String value = entry.getValue();
            this.results.put(value, new Result(value, key));
        }
    }

    List<Result> getResult() {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.results.values(), USED_RESULTS));
    }

    VariableMap getStringMap() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Result result : Iterables.filter(this.results.values(), USED_RESULTS)) {
            map.put((Object)result.replacement, (Object)result.original);
        }
        VariableMap stringMap = new VariableMap((Map<String, String>)map.build());
        return stringMap;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 30: 
            case 37: {
                JSType type;
                Config config;
                Node lhs;
                String methodName;
                Collection classes;
                Node rhs;
                Config config2;
                Node calledFn = n.getFirstChild();
                String name = calledFn.getQualifiedName();
                if (name != null && (config2 = this.findMatching(name)) != null) {
                    this.doSubstitutions(t, config2, n);
                    return;
                }
                if (!NodeUtil.isGet(calledFn) || !(rhs = calledFn.getLastChild()).isName() && !rhs.isString() || (classes = this.methods.get((Object)(methodName = rhs.getString()))) == null || (lhs = calledFn.getFirstChild()).getJSType() == null || (config = this.findMatchingClass(type = lhs.getJSType().restrictByNotNullOrUndefined(), classes)) == null) break;
                this.doSubstitutions(t, config, n);
                return;
            }
        }
    }

    private Config findMatching(String name) {
        Config config = this.functions.get(name);
        if (config == null) {
            name = name.replace('$', '.');
            config = this.functions.get(name);
        }
        return config;
    }

    private Config findMatchingClass(JSType callClassType, Collection<String> declarationNames) {
        if (!callClassType.isNoObjectType() && !callClassType.isUnknownType()) {
            for (String declarationName : declarationNames) {
                String className = this.getClassFromDeclarationName(declarationName);
                JSType methodClassType = this.registry.getType(className);
                if (methodClassType == null || !callClassType.isSubtype(methodClassType)) continue;
                return this.functions.get(declarationName);
            }
        }
        return null;
    }

    private void doSubstitutions(NodeTraversal t, Config config, Node n) {
        Preconditions.checkState((n.isNew() || n.isCall() ? 1 : 0) != 0);
        if (config.parameter != 0) {
            Node arg = n.getChildAtIndex(config.parameter);
            if (arg != null) {
                this.replaceExpression(t, arg, n);
            }
        } else {
            Node firstParam;
            for (Node arg = firstParam = n.getFirstChild().getNext(); arg != null; arg = arg.getNext()) {
                arg = this.replaceExpression(t, arg, n);
            }
        }
    }

    private Node replaceExpression(NodeTraversal t, Node expr, Node parent) {
        Node replacement;
        String replacementString;
        String key = null;
        switch (expr.getType()) {
            case 40: {
                key = expr.getString();
                replacementString = this.getReplacement(key);
                replacement = IR.string(replacementString);
                break;
            }
            case 21: {
                StringBuilder keyBuilder = new StringBuilder();
                Node keyNode = IR.string("");
                replacement = this.buildReplacement(expr, keyNode, keyBuilder);
                key = keyBuilder.toString();
                replacementString = this.getReplacement(key);
                keyNode.setString(replacementString);
                break;
            }
            case 38: {
                Node value;
                Scope.Var var = t.getScope().getVar(expr.getString());
                if (var != null && var.isConst() && (value = var.getInitialValue()) != null && value.isString()) {
                    key = value.getString();
                    replacementString = this.getReplacement(key);
                    replacement = IR.string(replacementString);
                    break;
                }
                return expr;
            }
            default: {
                return expr;
            }
        }
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)replacementString);
        this.recordReplacement(expr, key);
        parent.replaceChild(expr, replacement);
        this.compiler.reportCodeChange();
        return replacement;
    }

    private String getReplacement(String key) {
        Result result = this.results.get(key);
        if (result != null) {
            return result.replacement;
        }
        String replacement = this.nameGenerator.generateNextName();
        result = new Result(key, replacement);
        this.results.put(key, result);
        return replacement;
    }

    private void recordReplacement(Node n, String key) {
        Result result = this.results.get(key);
        Preconditions.checkState((result != null ? 1 : 0) != 0);
        result.addLocation(n);
    }

    private Node buildReplacement(Node expr, Node prefix, StringBuilder keyBuilder) {
        switch (expr.getType()) {
            case 21: {
                Node left = expr.getFirstChild();
                Node right = left.getNext();
                prefix = this.buildReplacement(left, prefix, keyBuilder);
                return this.buildReplacement(right, prefix, keyBuilder);
            }
            case 40: {
                keyBuilder.append(expr.getString());
                return prefix;
            }
        }
        keyBuilder.append(this.placeholderToken);
        prefix = IR.add(prefix, IR.string(this.placeholderToken));
        return IR.add(prefix, expr.cloneTree());
    }

    private String getMethodFromDeclarationName(String fullDeclarationName) {
        String[] parts = fullDeclarationName.split("\\.prototype\\.");
        Preconditions.checkState((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0);
        if (parts.length == 2) {
            return parts[1];
        }
        return null;
    }

    private String getClassFromDeclarationName(String fullDeclarationName) {
        String[] parts = fullDeclarationName.split("\\.prototype\\.");
        Preconditions.checkState((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0);
        if (parts.length == 2) {
            return parts[0];
        }
        return null;
    }

    private void parseConfiguration(List<String> functionsToInspect) {
        for (String function : functionsToInspect) {
            Config config = this.parseConfiguration(function);
            this.functions.put(config.name, config);
            String method = this.getMethodFromDeclarationName(config.name);
            if (method == null) continue;
            this.methods.put((Object)method, (Object)config.name);
        }
    }

    private Config parseConfiguration(String function) {
        String[] parts;
        int first = function.indexOf(40);
        int last = function.indexOf(41);
        Preconditions.checkState((first != -1 && last != -1 ? 1 : 0) != 0);
        String name = function.substring(0, first);
        String params = function.substring(first + 1, last);
        int paramCount = 0;
        int replacementParameter = -1;
        for (String param : parts = params.split(",")) {
            ++paramCount;
            if (param.equals(REPLACE_ALL_MARKER)) {
                Preconditions.checkState((paramCount == 1 && parts.length == 1 ? 1 : 0) != 0);
                replacementParameter = 0;
                continue;
            }
            if (param.equals(REPLACE_ONE_MARKER)) {
                Preconditions.checkState((replacementParameter == -1 ? 1 : 0) != 0);
                replacementParameter = paramCount;
                continue;
            }
            Preconditions.checkState((boolean)param.isEmpty(), (String)"Unknown marker", (Object[])new Object[]{param});
        }
        Preconditions.checkState((replacementParameter != -1 ? 1 : 0) != 0);
        return new Config(name, replacementParameter);
    }

    private static NameGenerator createNameGenerator(Iterable<String> reserved) {
        String namePrefix = "";
        char[] reservedChars = new char[]{};
        return new NameGenerator((Set<String>)ImmutableSet.copyOf(reserved), "", reservedChars);
    }

    class Location {
        public final String sourceFile;
        public final int line;
        public final int column;

        Location(String sourceFile, int line, int column) {
            this.sourceFile = sourceFile;
            this.line = line;
            this.column = column;
        }
    }

    class Result {
        public final String original;
        public final String replacement;
        public final List<Location> replacementLocations = Lists.newLinkedList();

        Result(String original, String replacement) {
            this.original = original;
            this.replacement = replacement;
        }

        void addLocation(Node n) {
            this.replacementLocations.add(new Location(n.getSourceFileName(), n.getLineno(), n.getCharno()));
        }
    }

    private class Config {
        final String name;
        final int parameter;
        static final int REPLACE_ALL_VALUE = 0;

        Config(String name, int parameter) {
            this.name = name;
            this.parameter = parameter;
        }
    }
}

