/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.logging.Logger;

public class JsAst
implements SourceAst {
    private static final Logger logger_ = Logger.getLogger(JsAst.class.getName());
    private static final long serialVersionUID = 1L;
    private transient SourceFile sourceFile;
    private String fileName;
    private Node root;

    public JsAst(SourceFile sourceFile) {
        this.sourceFile = sourceFile;
        this.fileName = sourceFile.getName();
    }

    @Override
    public Node getAstRoot(AbstractCompiler abstractCompiler) {
        if (this.root == null) {
            this.createAst(abstractCompiler);
        }
        return this.root;
    }

    @Override
    public void clearAst() {
        this.root = null;
        this.sourceFile.clearCachedSource();
    }

    @Override
    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(SourceFile sourceFile) {
        Preconditions.checkState((boolean)this.fileName.equals(sourceFile.getName()));
        this.sourceFile = sourceFile;
    }

    private void createAst(AbstractCompiler abstractCompiler) {
        try {
            this.parse(abstractCompiler, this.sourceFile.getName(), this.sourceFile.getCode());
        }
        catch (IOException iOException) {
            abstractCompiler.report(JSError.make(AbstractCompiler.READ_ERROR, this.sourceFile.getName()));
        }
    }

    private void parse(AbstractCompiler abstractCompiler, String string, String string2) {
        try {
            logger_.fine("Parsing: " + string);
            this.root = ParserRunner.parse(string, string2, abstractCompiler.getParserConfig(), abstractCompiler.getDefaultErrorReporter(), logger_);
        }
        catch (IOException iOException) {
            abstractCompiler.report(JSError.make(AbstractCompiler.READ_ERROR, string));
        }
        if (this.root == null || abstractCompiler.hasHaltingErrors()) {
            this.root = new Node(125);
        } else {
            abstractCompiler.prepareAst(this.root);
        }
        this.root.putProp(16, string);
    }
}

