/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class TypedScopeCreator
implements ScopeCreator {
    static final String DELEGATE_PROXY_SUFFIX = ObjectType.createDelegateSuffix("Proxy");
    private static final String LEGACY_TYPEDEF = "goog.typedef";
    static final DiagnosticType MALFORMED_TYPEDEF = DiagnosticType.warning("JSC_MALFORMED_TYPEDEF", "Typedef for {0} does not have any type information");
    static final DiagnosticType ENUM_INITIALIZER = DiagnosticType.warning("JSC_ENUM_INITIALIZER_NOT_ENUM", "enum initializer must be an object literal or an enum");
    static final DiagnosticType CTOR_INITIALIZER = DiagnosticType.warning("JSC_CTOR_INITIALIZER_NOT_CTOR", "Constructor {0} must be initialized at declaration");
    static final DiagnosticType IFACE_INITIALIZER = DiagnosticType.warning("JSC_IFACE_INITIALIZER_NOT_IFACE", "Interface {0} must be initialized at declaration");
    static final DiagnosticType CONSTRUCTOR_EXPECTED = DiagnosticType.warning("JSC_REFLECT_CONSTRUCTOR_EXPECTED", "Constructor expected as first argument");
    static final DiagnosticType UNKNOWN_LENDS = DiagnosticType.warning("JSC_UNKNOWN_LENDS", "Variable {0} not declared before @lends annotation.");
    static final DiagnosticType LENDS_ON_NON_OBJECT = DiagnosticType.warning("JSC_LENDS_ON_NON_OBJECT", "May only lend properties to object types. {0} has type {1}.");
    private final AbstractCompiler compiler;
    private final ErrorReporter typeParsingErrorReporter;
    private final TypeValidator validator;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private List<ObjectType> delegateProxyPrototypes = Lists.newArrayList();

    TypedScopeCreator(AbstractCompiler abstractCompiler) {
        this(abstractCompiler, abstractCompiler.getCodingConvention());
    }

    TypedScopeCreator(AbstractCompiler abstractCompiler, CodingConvention codingConvention) {
        this.compiler = abstractCompiler;
        this.validator = abstractCompiler.getTypeValidator();
        this.codingConvention = codingConvention;
        this.typeRegistry = abstractCompiler.getTypeRegistry();
        this.typeParsingErrorReporter = this.typeRegistry.getErrorReporter();
    }

    @Override
    public Scope createScope(Node node, Scope scope) {
        Object object;
        Scope scope2 = null;
        GlobalScopeBuilder globalScopeBuilder = null;
        if (scope == null) {
            scope2 = this.createInitialScope(node);
            object = new GlobalScopeBuilder(scope2);
            globalScopeBuilder = object;
            NodeTraversal.traverse(this.compiler, node, globalScopeBuilder);
        } else {
            scope2 = new Scope(scope, node);
            object = new LocalScopeBuilder(scope2);
            globalScopeBuilder = object;
            ((LocalScopeBuilder)object).build();
        }
        globalScopeBuilder.resolveStubDeclarations();
        globalScopeBuilder.resolveTypes();
        for (Node node2 : ((AbstractScopeBuilder)globalScopeBuilder).nonExternFunctions) {
            FunctionType functionType;
            ObjectType objectType;
            JSType jSType = node2.getJSType();
            if (jSType == null || !(jSType instanceof FunctionType) || (objectType = (functionType = (FunctionType)jSType).getTypeOfThis()).isUnknownType()) continue;
            Node node3 = node2.getLastChild();
            GlobalScopeBuilder globalScopeBuilder2 = globalScopeBuilder;
            globalScopeBuilder2.getClass();
            NodeTraversal.traverse(this.compiler, node3, globalScopeBuilder2.new AbstractScopeBuilder.CollectProperties(objectType));
        }
        if (scope == null) {
            this.codingConvention.defineDelegateProxyPrototypeProperties(this.typeRegistry, scope2, this.delegateProxyPrototypes);
        }
        return scope2;
    }

    @VisibleForTesting
    Scope createInitialScope(Node node) {
        NodeTraversal.traverse(this.compiler, node, new DiscoverEnumsAndTypedefs(this.typeRegistry));
        Scope scope = new Scope(node, this.compiler);
        this.declareNativeFunctionType(scope, JSTypeNative.ARRAY_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.DATE_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.EVAL_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.FUNCTION_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.RANGE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.REGEXP_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.STRING_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.TYPE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(scope, JSTypeNative.URI_ERROR_FUNCTION_TYPE);
        this.declareNativeValueType(scope, "undefined", JSTypeNative.VOID_TYPE);
        this.declareNativeValueType(scope, LEGACY_TYPEDEF, JSTypeNative.NO_TYPE);
        this.declareNativeValueType(scope, "ActiveXObject", JSTypeNative.NO_OBJECT_TYPE);
        return scope;
    }

    private void declareNativeFunctionType(Scope scope, JSTypeNative jSTypeNative) {
        FunctionType functionType = this.typeRegistry.getNativeFunctionType(jSTypeNative);
        this.declareNativeType(scope, functionType.getInstanceType().getReferenceName(), functionType);
        this.declareNativeType(scope, functionType.getPrototype().getReferenceName(), functionType.getPrototype());
    }

    private void declareNativeValueType(Scope scope, String string, JSTypeNative jSTypeNative) {
        this.declareNativeType(scope, string, this.typeRegistry.getNativeType(jSTypeNative));
    }

    private void declareNativeType(Scope scope, String string, JSType jSType) {
        scope.declare(string, null, jSType, null, false);
    }

    private static Node getPrototypePropertyOwner(Node node) {
        Node node2;
        Node node3;
        if (node.getType() == 33 && (node3 = node.getFirstChild()).getType() == 33 && node3.getLastChild().getString().equals("prototype") && (node2 = node3.getFirstChild()).isQualifiedName()) {
            return node2;
        }
        return null;
    }

    private JSType getNativeType(JSTypeNative jSTypeNative) {
        return this.typeRegistry.getNativeType(jSTypeNative);
    }

    private final class LocalScopeBuilder
    extends AbstractScopeBuilder {
        private LocalScopeBuilder(Scope scope) {
            super(scope);
        }

        void build() {
            NodeTraversal.traverse(TypedScopeCreator.this.compiler, this.scope.getRootNode(), this);
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node == this.scope.getRootNode()) {
                return;
            }
            if (node.getType() == 83 && node2 == this.scope.getRootNode()) {
                this.handleFunctionInputs(node2);
                return;
            }
            super.visit(nodeTraversal, node, node2);
        }

        private void handleFunctionInputs(Node node) {
            Scope.Var var;
            Node node2 = node.getFirstChild();
            String string = node2.getString();
            if (!string.isEmpty() && ((var = this.scope.getVar(string)) == null || var.getNameNode() != null && var.getInitialValue() != node)) {
                this.defineSlot(node2, node, node.getJSType(), false);
            }
            this.declareArguments(node);
        }

        private void declareArguments(Node node) {
            Node node2;
            Node node3 = node.getFirstChild().getNext();
            Node node4 = node3.getNext();
            FunctionType functionType = (FunctionType)node.getJSType();
            if (functionType != null && (node2 = functionType.getParametersNode()) != null) {
                Node node5 = node2.getFirstChild();
                for (Node node6 : node3.children()) {
                    if (node5 != null) {
                        this.defineSlot(node6, node, node5.getJSType(), true);
                        node5 = node5.getNext();
                        continue;
                    }
                    this.defineSlot(node6, node, null, true);
                }
            }
        }
    }

    private final class GlobalScopeBuilder
    extends AbstractScopeBuilder {
        private GlobalScopeBuilder(Scope scope) {
            super(scope);
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            super.visit(nodeTraversal, node, node2);
            switch (node.getType()) {
                case 86: {
                    this.checkForOldStyleTypedef(nodeTraversal, node);
                    break;
                }
                case 118: {
                    if (!node.hasOneChild()) break;
                    this.checkForOldStyleTypedef(nodeTraversal, node);
                    this.checkForTypedef(nodeTraversal, node.getFirstChild(), node.getJSDocInfo());
                }
            }
        }

        @Override
        void maybeDeclareQualifiedName(NodeTraversal nodeTraversal, JSDocInfo jSDocInfo, Node node, Node node2, Node node3) {
            this.checkForTypedef(nodeTraversal, node, jSDocInfo);
            super.maybeDeclareQualifiedName(nodeTraversal, jSDocInfo, node, node2, node3);
        }

        private void checkForTypedef(NodeTraversal nodeTraversal, Node node, JSDocInfo jSDocInfo) {
            if (jSDocInfo == null || !jSDocInfo.hasTypedefType()) {
                return;
            }
            String string = node.getQualifiedName();
            if (string == null) {
                return;
            }
            TypedScopeCreator.this.typeRegistry.declareType(string, TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            JSType jSType = jSDocInfo.getTypedefType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
            if (jSType == null) {
                TypedScopeCreator.this.compiler.report(JSError.make(nodeTraversal.getSourceName(), node, MALFORMED_TYPEDEF, string));
            }
            TypedScopeCreator.this.typeRegistry.overwriteDeclaredType(string, jSType);
            if (node.getType() == 33) {
                this.defineSlot(node, node.getParent(), TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE), false);
            }
        }

        private void checkForOldStyleTypedef(NodeTraversal nodeTraversal, Node node) {
            String string = TypedScopeCreator.this.codingConvention.identifyTypeDefAssign(node);
            if (string != null) {
                TypedScopeCreator.this.typeRegistry.declareType(string, TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                JSDocInfo jSDocInfo = node.getJSDocInfo();
                JSType jSType = null;
                if (jSDocInfo != null && jSDocInfo.getType() != null) {
                    jSType = jSDocInfo.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                }
                if (jSType == null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(nodeTraversal.getSourceName(), node, MALFORMED_TYPEDEF, string));
                }
                TypedScopeCreator.this.typeRegistry.overwriteDeclaredType(string, jSType);
            }
        }
    }

    private static final class StubDeclaration {
        private final Node node;
        private final boolean isExtern;
        private final String ownerName;

        private StubDeclaration(Node node, boolean bl, String string) {
            this.node = node;
            this.isExtern = bl;
            this.ownerName = string;
        }
    }

    private abstract class AbstractScopeBuilder
    implements NodeTraversal.Callback {
        final Scope scope;
        private final List<DeferredSetType> deferredSetTypes = Lists.newArrayList();
        private final List<Node> nonExternFunctions = Lists.newArrayList();
        private final List<StubDeclaration> stubDeclarations = Lists.newArrayList();
        private String sourceName = null;

        private AbstractScopeBuilder(Scope scope) {
            this.scope = scope;
        }

        void setDeferredType(Node node, JSType jSType) {
            this.deferredSetTypes.add(new DeferredSetType(node, jSType));
        }

        void resolveTypes() {
            for (DeferredSetType deferredSetType : this.deferredSetTypes) {
                deferredSetType.resolve(this.scope);
            }
            Iterator<Object> iterator = this.scope.getVars();
            while (iterator.hasNext()) {
                ((Scope.Var)iterator.next()).resolveType(TypedScopeCreator.this.typeParsingErrorReporter);
            }
            TypedScopeCreator.this.typeRegistry.resolveTypesInScope(this.scope);
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 105 || node.getType() == 132) {
                this.sourceName = (String)node.getProp(16);
            }
            return node2 == null || node2.getType() != 105 || node == node2.getFirstChild() || node2 == this.scope.getRootNode();
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            this.attachLiteralTypes(node);
            switch (node.getType()) {
                case 37: {
                    this.checkForClassDefiningCalls(nodeTraversal, node, node2);
                    break;
                }
                case 105: {
                    if (nodeTraversal.getInput() == null || !nodeTraversal.getInput().isExtern()) {
                        this.nonExternFunctions.add(node);
                    }
                    if (node2.getType() == 86 || node2.getType() == 38) break;
                    this.defineDeclaredFunction(node, node2);
                    break;
                }
                case 86: {
                    this.defineNamedTypeAssign(node, node2);
                    Node node3 = node.getFirstChild();
                    if (node3.getType() != 33 || !node3.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(nodeTraversal, node.getJSDocInfo(), node3, node, node3.getNext());
                    break;
                }
                case 120: {
                    this.defineCatch(node, node2);
                    break;
                }
                case 118: {
                    this.defineVar(node, node2);
                    break;
                }
                case 33: {
                    if (node2.getType() != 130 || !node.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(nodeTraversal, node.getJSDocInfo(), node, node2, null);
                }
            }
        }

        private void attachLiteralTypes(Node node) {
            switch (node.getType()) {
                case 41: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NULL_TYPE));
                    break;
                }
                case 122: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.VOID_TYPE));
                    break;
                }
                case 40: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.STRING_TYPE));
                    break;
                }
                case 39: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NUMBER_TYPE));
                    break;
                }
                case 43: 
                case 44: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                    break;
                }
                case 47: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.REGEXP_TYPE));
                    break;
                }
                case 69: {
                    node.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                    break;
                }
                case 64: {
                    this.processObjectLit(node);
                }
            }
        }

        private void processObjectLit(Node node) {
            JSDocInfo jSDocInfo = node.getJSDocInfo();
            if (jSDocInfo != null && jSDocInfo.getLendsName() != null) {
                String string = jSDocInfo.getLendsName();
                Scope.Var var = this.scope.getVar(string);
                if (var == null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, UNKNOWN_LENDS, string));
                } else {
                    JSType jSType = var.getType();
                    if (jSType == null) {
                        jSType = TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                    }
                    if (!jSType.isSubtype(TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                        TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, LENDS_ON_NON_OBJECT, string, jSType.toString()));
                    } else {
                        node.setJSType(jSType);
                    }
                }
            }
            if (node.getJSType() == null) {
                node.setJSType(TypedScopeCreator.this.typeRegistry.createAnonymousObjectType());
            }
        }

        JSType getDeclaredTypeInAnnotation(NodeTraversal nodeTraversal, Node node, JSDocInfo jSDocInfo) {
            return this.getDeclaredTypeInAnnotation(nodeTraversal.getSourceName(), node, jSDocInfo);
        }

        JSType getDeclaredTypeInAnnotation(String string, Node node, JSDocInfo jSDocInfo) {
            Node node2;
            JSType jSType = null;
            Node node3 = node2 = node.getType() == 33 ? node.getFirstChild() : null;
            if (jSDocInfo != null) {
                if (jSDocInfo.hasType()) {
                    jSType = jSDocInfo.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                } else if (FunctionTypeBuilder.isFunctionTypeDeclaration(jSDocInfo)) {
                    String string2 = node.getQualifiedName();
                    if (jSDocInfo.isConstructor() && TypedScopeCreator.this.typeRegistry.getType(string2) != null) {
                        return null;
                    }
                    FunctionTypeBuilder functionTypeBuilder = new FunctionTypeBuilder(string2, TypedScopeCreator.this.compiler, node, string, this.scope).inferTemplateTypeName(jSDocInfo).inferReturnType(jSDocInfo).inferParameterTypes(jSDocInfo).inferInheritance(jSDocInfo);
                    boolean bl = false;
                    if (node2 != null) {
                        if (node2.getType() == 33 && node2.getLastChild().getString().equals("prototype")) {
                            functionTypeBuilder.inferThisType(jSDocInfo, node2.getFirstChild());
                            bl = true;
                        } else if (node2.getType() == 42) {
                            functionTypeBuilder.inferThisType(jSDocInfo, node2.getJSType());
                            bl = true;
                        }
                    }
                    if (!bl) {
                        functionTypeBuilder.inferThisType(jSDocInfo, (Node)null);
                    }
                    jSType = functionTypeBuilder.buildAndRegister();
                }
            }
            return jSType;
        }

        void assertDefinitionNode(Node node, int n) {
            Preconditions.checkState((this.sourceName != null ? 1 : 0) != 0);
            Preconditions.checkState((node.getType() == n ? 1 : 0) != 0);
        }

        void defineCatch(Node node, Node node2) {
            this.assertDefinitionNode(node, 120);
            Node node3 = node.getFirstChild();
            this.defineSlot(node3, node, null);
        }

        void defineVar(Node node, Node node2) {
            this.assertDefinitionNode(node, 118);
            JSDocInfo jSDocInfo = node.getJSDocInfo();
            if (node.hasMoreThanOneChild()) {
                if (jSDocInfo != null) {
                    TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
                }
                for (Node node3 : node.children()) {
                    this.defineName(node3, node, node2, node3.getJSDocInfo());
                }
            } else {
                Node node4 = node.getFirstChild();
                this.defineName(node4, node, node2, jSDocInfo != null ? jSDocInfo : node4.getJSDocInfo());
            }
        }

        void defineDeclaredFunction(Node node, Node node2) {
            this.assertDefinitionNode(node, 105);
            JSDocInfo jSDocInfo = node.getJSDocInfo();
            int n = node2.getType();
            Preconditions.checkState(((this.scope.isLocal() || n != 86) && n != 38 ? 1 : 0) != 0, (Object)"function defined as standalone function when it is being assigned");
            String string = node.getFirstChild().getString();
            FunctionType functionType = this.getFunctionType(string, node, jSDocInfo, null);
            if (NodeUtil.isFunctionDeclaration(node)) {
                this.defineSlot(node.getFirstChild(), node, functionType);
            }
        }

        void defineNamedTypeAssign(Node node, Node node2) {
            EnumType enumType;
            this.assertDefinitionNode(node, 86);
            JSDocInfo jSDocInfo = node.getJSDocInfo();
            Node node3 = node.getLastChild();
            Node node4 = node.getFirstChild();
            JSDocInfo jSDocInfo2 = jSDocInfo = jSDocInfo != null ? jSDocInfo : node3.getJSDocInfo();
            if (node3.getType() == 105 || jSDocInfo != null && jSDocInfo.isConstructor()) {
                this.getFunctionType(node4.getQualifiedName(), node3, jSDocInfo, node4);
            } else if (jSDocInfo != null && jSDocInfo.hasEnumParameterType() && (enumType = this.getEnumType(node4.getQualifiedName(), node, node3, jSDocInfo.getEnumParameterType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry))) != null) {
                this.setDeferredType(node4, enumType);
            }
        }

        private void defineName(Node node, Node node2, Node node3, JSDocInfo jSDocInfo) {
            Node node4 = node.getFirstChild();
            if (node4 != null && node4.getType() == 105) {
                String string = node.getString();
                FunctionType functionType = this.getFunctionType(string, node4, jSDocInfo, null);
                if (functionType.isReturnTypeInferred() && this.scope.isLocal()) {
                    this.defineSlot(node, node2, null);
                } else {
                    this.defineSlot(node, node2, functionType);
                }
            } else {
                JSType jSType = null;
                if (jSDocInfo == null) {
                    CompilerInput compilerInput = TypedScopeCreator.this.compiler.getInput(this.sourceName);
                    Preconditions.checkNotNull((Object)compilerInput, (Object)this.sourceName);
                    jSType = compilerInput.isExtern() ? TypedScopeCreator.this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : null;
                } else {
                    jSType = jSDocInfo.hasEnumParameterType() ? this.getEnumType(node.getString(), node2, node4, jSDocInfo.getEnumParameterType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry)) : (jSDocInfo.isConstructor() ? this.getFunctionType(node.getString(), node4, jSDocInfo, node) : this.getDeclaredTypeInAnnotation(this.sourceName, node, jSDocInfo));
                }
                this.defineSlot(node, node2, jSType);
            }
        }

        private FunctionType getFunctionType(String string, Node node, JSDocInfo jSDocInfo, @Nullable Node node2) {
            JSType jSType;
            Node node3;
            FunctionType functionType = null;
            if (node != null && node.isQualifiedName() && this.scope.isGlobal()) {
                Scope.Var var = this.scope.getVar(node.getQualifiedName());
                if (var != null && var.getType() instanceof FunctionType && (functionType = (FunctionType)var.getType()) != null && (functionType.isConstructor() || functionType.isInterface())) {
                    TypedScopeCreator.this.typeRegistry.declareType(string, functionType.getInstanceType());
                }
                return functionType;
            }
            Node node4 = null;
            if (node2 != null) {
                node4 = TypedScopeCreator.getPrototypePropertyOwner(node2);
            }
            Node node5 = node == null ? node2 : node;
            boolean bl = node != null && node.getType() == 105;
            Node node6 = bl ? node : null;
            Node node7 = bl ? node.getFirstChild().getNext() : null;
            Node node8 = node3 = bl ? node7.getNext() : null;
            if (functionType == null && jSDocInfo != null && jSDocInfo.hasType()) {
                jSType = jSDocInfo.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                if ((jSType = jSType.restrictByNotNullOrUndefined()).isFunctionType()) {
                    functionType = (FunctionType)jSType;
                    functionType.setJSDocInfo(jSDocInfo);
                }
            }
            if (functionType == null) {
                ObjectType objectType;
                Scope.Var var;
                jSType = null;
                if (node2 != null && node2.getType() == 33 && node2.isQualifiedName() && (var = this.scope.getVar(node2.getFirstChild().getQualifiedName())) != null && (objectType = ObjectType.cast(var.getType())) != null) {
                    String string2 = node2.getLastChild().getString();
                    jSType = this.findOverriddenFunction(objectType, string2);
                }
                functionType = new FunctionTypeBuilder(string, TypedScopeCreator.this.compiler, node5, this.sourceName, this.scope).setSourceNode(node6).inferFromOverriddenFunction((FunctionType)jSType, node7).inferTemplateTypeName(jSDocInfo).inferReturnType(jSDocInfo).inferInheritance(jSDocInfo).inferThisType(jSDocInfo, node4).inferParameterTypes(node7, jSDocInfo).inferReturnStatementsAsLastResort(node3).buildAndRegister();
            }
            if (node != null) {
                this.setDeferredType(node, functionType);
            }
            return functionType;
        }

        private FunctionType findOverriddenFunction(ObjectType objectType, String string) {
            JSType jSType = objectType.getPropertyType(string);
            if (jSType instanceof FunctionType) {
                return (FunctionType)jSType;
            }
            for (ObjectType objectType2 : objectType.getCtorImplementedInterfaces()) {
                jSType = objectType2.getPropertyType(string);
                if (!(jSType instanceof FunctionType)) continue;
                return (FunctionType)jSType;
            }
            return null;
        }

        private EnumType getEnumType(String string, Node node, Node node2, JSType jSType) {
            EnumType enumType = null;
            if (node2 != null) {
                Scope.Var var;
                if (node2.getType() == 64) {
                    enumType = TypedScopeCreator.this.typeRegistry.createEnumType(string, jSType);
                    for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                        String string2 = NodeUtil.getStringValue(node3);
                        if (enumType.hasOwnProperty(string2)) {
                            TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node3, TypeCheck.ENUM_DUP, string2));
                            continue;
                        }
                        if (!TypedScopeCreator.this.codingConvention.isValidEnumKey(string2)) {
                            TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node3, TypeCheck.ENUM_NOT_CONSTANT, string2));
                            continue;
                        }
                        enumType.defineElement(string2);
                    }
                } else if (node2.isQualifiedName() && (var = this.scope.getVar(node2.getQualifiedName())) != null && var.getType() instanceof EnumType) {
                    enumType = (EnumType)var.getType();
                }
            }
            if (enumType == null) {
                TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, ENUM_INITIALIZER, new String[0]));
            } else if (this.scope.isGlobal() && string != null && !string.isEmpty()) {
                TypedScopeCreator.this.typeRegistry.declareType(string, enumType.getElementsType());
            }
            return enumType;
        }

        private void defineSlot(Node node, Node node2, JSType jSType) {
            this.defineSlot(node, node2, jSType, jSType == null);
        }

        void defineSlot(Node node, Node node2, JSType jSType, boolean bl) {
            Object object;
            Preconditions.checkArgument((bl || jSType != null ? 1 : 0) != 0);
            boolean bl2 = false;
            if (node.getType() == 38) {
                Preconditions.checkArgument((node2.getType() == 105 || node2.getType() == 118 || node2.getType() == 83 || node2.getType() == 120 ? 1 : 0) != 0);
                bl2 = this.scope.isGlobal() && (node2.getType() == 118 || node2.getType() == 105);
            } else {
                Preconditions.checkArgument((node.getType() == 33 && (node2.getType() == 86 || node2.getType() == 130) ? 1 : 0) != 0);
            }
            String string = node.getQualifiedName();
            Preconditions.checkArgument((!string.isEmpty() ? 1 : 0) != 0);
            Scope scope = this.scope;
            if (node.getType() == 33 && !this.scope.isGlobal() && this.isQnameRootedInGlobalScope(node) && !((Scope)(object = this.scope.getGlobalScope())).isDeclared(string, false)) {
                scope = this.scope.getGlobalScope();
            }
            if (scope.isDeclared(string, false)) {
                object = scope.getVar(string);
                TypedScopeCreator.this.validator.expectUndeclaredVariable(this.sourceName, node, node2, (Scope.Var)object, string, jSType);
            } else {
                ObjectType objectType;
                if (!bl) {
                    this.setDeferredType(node, jSType);
                }
                object = TypedScopeCreator.this.compiler.getInput(this.sourceName);
                boolean bl3 = ((CompilerInput)object).isExtern();
                Scope.Var var = scope.declare(string, node, jSType, (CompilerInput)object, bl);
                if (bl2) {
                    objectType = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
                    if (bl) {
                        objectType.defineInferredProperty(string, jSType == null ? TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE) : jSType, bl3);
                    } else {
                        objectType.defineDeclaredProperty(string, jSType, bl3);
                    }
                }
                if (jSType instanceof FunctionType && !jSType.isEmptyType() && (((FunctionType)(objectType = (FunctionType)jSType)).isConstructor() || ((FunctionType)objectType).isInterface()) && !objectType.equals(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE))) {
                    FunctionType functionType = ((FunctionType)objectType).getSuperClassConstructor();
                    scope.declare(string + ".prototype", node, ((FunctionType)objectType).getPrototype(), (CompilerInput)object, functionType == null || functionType.getInstanceType().equals(TypedScopeCreator.this.getNativeType(JSTypeNative.OBJECT_TYPE)));
                    if (var.getInitialValue() == null && !bl3) {
                        TypedScopeCreator.this.compiler.report(JSError.make(this.sourceName, node, ((FunctionType)objectType).isConstructor() ? CTOR_INITIALIZER : IFACE_INITIALIZER, string));
                    }
                }
            }
        }

        private boolean isQnameRootedInGlobalScope(Node node) {
            Scope.Var var;
            Node node2 = NodeUtil.getRootOfQualifiedName(node);
            if (node2.getType() == 38 && (var = this.scope.getVar(node2.getString())) != null) {
                return var.isGlobal();
            }
            return false;
        }

        private JSType getDeclaredGetPropType(NodeTraversal nodeTraversal, JSDocInfo jSDocInfo, Node node, @Nullable Node node2) {
            if (jSDocInfo != null && jSDocInfo.hasType()) {
                return this.getDeclaredTypeInAnnotation(nodeTraversal, node, jSDocInfo);
            }
            if (jSDocInfo != null && jSDocInfo.hasEnumParameterType()) {
                return node.getJSType();
            }
            if (node2 != null && node2.getType() == 105) {
                return node2.getJSType();
            }
            return this.getDeclaredTypeInAnnotation(nodeTraversal, node, jSDocInfo);
        }

        private void checkForClassDefiningCalls(NodeTraversal nodeTraversal, Node node, Node node2) {
            ObjectType objectType;
            Object object;
            Object object2;
            Object object3;
            CodingConvention.SubclassRelationship subclassRelationship = TypedScopeCreator.this.codingConvention.getClassesDefinedByCall(node);
            if (subclassRelationship != null) {
                object3 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(subclassRelationship.superclassName));
                object2 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(subclassRelationship.subclassName));
                if (object3 != null && object2 != null) {
                    object = ((ObjectType)object3).getConstructor();
                    objectType = ((ObjectType)object2).getConstructor();
                    if (subclassRelationship.type == CodingConvention.SubclassType.INHERITS) {
                        TypedScopeCreator.this.validator.expectSuperType(nodeTraversal, node, (ObjectType)object3, (ObjectType)object2);
                    }
                    if (object != null && objectType != null) {
                        TypedScopeCreator.this.codingConvention.applySubclassRelationship((FunctionType)object, (FunctionType)objectType, subclassRelationship.type);
                    }
                }
            }
            if ((object3 = TypedScopeCreator.this.codingConvention.getSingletonGetterClassName(node)) != null && (object2 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType((String)object3))) != null && (object = ((ObjectType)object2).getConstructor()) != null) {
                objectType = TypedScopeCreator.this.typeRegistry.createFunctionType((JSType)object2, new JSType[0]);
                TypedScopeCreator.this.codingConvention.applySingletonGetter((FunctionType)object, (FunctionType)objectType, (ObjectType)object2);
            }
            if ((object2 = TypedScopeCreator.this.codingConvention.getDelegateRelationship(node)) != null) {
                this.applyDelegateRelationship((CodingConvention.DelegateRelationship)object2);
            }
            if ((object = TypedScopeCreator.this.codingConvention.getObjectLiteralCast(nodeTraversal, node)) != null) {
                objectType = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(((CodingConvention.ObjectLiteralCast)object).typeName));
                if (objectType != null && objectType.getConstructor() != null) {
                    this.setDeferredType(((CodingConvention.ObjectLiteralCast)object).objectNode, objectType);
                } else {
                    TypedScopeCreator.this.compiler.report(JSError.make(nodeTraversal.getSourceName(), node, CONSTRUCTOR_EXPECTED, new String[0]));
                }
            }
        }

        private void applyDelegateRelationship(CodingConvention.DelegateRelationship delegateRelationship) {
            ObjectType objectType = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegator));
            ObjectType objectType2 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegateBase));
            ObjectType objectType3 = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(TypedScopeCreator.this.codingConvention.getDelegateSuperclassName()));
            if (objectType != null && objectType2 != null && objectType3 != null) {
                FunctionType functionType = objectType.getConstructor();
                FunctionType functionType2 = objectType2.getConstructor();
                FunctionType functionType3 = objectType3.getConstructor();
                if (functionType != null && functionType2 != null && functionType3 != null) {
                    FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(TypedScopeCreator.this.typeRegistry);
                    functionParamBuilder.addRequiredParams(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
                    FunctionType functionType4 = TypedScopeCreator.this.typeRegistry.createFunctionType(TypedScopeCreator.this.typeRegistry.createDefaultObjectUnion(objectType2), functionParamBuilder.build());
                    FunctionType functionType5 = TypedScopeCreator.this.typeRegistry.createConstructorType(objectType2.getReferenceName() + DELEGATE_PROXY_SUFFIX, null, null, null);
                    functionType5.setPrototypeBasedOn(objectType2);
                    TypedScopeCreator.this.codingConvention.applyDelegateRelationship(objectType3, objectType2, objectType, functionType5, functionType4);
                    TypedScopeCreator.this.delegateProxyPrototypes.add(functionType5.getPrototype());
                }
            }
        }

        void maybeDeclareQualifiedName(NodeTraversal nodeTraversal, JSDocInfo jSDocInfo, Node node, Node node2, Node node3) {
            ObjectType objectType;
            Object object;
            Node node4 = node.getFirstChild();
            String string = node4.getQualifiedName();
            String string2 = node.getQualifiedName();
            String string3 = node.getLastChild().getString();
            Preconditions.checkArgument((string2 != null && string != null ? 1 : 0) != 0);
            if ("prototype".equals(string3) && (object = this.scope.getVar(string2)) != null) {
                if (!((Scope.Var)object).isTypeInferred()) {
                    return;
                }
                if (((Scope.Var)object).getScope() == this.scope) {
                    this.scope.undeclare((Scope.Var)object);
                }
            }
            if ((object = this.getDeclaredGetPropType(nodeTraversal, jSDocInfo, node, node3)) == null && node3 != null) {
                object = node3.getJSType();
            }
            if (object == null) {
                if (node2.getType() == 130) {
                    this.stubDeclarations.add(new StubDeclaration(node, nodeTraversal.getInput() != null && nodeTraversal.getInput().isExtern(), string));
                }
                return;
            }
            boolean bl = true;
            if (jSDocInfo != null) {
                boolean bl2 = bl = !jSDocInfo.hasType() && !jSDocInfo.hasEnumParameterType() && !FunctionTypeBuilder.isFunctionTypeDeclaration(jSDocInfo);
            }
            if (bl) {
                boolean bl3 = bl = node3 == null || node3.getType() != 105 || this.scope.isDeclared(string2, false);
            }
            if (!bl) {
                ObjectType objectType2 = this.getObjectSlot(string);
                if (objectType2 != null) {
                    boolean bl4;
                    boolean bl5 = bl4 = nodeTraversal.getInput() != null && nodeTraversal.getInput().isExtern();
                    if (!(objectType2.hasOwnProperty(string3) && !objectType2.isPropertyTypeInferred(string3) || (!bl4 || objectType2.isNativeObjectType()) && objectType2.isInstanceType())) {
                        objectType2.defineDeclaredProperty(string3, (JSType)object, bl4);
                    }
                }
                this.defineSlot(node, node2, (JSType)object, bl);
            } else if (node3 != null && node3.getType() == 44 && (objectType = this.getObjectSlot(string)) instanceof FunctionType) {
                JSType jSType;
                ObjectType objectType3 = ((FunctionType)objectType).getTypeOfThis();
                String string4 = TypedScopeCreator.this.codingConvention.getDelegateSuperclassName();
                JSType jSType2 = jSType = string4 == null ? null : TypedScopeCreator.this.typeRegistry.getType(string4);
                if (jSType != null && objectType3.isSubtype(jSType)) {
                    this.defineSlot(node, node2, TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE), true);
                }
            }
        }

        private ObjectType getObjectSlot(String string) {
            Scope.Var var = this.scope.getVar(string);
            if (var != null) {
                JSType jSType = var.getType();
                return ObjectType.cast(jSType == null ? null : jSType.restrictByNotNullOrUndefined());
            }
            return null;
        }

        void resolveStubDeclarations() {
            for (StubDeclaration stubDeclaration : this.stubDeclarations) {
                Node node = stubDeclaration.node;
                Node node2 = node.getParent();
                String string = node.getQualifiedName();
                String string2 = node.getLastChild().getString();
                String string3 = stubDeclaration.ownerName;
                boolean bl = stubDeclaration.isExtern;
                if (this.scope.isDeclared(string, false)) continue;
                ObjectType objectType = this.getObjectSlot(string3);
                ObjectType objectType2 = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
                this.defineSlot(node, node2, objectType2, true);
                if (objectType != null && (bl || objectType.isFunctionPrototypeType())) {
                    objectType.defineInferredProperty(string2, objectType2, bl);
                    continue;
                }
                TypedScopeCreator.this.typeRegistry.registerPropertyOnType(string2, objectType == null ? objectType2 : objectType);
            }
        }

        private final class CollectProperties
        extends NodeTraversal.AbstractShallowStatementCallback {
            private final ObjectType thisType;

            CollectProperties(ObjectType objectType) {
                this.thisType = objectType;
            }

            @Override
            public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                if (node.getType() == 130) {
                    Node node3 = node.getFirstChild();
                    switch (node3.getType()) {
                        case 86: {
                            this.maybeCollectMember(nodeTraversal, node3.getFirstChild(), node3, node3.getLastChild());
                            break;
                        }
                        case 33: {
                            this.maybeCollectMember(nodeTraversal, node3, node3, null);
                        }
                    }
                }
            }

            private void maybeCollectMember(NodeTraversal nodeTraversal, Node node, Node node2, @Nullable Node node3) {
                JSDocInfo jSDocInfo = node2.getJSDocInfo();
                if (jSDocInfo == null || node.getType() != 33 || node.getFirstChild().getType() != 42) {
                    return;
                }
                node.getFirstChild().setJSType(this.thisType);
                JSType jSType = AbstractScopeBuilder.this.getDeclaredGetPropType(nodeTraversal, jSDocInfo, node, node3);
                Node node4 = node.getLastChild();
                if (jSType != null && (node4.getType() == 38 || node4.getType() == 40)) {
                    this.thisType.defineDeclaredProperty(node4.getString(), jSType, false);
                }
            }
        }
    }

    private static class DiscoverEnumsAndTypedefs
    extends NodeTraversal.AbstractShallowStatementCallback {
        private final JSTypeRegistry registry;

        DiscoverEnumsAndTypedefs(JSTypeRegistry jSTypeRegistry) {
            this.registry = jSTypeRegistry;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Object var4_4 = null;
            switch (node.getType()) {
                case 118: {
                    for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                        this.identifyNameNode(node3, node3.getFirstChild(), NodeUtil.getInfoForNameNode(node3));
                    }
                    break;
                }
                case 130: {
                    Node node4 = node.getFirstChild();
                    if (node4.getType() == 86) {
                        this.identifyNameNode(node4.getFirstChild(), node4.getLastChild(), node4.getJSDocInfo());
                        break;
                    }
                    this.identifyNameNode(node4, null, node4.getJSDocInfo());
                }
            }
        }

        private void identifyNameNode(Node node, Node node2, JSDocInfo jSDocInfo) {
            if (node.isQualifiedName()) {
                if (jSDocInfo != null) {
                    if (jSDocInfo.hasEnumParameterType()) {
                        this.registry.identifyNonNullableName(node.getQualifiedName());
                    } else if (jSDocInfo.hasTypedefType()) {
                        this.registry.identifyNonNullableName(node.getQualifiedName());
                    }
                }
                if (node2 != null && TypedScopeCreator.LEGACY_TYPEDEF.equals(node2.getQualifiedName())) {
                    this.registry.identifyNonNullableName(node.getQualifiedName());
                }
            }
        }
    }

    private class DeferredSetType {
        final Node node;
        final JSType type;

        DeferredSetType(Node node, JSType jSType) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkNotNull((Object)jSType);
            this.node = node;
            this.type = jSType;
            node.setJSType(jSType);
        }

        void resolve(Scope scope) {
            this.node.setJSType(this.type.resolve(TypedScopeCreator.this.typeParsingErrorReporter, scope));
        }
    }
}

