/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.rhino.Node;
import javax.annotation.Nullable;

public class JSError {
    private final DiagnosticType type;
    public final String description;
    public final String sourceName;
    final Node node;
    public final int lineNumber;
    public final CheckLevel level;
    private final int charno;

    public static JSError make(DiagnosticType diagnosticType, String ... stringArray) {
        return new JSError(null, null, -1, -1, diagnosticType, null, stringArray);
    }

    public static JSError make(String string, int n, int n2, DiagnosticType diagnosticType, String ... stringArray) {
        return new JSError(string, null, n, n2, diagnosticType, null, stringArray);
    }

    public static JSError make(String string, int n, int n2, CheckLevel checkLevel, DiagnosticType diagnosticType, String ... stringArray) {
        return new JSError(string, null, n, n2, diagnosticType, checkLevel, stringArray);
    }

    public static JSError make(String string, Node node, DiagnosticType diagnosticType, String ... stringArray) {
        return new JSError(string, node, diagnosticType, stringArray);
    }

    public static JSError make(String string, Node node, CheckLevel checkLevel, DiagnosticType diagnosticType, String ... stringArray) {
        return new JSError(string, node, node.getLineno(), node.getCharno(), diagnosticType, checkLevel, stringArray);
    }

    private JSError(String string, @Nullable Node node, int n, int n2, DiagnosticType diagnosticType, CheckLevel checkLevel, String ... stringArray) {
        this.type = diagnosticType;
        this.node = node;
        this.description = diagnosticType.format.format(stringArray);
        this.lineNumber = n;
        this.charno = n2;
        this.sourceName = string;
        this.level = checkLevel == null ? diagnosticType.level : checkLevel;
    }

    private JSError(String string, @Nullable Node node, DiagnosticType diagnosticType, String ... stringArray) {
        this(string, node, node != null ? node.getLineno() : -1, node != null ? node.getCharno() : -1, diagnosticType, null, stringArray);
    }

    public DiagnosticType getType() {
        return this.type;
    }

    public String format(CheckLevel checkLevel, MessageFormatter messageFormatter) {
        switch (checkLevel) {
            case ERROR: {
                return messageFormatter.formatError(this);
            }
            case WARNING: {
                return messageFormatter.formatWarning(this);
            }
        }
        return null;
    }

    public String toString() {
        return this.type.key + ". " + this.description + " at " + (this.sourceName != null && this.sourceName.length() > 0 ? this.sourceName : "(unknown source)") + " line " + (this.lineNumber != -1 ? String.valueOf(this.lineNumber) : "(unknown line)") + " : " + (this.charno != -1 ? String.valueOf(this.charno) : "(unknown column)");
    }

    public int getCharno() {
        return this.charno;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JSError jSError = (JSError)object;
        if (this.charno != jSError.charno) {
            return false;
        }
        if (this.lineNumber != jSError.lineNumber) {
            return false;
        }
        if (!this.description.equals(jSError.description)) {
            return false;
        }
        if (this.level != jSError.level) {
            return false;
        }
        if (this.sourceName != null ? !this.sourceName.equals(jSError.sourceName) : jSError.sourceName != null) {
            return false;
        }
        return this.type.equals(jSError.type);
    }

    public int hashCode() {
        int n = this.type.hashCode();
        n = 31 * n + this.description.hashCode();
        n = 31 * n + (this.sourceName != null ? this.sourceName.hashCode() : 0);
        n = 31 * n + this.lineNumber;
        n = 31 * n + this.level.hashCode();
        n = 31 * n + this.charno;
        return n;
    }
}

