/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.Set;

class GatherRawExports
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final String GLOBAL_THIS_NAME = "window";
    private final Set<String> exportedVariables = Sets.newHashSet();

    GatherRawExports(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        Preconditions.checkState((boolean)this.compiler.isNormalized());
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3 = node.getNext();
        if (node3 != null && node3.getType() == 40 && NodeUtil.isGet(node2) && this.isGlobalThisObject(nodeTraversal, node)) {
            this.exportedVariables.add(node3.getString());
        }
    }

    private boolean isGlobalThisObject(NodeTraversal nodeTraversal, Node node) {
        String string;
        if (node.getType() == 42) {
            return nodeTraversal.inGlobalScope();
        }
        return node.getType() == 38 && (string = node.getString()).equals(GLOBAL_THIS_NAME);
    }

    public Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }
}

