/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class CheckRegExp
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType REGEXP_REFERENCE = DiagnosticType.warning("JSC_REGEXP_REFERENCE", "References to the global RegExp object prevents optimization of regular expressions.");
    private final AbstractCompiler compiler;
    private boolean globalRegExpPropertiesUsed = false;

    public boolean isGlobalRegExpPropertiesUsed() {
        return this.globalRegExpPropertiesUsed;
    }

    public CheckRegExp(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        String string;
        if (NodeUtil.isReferenceName(node) && (string = node.getString()).equals("RegExp") && nodeTraversal.getScope().getVar(string) == null) {
            boolean bl;
            int n = node2.getType();
            boolean bl2 = bl = node == node2.getFirstChild();
            if (!(n == 30 && bl || n == 37 && bl || n == 52 && !bl)) {
                nodeTraversal.report(node, REGEXP_REFERENCE, new String[0]);
                this.globalRegExpPropertiesUsed = true;
            }
        }
    }
}

