/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Map;

class CheckProvides
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CheckLevel checkLevel;
    private final CodingConvention codingConvention;
    static final DiagnosticType MISSING_PROVIDE_WARNING = DiagnosticType.disabled("JSC_MISSING_PROVIDE", "missing goog.provide(''{0}'')");

    CheckProvides(AbstractCompiler abstractCompiler, CheckLevel checkLevel) {
        this.compiler = abstractCompiler;
        this.checkLevel = checkLevel;
        this.codingConvention = abstractCompiler.getCodingConvention();
    }

    @Override
    public void process(Node node, Node node2) {
        CheckProvidesCallback checkProvidesCallback = new CheckProvidesCallback(this.codingConvention);
        new NodeTraversal(this.compiler, checkProvidesCallback).traverse(node2);
    }

    private class CheckProvidesCallback
    extends NodeTraversal.AbstractShallowCallback {
        private final Map<String, Node> provides = Maps.newHashMap();
        private final Map<String, Node> ctors = Maps.newHashMap();
        private final CodingConvention convention;

        CheckProvidesCallback(CodingConvention codingConvention) {
            this.convention = codingConvention;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 37: {
                    String string = CheckProvides.this.codingConvention.extractClassNameIfProvide(node, node2);
                    if (string == null) break;
                    this.provides.put(string, node);
                    break;
                }
                case 105: {
                    this.visitFunctionNode(node, node2);
                    break;
                }
                case 132: {
                    this.visitScriptNode(nodeTraversal, node);
                }
            }
        }

        private void visitFunctionNode(Node node, Node node2) {
            JSDocInfo.Visibility visibility;
            String string;
            Node node3 = null;
            JSDocInfo jSDocInfo = node2.getJSDocInfo();
            if (jSDocInfo != null && jSDocInfo.isConstructor()) {
                node3 = node2.getFirstChild();
            } else {
                jSDocInfo = node.getJSDocInfo();
                if (jSDocInfo != null && jSDocInfo.isConstructor()) {
                    node3 = node.getFirstChild();
                }
            }
            if (node3 != null && node3.isQualifiedName() && !this.convention.isPrivate(string = node3.getQualifiedName()) && !(visibility = jSDocInfo.getVisibility()).equals((Object)JSDocInfo.Visibility.PRIVATE)) {
                this.ctors.put(string, node3);
            }
        }

        private void visitScriptNode(NodeTraversal nodeTraversal, Node node) {
            for (String string : this.ctors.keySet()) {
                if (this.provides.containsKey(string)) continue;
                CheckProvides.this.compiler.report(nodeTraversal.makeError(this.ctors.get(string), CheckProvides.this.checkLevel, MISSING_PROVIDE_WARNING, string));
            }
            this.provides.clear();
            this.ctors.clear();
        }
    }
}

