/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.StaticReference;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import com.google.javascript.rhino.jstype.StaticSymbolTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalNamespace
implements StaticScope<JSType>,
StaticSymbolTable<Name, Ref> {
    private AbstractCompiler compiler;
    private final Node root;
    private final Node externsRoot;
    private boolean inExterns;
    private Scope externsScope;
    private boolean generated = false;
    private int currentPreOrderIndex = 0;
    private List<Name> globalNames = new ArrayList<Name>();
    private Map<String, Name> nameMap = new HashMap<String, Name>();

    GlobalNamespace(AbstractCompiler compiler, Node root) {
        this(compiler, null, root);
    }

    GlobalNamespace(AbstractCompiler compiler, Node externsRoot, Node root) {
        this.compiler = compiler;
        this.externsRoot = externsRoot;
        this.root = root;
    }

    @Override
    public Node getRootNode() {
        return this.root.getParent();
    }

    @Override
    public StaticScope<JSType> getParentScope() {
        return null;
    }

    @Override
    public StaticSlot<JSType> getSlot(String name) {
        return this.getOwnSlot(name);
    }

    @Override
    public StaticSlot<JSType> getOwnSlot(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public JSType getTypeOfThis() {
        return this.compiler.getTypeRegistry().getNativeObjectType(JSTypeNative.GLOBAL_THIS);
    }

    @Override
    public Iterable<Ref> getReferences(Name slot) {
        this.ensureGenerated();
        return Collections.unmodifiableList(slot.getRefs());
    }

    @Override
    public StaticScope<JSType> getScope(Name slot) {
        return this;
    }

    @Override
    public Iterable<Name> getAllSymbols() {
        this.ensureGenerated();
        return Collections.unmodifiableCollection(this.getNameIndex().values());
    }

    private void ensureGenerated() {
        if (!this.generated) {
            this.process();
        }
    }

    List<Name> getNameForest() {
        this.ensureGenerated();
        return this.globalNames;
    }

    Map<String, Name> getNameIndex() {
        this.ensureGenerated();
        return this.nameMap;
    }

    void scanNewNodes(Scope scope, Set<Node> newNodes) {
        NodeTraversal t = new NodeTraversal(this.compiler, new BuildGlobalNamespace(new NodeFilter(newNodes)));
        t.traverseAtScope(scope);
    }

    private void process() {
        if (this.externsRoot != null) {
            this.inExterns = true;
            NodeTraversal.traverse(this.compiler, this.externsRoot, new BuildGlobalNamespace());
        }
        this.inExterns = false;
        NodeTraversal.traverse(this.compiler, this.root, new BuildGlobalNamespace());
        this.generated = true;
    }

    private boolean isGlobalNameReference(String name, Scope s) {
        String topVarName = this.getTopVarName(name);
        return this.isGlobalVarReference(topVarName, s);
    }

    private String getTopVarName(String name) {
        int firstDotIndex = name.indexOf(46);
        return firstDotIndex == -1 ? name : name.substring(0, firstDotIndex);
    }

    private boolean isGlobalVarReference(String name, Scope s) {
        Scope.Var v = s.getVar(name);
        if (v == null && this.externsScope != null) {
            v = this.externsScope.getVar(name);
        }
        return v != null && !v.isLocal();
    }

    private boolean isGlobalScope(Scope s) {
        return s.getParent() == null;
    }

    static class Ref
    implements StaticReference<JSType> {
        Node node;
        final JSModule module;
        final StaticSourceFile source;
        final Name name;
        final Type type;
        final Scope scope;
        final int preOrderIndex;
        private Ref twin = null;

        Ref(NodeTraversal t, Node node, Name name, Type type, int index) {
            this.node = node;
            this.name = name;
            this.module = t.getInput() == null ? null : t.getInput().getModule();
            this.source = node.getStaticSourceFile();
            this.type = type;
            this.scope = t.getScope();
            this.preOrderIndex = index;
        }

        private Ref(Ref original, Type type, int index) {
            this.node = original.node;
            this.name = original.name;
            this.module = original.module;
            this.source = original.source;
            this.type = type;
            this.scope = original.scope;
            this.preOrderIndex = index;
        }

        private Ref(Type type, int index) {
            this.type = type;
            this.module = null;
            this.source = null;
            this.scope = null;
            this.name = null;
            this.preOrderIndex = index;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public StaticSourceFile getSourceFile() {
            return this.source;
        }

        @Override
        public StaticSlot<JSType> getSymbol() {
            return this.name;
        }

        JSModule getModule() {
            return this.module;
        }

        String getSourceName() {
            return this.source == null ? "" : this.source.getName();
        }

        Ref getTwin() {
            return this.twin;
        }

        boolean isSet() {
            return this.type == Type.SET_FROM_GLOBAL || this.type == Type.SET_FROM_LOCAL;
        }

        static void markTwins(Ref a, Ref b) {
            Preconditions.checkArgument((!(a.type != Type.ALIASING_GET && b.type != Type.ALIASING_GET || a.type != Type.SET_FROM_GLOBAL && a.type != Type.SET_FROM_LOCAL && b.type != Type.SET_FROM_GLOBAL && b.type != Type.SET_FROM_LOCAL) ? 1 : 0) != 0);
            a.twin = b;
            b.twin = a;
        }

        Ref cloneAndReclassify(Type type) {
            return new Ref(this, type, this.preOrderIndex);
        }

        static Ref createRefForTesting(Type type) {
            return new Ref(type, -1);
        }

        static enum Type {
            SET_FROM_GLOBAL,
            SET_FROM_LOCAL,
            PROTOTYPE_GET,
            ALIASING_GET,
            DIRECT_GET,
            CALL_GET,
            DELETE_PROP;

        }
    }

    static class Name
    implements StaticSlot<JSType> {
        private final String baseName;
        final Name parent;
        List<Name> props;
        private Ref declaration;
        private List<Ref> refs;
        Type type;
        private boolean isClassOrEnum = false;
        private boolean hasClassOrEnumDescendant = false;
        int globalSets = 0;
        int localSets = 0;
        int aliasingGets = 0;
        int totalGets = 0;
        int callGets = 0;
        int deleteProps = 0;
        boolean inExterns;
        JSDocInfo docInfo = null;

        Name(String name, Name parent, boolean inExterns) {
            this.baseName = name;
            this.parent = parent;
            this.type = Type.OTHER;
            this.inExterns = inExterns;
        }

        Name addProperty(String name, boolean inExterns) {
            if (this.props == null) {
                this.props = new ArrayList<Name>();
            }
            Name node = new Name(name, this, inExterns);
            this.props.add(node);
            return node;
        }

        String getBaseName() {
            return this.baseName;
        }

        @Override
        public String getName() {
            return this.getFullName();
        }

        String getFullName() {
            return this.parent == null ? this.baseName : this.parent.getFullName() + '.' + this.baseName;
        }

        public Ref getDeclaration() {
            return this.declaration;
        }

        @Override
        public boolean isTypeInferred() {
            return false;
        }

        @Override
        public JSType getType() {
            return null;
        }

        void addRef(Ref ref) {
            this.addRefInternal(ref);
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    if (this.declaration == null) {
                        this.declaration = ref;
                        this.docInfo = Name.getDocInfoForDeclaration(ref);
                    }
                    ++this.globalSets;
                    break;
                }
                case SET_FROM_LOCAL: {
                    ++this.localSets;
                    break;
                }
                case PROTOTYPE_GET: 
                case DIRECT_GET: {
                    ++this.totalGets;
                    break;
                }
                case ALIASING_GET: {
                    ++this.aliasingGets;
                    ++this.totalGets;
                    break;
                }
                case CALL_GET: {
                    ++this.callGets;
                    ++this.totalGets;
                    break;
                }
                case DELETE_PROP: {
                    ++this.deleteProps;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        void removeRef(Ref ref) {
            if (this.refs != null && this.refs.remove(ref)) {
                if (ref == this.declaration) {
                    this.declaration = null;
                    if (this.refs != null) {
                        for (Ref maybeNewDecl : this.refs) {
                            if (maybeNewDecl.type != Ref.Type.SET_FROM_GLOBAL) continue;
                            this.declaration = maybeNewDecl;
                            break;
                        }
                    }
                }
                switch (ref.type) {
                    case SET_FROM_GLOBAL: {
                        --this.globalSets;
                        break;
                    }
                    case SET_FROM_LOCAL: {
                        --this.localSets;
                        break;
                    }
                    case PROTOTYPE_GET: 
                    case DIRECT_GET: {
                        --this.totalGets;
                        break;
                    }
                    case ALIASING_GET: {
                        --this.aliasingGets;
                        --this.totalGets;
                        break;
                    }
                    case CALL_GET: {
                        --this.callGets;
                        --this.totalGets;
                        break;
                    }
                    case DELETE_PROP: {
                        --this.deleteProps;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        List<Ref> getRefs() {
            return this.refs == null ? ImmutableList.of() : this.refs;
        }

        void addRefInternal(Ref ref) {
            if (this.refs == null) {
                this.refs = Lists.newArrayList();
            }
            this.refs.add(ref);
        }

        boolean canEliminate() {
            if (!this.canCollapseUnannotatedChildNames() || this.totalGets > 0) {
                return false;
            }
            if (this.props != null) {
                for (Name n : this.props) {
                    if (n.canCollapse()) continue;
                    return false;
                }
            }
            return true;
        }

        boolean isSimpleStubDeclaration() {
            if (this.getRefs().size() == 1) {
                Ref ref = this.refs.get(0);
                JSDocInfo info = ref.node.getJSDocInfo();
                if (ref.node.getParent() != null && ref.node.getParent().isExprResult()) {
                    return true;
                }
            }
            return false;
        }

        boolean canCollapse() {
            return !(this.inExterns || this.isGetOrSetDefinition() || !this.isClassOrEnum && (this.parent != null && !this.parent.canCollapseUnannotatedChildNames() || this.globalSets <= 0 && this.localSets <= 0 || this.deleteProps != 0));
        }

        boolean isGetOrSetDefinition() {
            return this.type == Type.GET || this.type == Type.SET;
        }

        boolean canCollapseUnannotatedChildNames() {
            if (this.type == Type.OTHER || this.isGetOrSetDefinition() || this.globalSets != 1 || this.localSets != 0 || this.deleteProps != 0) {
                return false;
            }
            Preconditions.checkNotNull((Object)this.declaration);
            if (this.declaration.getTwin() != null) {
                return false;
            }
            if (this.isClassOrEnum) {
                return true;
            }
            if (this.parent != null && this.parent.shouldKeepKeys()) {
                return false;
            }
            if (this.aliasingGets > 0) {
                return false;
            }
            return this.parent == null || this.parent.canCollapseUnannotatedChildNames();
        }

        boolean shouldKeepKeys() {
            return this.type == Type.OBJECTLIT && this.aliasingGets > 0;
        }

        boolean needsToBeStubbed() {
            return this.globalSets == 0 && this.localSets > 0;
        }

        void setIsClassOrEnum() {
            this.isClassOrEnum = true;
            Name ancestor = this.parent;
            while (ancestor != null) {
                ancestor.hasClassOrEnumDescendant = true;
                ancestor = ancestor.parent;
            }
        }

        boolean isNamespace() {
            return this.hasClassOrEnumDescendant && this.type == Type.OBJECTLIT;
        }

        boolean isSimpleName() {
            return this.parent == null;
        }

        public String toString() {
            return this.getFullName() + " (" + (Object)((Object)this.type) + "): globalSets=" + this.globalSets + ", localSets=" + this.localSets + ", totalGets=" + this.totalGets + ", aliasingGets=" + this.aliasingGets + ", callGets=" + this.callGets;
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return this.docInfo;
        }

        private static JSDocInfo getDocInfoForDeclaration(Ref ref) {
            if (ref.node != null) {
                Node refParent = ref.node.getParent();
                switch (refParent.getType()) {
                    case 86: 
                    case 105: {
                        return refParent.getJSDocInfo();
                    }
                    case 118: {
                        return ref.node == refParent.getFirstChild() ? refParent.getJSDocInfo() : ref.node.getJSDocInfo();
                    }
                }
            }
            return null;
        }

        static enum Type {
            OBJECTLIT,
            FUNCTION,
            GET,
            SET,
            OTHER;

        }
    }

    private class BuildGlobalNamespace
    implements NodeTraversal.Callback {
        private final Predicate<Node> nodeFilter;

        BuildGlobalNamespace() {
            this(null);
        }

        BuildGlobalNamespace(Predicate<Node> nodeFilter) {
            this.nodeFilter = nodeFilter;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            this.collect(t, n, parent);
            return true;
        }

        public void collect(NodeTraversal t, Node n, Node parent) {
            String name;
            if (this.nodeFilter != null && !this.nodeFilter.apply((Object)n)) {
                return;
            }
            if (GlobalNamespace.this.externsRoot != null && n == GlobalNamespace.this.externsRoot) {
                GlobalNamespace.this.externsScope = t.getScope();
            }
            boolean isSet = false;
            Name.Type type = Name.Type.OTHER;
            boolean isPropAssign = false;
            block0 : switch (n.getType()) {
                case 40: 
                case 147: 
                case 148: {
                    name = null;
                    if (parent != null && parent.isObjectLit()) {
                        name = this.getNameForObjLitKey(n);
                    }
                    if (name == null) {
                        return;
                    }
                    isSet = true;
                    switch (n.getType()) {
                        case 40: {
                            type = this.getValueType(n.getFirstChild());
                            break block0;
                        }
                        case 147: {
                            type = Name.Type.GET;
                            break block0;
                        }
                        case 148: {
                            type = Name.Type.SET;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("unexpected:" + n);
                }
                case 38: {
                    if (parent != null) {
                        switch (parent.getType()) {
                            case 118: {
                                isSet = true;
                                Node rvalue = n.getFirstChild();
                                type = rvalue == null ? Name.Type.OTHER : this.getValueType(rvalue);
                                break;
                            }
                            case 86: {
                                if (parent.getFirstChild() != n) break;
                                isSet = true;
                                type = this.getValueType(n.getNext());
                                break;
                            }
                            case 33: {
                                return;
                            }
                            case 105: {
                                Node gramps = parent.getParent();
                                if (gramps == null || NodeUtil.isFunctionExpression(parent)) {
                                    return;
                                }
                                isSet = true;
                                type = Name.Type.FUNCTION;
                                break;
                            }
                            case 102: 
                            case 103: {
                                isSet = true;
                                type = Name.Type.OTHER;
                                break;
                            }
                            default: {
                                if (!NodeUtil.isAssignmentOp(parent) || parent.getFirstChild() != n) break;
                                isSet = true;
                                type = Name.Type.OTHER;
                            }
                        }
                    }
                    name = n.getString();
                    break;
                }
                case 33: {
                    if (parent != null) {
                        switch (parent.getType()) {
                            case 86: {
                                if (parent.getFirstChild() != n) break;
                                isSet = true;
                                type = this.getValueType(n.getNext());
                                isPropAssign = true;
                                break;
                            }
                            case 102: 
                            case 103: {
                                isSet = true;
                                type = Name.Type.OTHER;
                                break;
                            }
                            case 33: {
                                return;
                            }
                            default: {
                                if (!NodeUtil.isAssignmentOp(parent) || parent.getFirstChild() != n) break;
                                isSet = true;
                                type = Name.Type.OTHER;
                            }
                        }
                    }
                    if ((name = n.getQualifiedName()) != null) break;
                    return;
                }
                default: {
                    return;
                }
            }
            Scope scope = t.getScope();
            if (!GlobalNamespace.this.isGlobalNameReference(name, scope)) {
                return;
            }
            if (isSet) {
                if (GlobalNamespace.this.isGlobalScope(scope)) {
                    this.handleSetFromGlobal(t, n, parent, name, isPropAssign, type);
                } else {
                    this.handleSetFromLocal(t, n, parent, name);
                }
            } else {
                this.handleGet(t, n, parent, name);
            }
        }

        String getNameForObjLitKey(Node n) {
            String key;
            String name;
            Node parent = n.getParent();
            Preconditions.checkState((boolean)parent.isObjectLit());
            Node gramps = parent.getParent();
            if (gramps == null) {
                return null;
            }
            Node greatGramps = gramps.getParent();
            switch (gramps.getType()) {
                case 38: {
                    if (greatGramps == null || !greatGramps.isVar()) {
                        return null;
                    }
                    name = gramps.getString();
                    break;
                }
                case 86: {
                    Node lvalue = gramps.getFirstChild();
                    name = lvalue.getQualifiedName();
                    break;
                }
                case 40: {
                    if (greatGramps != null && greatGramps.isObjectLit()) {
                        name = this.getNameForObjLitKey(gramps);
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            if (name != null && TokenStream.isJSIdentifier(key = n.getString())) {
                return name + '.' + key;
            }
            return null;
        }

        Name.Type getValueType(Node n) {
            switch (n.getType()) {
                case 64: {
                    return Name.Type.OBJECTLIT;
                }
                case 105: {
                    return Name.Type.FUNCTION;
                }
                case 100: {
                    return this.getValueType(n.getLastChild());
                }
                case 98: {
                    Node second = n.getFirstChild().getNext();
                    Name.Type t = this.getValueType(second);
                    if (t != Name.Type.OTHER) {
                        return t;
                    }
                    Node third = second.getNext();
                    return this.getValueType(third);
                }
            }
            return Name.Type.OTHER;
        }

        void handleSetFromGlobal(NodeTraversal t, Node n, Node parent, String name, boolean isPropAssign, Name.Type type) {
            if (this.maybeHandlePrototypePrefix(t, n, parent, name)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name);
            nameObj.type = type;
            Ref set = new Ref(t, n, nameObj, Ref.Type.SET_FROM_GLOBAL, GlobalNamespace.this.currentPreOrderIndex++);
            nameObj.addRef(set);
            if (this.isNestedAssign(parent)) {
                Ref get = new Ref(t, n, nameObj, Ref.Type.ALIASING_GET, GlobalNamespace.this.currentPreOrderIndex++);
                nameObj.addRef(get);
                Ref.markTwins(set, get);
            } else if (this.isConstructorOrEnumDeclaration(n, parent)) {
                nameObj.setIsClassOrEnum();
            }
        }

        private boolean isConstructorOrEnumDeclaration(Node n, Node parent) {
            int valueNodeType;
            JSDocInfo info;
            switch (parent.getType()) {
                case 86: {
                    info = parent.getJSDocInfo();
                    valueNodeType = n.getNext().getType();
                    break;
                }
                case 118: {
                    Node valueNode;
                    info = n.getJSDocInfo();
                    if (info == null) {
                        info = parent.getJSDocInfo();
                    }
                    valueNodeType = (valueNode = n.getFirstChild()) != null ? valueNode.getType() : 122;
                    break;
                }
                default: {
                    if (NodeUtil.isFunctionDeclaration(parent)) {
                        info = parent.getJSDocInfo();
                        valueNodeType = 105;
                        break;
                    }
                    return false;
                }
            }
            return info != null && (info.isConstructor() && valueNodeType == 105 || info.hasEnumParameterType() && valueNodeType == 64);
        }

        void handleSetFromLocal(NodeTraversal t, Node n, Node parent, String name) {
            if (this.maybeHandlePrototypePrefix(t, n, parent, name)) {
                return;
            }
            Name nameObj = this.getOrCreateName(name);
            Ref set = new Ref(t, n, nameObj, Ref.Type.SET_FROM_LOCAL, GlobalNamespace.this.currentPreOrderIndex++);
            nameObj.addRef(set);
            if (this.isNestedAssign(parent)) {
                Ref get = new Ref(t, n, nameObj, Ref.Type.ALIASING_GET, GlobalNamespace.this.currentPreOrderIndex++);
                nameObj.addRef(get);
                Ref.markTwins(set, get);
            }
        }

        void handleGet(NodeTraversal t, Node n, Node parent, String name) {
            if (this.maybeHandlePrototypePrefix(t, n, parent, name)) {
                return;
            }
            Ref.Type type = Ref.Type.DIRECT_GET;
            if (parent != null) {
                switch (parent.getType()) {
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 32: 
                    case 108: 
                    case 122: {
                        break;
                    }
                    case 37: {
                        type = n == parent.getFirstChild() ? Ref.Type.CALL_GET : Ref.Type.ALIASING_GET;
                        break;
                    }
                    case 30: {
                        type = n == parent.getFirstChild() ? Ref.Type.DIRECT_GET : Ref.Type.ALIASING_GET;
                        break;
                    }
                    case 100: 
                    case 101: {
                        type = this.determineGetTypeForHookOrBooleanExpr(t, parent, name);
                        break;
                    }
                    case 98: {
                        if (n == parent.getFirstChild()) break;
                        type = this.determineGetTypeForHookOrBooleanExpr(t, parent, name);
                        break;
                    }
                    case 31: {
                        type = Ref.Type.DELETE_PROP;
                        break;
                    }
                    default: {
                        type = Ref.Type.ALIASING_GET;
                    }
                }
            }
            this.handleGet(t, n, parent, name, type);
        }

        Ref.Type determineGetTypeForHookOrBooleanExpr(NodeTraversal t, Node parent, String name) {
            Node prev = parent;
            for (Node anc : parent.getAncestors()) {
                switch (anc.getType()) {
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 32: 
                    case 108: 
                    case 113: 
                    case 115: 
                    case 118: 
                    case 122: 
                    case 130: {
                        return Ref.Type.DIRECT_GET;
                    }
                    case 98: {
                        if (anc.getFirstChild() != prev) break;
                        return Ref.Type.DIRECT_GET;
                    }
                    case 86: {
                        if (name.equals(anc.getFirstChild().getQualifiedName())) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case 38: {
                        if (name.equals(anc.getString())) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case 37: {
                        if (anc.getFirstChild() == prev) break;
                        return Ref.Type.ALIASING_GET;
                    }
                    case 31: {
                        return Ref.Type.DELETE_PROP;
                    }
                }
                prev = anc;
            }
            return Ref.Type.ALIASING_GET;
        }

        void handleGet(NodeTraversal t, Node n, Node parent, String name, Ref.Type type) {
            Name nameObj = this.getOrCreateName(name);
            nameObj.addRef(new Ref(t, n, nameObj, type, GlobalNamespace.this.currentPreOrderIndex++));
        }

        boolean maybeHandlePrototypePrefix(NodeTraversal t, Node n, Node parent, String name) {
            int i;
            String prefix;
            int numLevelsToRemove;
            if (name.endsWith(".prototype")) {
                numLevelsToRemove = 1;
                prefix = name.substring(0, name.length() - 10);
            } else {
                i = name.indexOf(".prototype.");
                if (i == -1) {
                    return false;
                }
                prefix = name.substring(0, i);
                numLevelsToRemove = 2;
                i = name.indexOf(46, i + 11);
                while (i >= 0) {
                    ++numLevelsToRemove;
                    i = name.indexOf(46, i + 1);
                }
            }
            if (parent != null && NodeUtil.isObjectLitKey(n, parent)) {
                return true;
            }
            for (i = 0; i < numLevelsToRemove; ++i) {
                parent = n;
                n = n.getFirstChild();
            }
            this.handleGet(t, n, parent, prefix, Ref.Type.PROTOTYPE_GET);
            return true;
        }

        boolean isNestedAssign(Node parent) {
            return parent.isAssign() && !parent.getParent().isExprResult();
        }

        Name getOrCreateName(String name) {
            Name node = (Name)GlobalNamespace.this.nameMap.get(name);
            if (node == null) {
                int i = name.lastIndexOf(46);
                if (i >= 0) {
                    String parentName = name.substring(0, i);
                    Name parent = this.getOrCreateName(parentName);
                    node = parent.addProperty(name.substring(i + 1), GlobalNamespace.this.inExterns);
                } else {
                    node = new Name(name, null, GlobalNamespace.this.inExterns);
                    GlobalNamespace.this.globalNames.add(node);
                }
                GlobalNamespace.this.nameMap.put(name, node);
            }
            return node;
        }
    }

    private static class NodeFilter
    implements Predicate<Node> {
        private final Set<Node> newNodes;

        NodeFilter(Set<Node> newNodes) {
            this.newNodes = newNodes;
        }

        public boolean apply(Node n) {
            if (!n.isQualifiedName()) {
                return false;
            }
            Node current = n;
            while (current.isGetProp()) {
                if (this.newNodes.contains(current)) {
                    return true;
                }
                current = current.getFirstChild();
            }
            return current.isName() && this.newNodes.contains(current);
        }
    }
}

