/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.tools.JavaFileObject;

public class MemberEnter
extends JCTree.Visitor
implements Symbol.Completer {
    protected static final Context.Key<MemberEnter> memberEnterKey = new Context.Key();
    static final boolean checkClash = true;
    private final Names names;
    private final Enter enter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final TreeMaker make;
    private final Todo todo;
    private final Annotate annotate;
    private final TypeAnnotations typeAnnotations;
    private final Types types;
    private final JCDiagnostic.Factory diags;
    private final Source source;
    private final Target target;
    private final DeferredLintHandler deferredLintHandler;
    private final Lint lint;
    private final TypeEnvs typeEnvs;
    private final Dependencies dependencies;
    boolean allowTypeAnnos;
    ListBuffer<Env<AttrContext>> halfcompleted = new ListBuffer();
    boolean isFirst = true;
    boolean completionEnabled = true;
    Scope.ImportFilter staticImportFilter;
    Scope.ImportFilter typeImportFilter = new Scope.ImportFilter(){

        @Override
        public boolean accepts(Scope origin, Symbol t) {
            return t.kind == 2;
        }
    };
    protected Env<AttrContext> env;

    public static MemberEnter instance(Context context) {
        MemberEnter instance = context.get(memberEnterKey);
        if (instance == null) {
            instance = new MemberEnter(context);
        }
        return instance;
    }

    protected MemberEnter(Context context) {
        context.put(memberEnterKey, this);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.todo = Todo.instance(context);
        this.annotate = Annotate.instance(context);
        this.typeAnnotations = TypeAnnotations.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.source = Source.instance(context);
        this.target = Target.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.lint = Lint.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.dependencies = Dependencies.instance(context);
        this.allowTypeAnnos = this.source.allowTypeAnnotations();
    }

    private void importAll(int pos, Symbol.TypeSymbol tsym, Env<AttrContext> env) {
        if (tsym.kind == 1 && tsym.members().isEmpty() && !tsym.exists()) {
            if (((Symbol.PackageSymbol)tsym).fullname.equals(this.names.java_lang)) {
                JCDiagnostic msg = this.diags.fragment("fatal.err.no.java.lang", new Object[0]);
                throw new FatalError(msg);
            }
            this.log.error(JCDiagnostic.DiagnosticFlag.RESOLVE_ERROR, pos, "doesnt.exist", tsym);
        }
        env.toplevel.starImportScope.importAll(tsym.members(), tsym.members(), this.typeImportFilter, false);
    }

    private void importStaticAll(int pos, Symbol.TypeSymbol tsym, Env<AttrContext> env) {
        final Scope.StarImportScope toScope = env.toplevel.starImportScope;
        Symbol.PackageSymbol packge = env.toplevel.packge;
        final Symbol.TypeSymbol origin = tsym;
        new SymbolImporter(){

            @Override
            void doImport(Symbol.TypeSymbol tsym) {
                toScope.importAll(tsym.members(), origin.members(), MemberEnter.this.staticImportFilter, true);
            }
        }.importFrom(tsym);
    }

    private void importNamedStatic(final JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol tsym, final Name name, final Env<AttrContext> env) {
        if (tsym.kind != 2) {
            this.log.error(JCDiagnostic.DiagnosticFlag.RECOVERABLE, pos, "static.imp.only.classes.and.interfaces", new Object[0]);
            return;
        }
        final Scope.NamedImportScope toScope = env.toplevel.namedImportScope;
        final Scope.WriteableScope originMembers = tsym.members();
        new SymbolImporter(){

            @Override
            void doImport(Symbol.TypeSymbol tsym) {
                Set maskedOut = null;
                for (Symbol sym : tsym.members().getSymbolsByName(name)) {
                    if (sym.kind != 2 || !MemberEnter.this.staticImportFilter.accepts(originMembers, sym) || MemberEnter.this.chk.checkUniqueStaticImport(pos, env.toplevel, sym)) continue;
                    if (maskedOut == null) {
                        maskedOut = Collections.newSetFromMap(new IdentityHashMap());
                    }
                    maskedOut.add(sym);
                }
                Scope.ImportFilter importFilter = maskedOut != null ? new MaskedImportFilter(MemberEnter.this.staticImportFilter, maskedOut) : MemberEnter.this.staticImportFilter;
                toScope.importByName(tsym.members(), originMembers, name, importFilter);
            }
        }.importFrom(tsym);
    }

    private void importNamed(JCDiagnostic.DiagnosticPosition pos, Symbol tsym, Env<AttrContext> env) {
        if (tsym.kind == 2 && this.chk.checkUniqueImport(pos, env.toplevel, tsym)) {
            env.toplevel.namedImportScope.importType(tsym.owner.members(), tsym.owner.members(), tsym);
        }
    }

    Type signature(Symbol.MethodSymbol msym, List<JCTree.JCTypeParameter> typarams, List<JCTree.JCVariableDecl> params, JCTree res, JCTree.JCVariableDecl recvparam, List<JCTree.JCExpression> thrown, Env<AttrContext> env) {
        Type recvtype;
        Type.JCVoidType restype;
        List<Type> tvars = this.enter.classEnter(typarams, env);
        this.attr.attribTypeVariables(typarams, env);
        ListBuffer<Type> argbuf = new ListBuffer<Type>();
        List<JCTree.JCVariableDecl> l = params;
        while (l.nonEmpty()) {
            this.memberEnter((JCTree)l.head, env);
            argbuf.append(((JCTree.JCVariableDecl)l.head).vartype.type);
            l = l.tail;
        }
        Type type = restype = res == null ? this.syms.voidType : this.attr.attribType(res, env);
        if (recvparam != null) {
            this.memberEnter(recvparam, env);
            recvtype = recvparam.vartype.type;
        } else {
            recvtype = null;
        }
        ListBuffer<Type> thrownbuf = new ListBuffer<Type>();
        List<JCTree.JCExpression> l2 = thrown;
        while (l2.nonEmpty()) {
            Type exc = this.attr.attribType((JCTree)l2.head, env);
            if (!exc.hasTag(TypeTag.TYPEVAR)) {
                exc = this.chk.checkClassType(((JCTree.JCExpression)l2.head).pos(), exc);
            } else if (exc.tsym.owner == msym) {
                exc.tsym.flags_field |= 0x800000000000L;
            }
            thrownbuf.append(exc);
            l2 = l2.tail;
        }
        Type.MethodType mtype = new Type.MethodType(argbuf.toList(), restype, thrownbuf.toList(), this.syms.methodClass);
        mtype.recvtype = recvtype;
        return tvars.isEmpty() ? mtype : new Type.ForAll(tvars, mtype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberEnter(JCTree.JCCompilationUnit tree, Env<AttrContext> env) {
        Scope.ImportFilter prevStaticImportFilter = this.staticImportFilter;
        try {
            final Symbol.PackageSymbol packge = env.toplevel.packge;
            this.staticImportFilter = new Scope.ImportFilter(){

                @Override
                public boolean accepts(Scope origin, Symbol sym) {
                    return sym.isStatic() && MemberEnter.this.chk.staticImportAccessible(sym, packge) && sym.isMemberOf((Symbol.TypeSymbol)origin.owner, MemberEnter.this.types);
                }
            };
            this.memberEnter((JCTree)tree, env);
        }
        finally {
            this.staticImportFilter = prevStaticImportFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberEnter(JCTree tree, Env<AttrContext> env) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            tree.accept(this);
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos(), ex);
        }
        finally {
            this.env = prevEnv;
        }
    }

    void memberEnter(List<? extends JCTree> trees, Env<AttrContext> env) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.memberEnter((JCTree)l.head, env);
            l = l.tail;
        }
    }

    void finishClass(JCTree.JCClassDecl tree, Env<AttrContext> env) {
        if ((tree.mods.flags & 0x4000L) != 0L && (this.types.supertype((Type)tree.sym.type).tsym.flags() & 0x4000L) == 0L) {
            this.addEnumMembers(tree, env);
        }
        this.memberEnter(tree.defs, env);
    }

    private void addEnumMembers(JCTree.JCClassDecl tree, Env<AttrContext> env) {
        JCTree.JCExpression valuesType = this.make.Type(new Type.ArrayType(tree.sym.type, this.syms.arrayClass, Type.noAnnotations));
        JCTree.JCMethodDecl values = this.make.MethodDef(this.make.Modifiers(9L), this.names.values, valuesType, List.nil(), List.nil(), List.nil(), null, null);
        this.memberEnter(values, env);
        JCTree.JCMethodDecl valueOf = this.make.MethodDef(this.make.Modifiers(9L), this.names.valueOf, this.make.Type(tree.sym.type), List.nil(), List.of(this.make.VarDef(this.make.Modifiers(0x200008000L), this.names.fromString("name"), this.make.Type(this.syms.stringType), null)), List.nil(), null, null);
        this.memberEnter(valueOf, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        if (!tree.starImportScope.isEmpty()) {
            return;
        }
        JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.immediate();
        Lint prevLint = this.chk.setLint(this.lint);
        try {
            this.importAll(tree.pos, this.syms.enterPackage(this.names.java_lang), this.env);
            this.memberEnter(tree.defs, this.env);
        }
        finally {
            this.chk.setLint(prevLint);
            this.deferredLintHandler.setPos(prevLintPos);
        }
    }

    @Override
    public void visitPackageDef(JCTree.JCPackageDecl tree) {
        if (tree.pid != null) {
            Symbol p = this.env.toplevel.packge;
            while (p.owner != this.syms.rootPackage) {
                p.owner.complete();
                if (this.syms.classes.get(((Symbol)p).getQualifiedName()) != null) {
                    this.log.error(tree.pos, "pkg.clashes.with.class.of.same.name", p);
                }
                p = p.owner;
            }
        }
        this.annotate.annotateLater(tree.annotations, this.env, this.env.toplevel.packge, null);
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        this.dependencies.push(Dependencies.AttributionKind.IMPORT, tree);
        JCTree.JCFieldAccess imp = (JCTree.JCFieldAccess)tree.qualid;
        Name name = TreeInfo.name(imp);
        Env<AttrContext> localEnv = this.env.dup(tree);
        Symbol.TypeSymbol p = this.attr.attribImportQualifier((JCTree.JCImport)tree, localEnv).tsym;
        if (name == this.names.asterisk) {
            this.chk.checkCanonical(imp.selected);
            if (tree.staticImport) {
                this.importStaticAll(tree.pos, p, this.env);
            } else {
                this.importAll(tree.pos, p, this.env);
            }
        } else if (tree.staticImport) {
            this.importNamedStatic(tree.pos(), p, name, localEnv);
            this.chk.checkCanonical(imp.selected);
        } else {
            Symbol.TypeSymbol c = this.attribImportType((JCTree)imp, localEnv).tsym;
            this.chk.checkCanonical(imp);
            this.importNamed(tree.pos(), c, this.env);
        }
        this.dependencies.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        Scope.WriteableScope enclScope = this.enter.enterScope(this.env);
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(0L, tree.name, null, enclScope.owner);
        m.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, m, tree);
        tree.sym = m;
        if ((tree.mods.flags & 0x80000000000L) != 0L) {
            m.enclClass().flags_field |= 0x80000000000L;
        }
        Env<AttrContext> localEnv = this.methodEnv(tree, this.env);
        this.annotate.enterStart();
        try {
            JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(tree.pos());
            try {
                m.type = this.signature(m, tree.typarams, tree.params, tree.restype, tree.recvparam, tree.thrown, localEnv);
            }
            finally {
                this.deferredLintHandler.setPos(prevLintPos);
            }
            if (this.types.isSignaturePolymorphic(m)) {
                m.flags_field |= 0x400000000000L;
            }
            ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
            JCTree.JCVariableDecl lastParam = null;
            List<JCTree.JCVariableDecl> l = tree.params;
            while (l.nonEmpty()) {
                JCTree.JCVariableDecl param = lastParam = (JCTree.JCVariableDecl)l.head;
                params.append(Assert.checkNonNull(param.sym));
                l = l.tail;
            }
            m.params = params.toList();
            if (lastParam != null && (lastParam.mods.flags & 0x400000000L) != 0L) {
                m.flags_field |= 0x400000000L;
            }
            ((AttrContext)localEnv.info).scope.leave();
            if (this.chk.checkUnique(tree.pos(), m, enclScope)) {
                enclScope.enter(m);
            }
            this.annotate.annotateLater(tree.mods.annotations, localEnv, m, tree.pos());
            this.annotate.annotateTypeLater(tree, localEnv, m, tree.pos());
            if (tree.defaultValue != null) {
                this.annotateDefaultValueLater(tree.defaultValue, localEnv, m);
            }
        }
        finally {
            this.annotate.enterDone();
        }
    }

    Env<AttrContext> methodEnv(JCTree.JCMethodDecl tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dup(tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(tree.sym)));
        localEnv.enclMethod = tree;
        if (tree.sym.type != null) {
            AttrContext attrContext = (AttrContext)localEnv.info;
            Attr attr = this.attr;
            attr.getClass();
            attrContext.returnResult = attr.new Attr.ResultInfo(12, tree.sym.type.getReturnType());
        }
        if ((tree.mods.flags & 8L) != 0L) {
            ++((AttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        Env<AttrContext> localEnv = this.env;
        if ((tree.mods.flags & 8L) != 0L || (((AttrContext)this.env.info).scope.owner.flags() & 0x200L) != 0L) {
            localEnv = this.env.dup(tree, ((AttrContext)this.env.info).dup());
            ++((AttrContext)localEnv.info).staticLevel;
        }
        JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(tree.pos());
        this.annotate.enterStart();
        try {
            try {
                if (TreeInfo.isEnumInit(tree)) {
                    this.attr.attribIdentAsEnumType(localEnv, (JCTree.JCIdent)tree.vartype);
                } else {
                    this.attr.attribType((JCTree)tree.vartype, localEnv);
                    if (TreeInfo.isReceiverParam(tree)) {
                        this.checkReceiver(tree, localEnv);
                    }
                }
            }
            finally {
                this.deferredLintHandler.setPos(prevLintPos);
            }
            if ((tree.mods.flags & 0x400000000L) != 0L) {
                Type.ArrayType atype = (Type.ArrayType)tree.vartype.type;
                tree.vartype.type = atype.makeVarargs();
            }
            Scope.WriteableScope enclScope = this.enter.enterScope(this.env);
            Symbol.VarSymbol v = new Symbol.VarSymbol(0L, tree.name, tree.vartype.type, enclScope.owner);
            v.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, v, tree);
            tree.sym = v;
            if (tree.init != null) {
                v.flags_field |= 0x40000L;
                if ((v.flags_field & 0x10L) != 0L && this.needsLazyConstValue(tree.init)) {
                    Env<AttrContext> initEnv = this.getInitEnv(tree, this.env);
                    ((AttrContext)initEnv.info).enclVar = v;
                    v.setLazyConstValue(this.initEnv(tree, initEnv), this.attr, tree);
                }
            }
            if (this.chk.checkUnique(tree.pos(), v, enclScope)) {
                this.chk.checkTransparentVar(tree.pos(), v, enclScope);
                enclScope.enter(v);
            }
            this.annotate.annotateLater(tree.mods.annotations, localEnv, v, tree.pos());
            this.annotate.annotateTypeLater(tree.vartype, localEnv, v, tree.pos());
            v.pos = tree.pos;
        }
        finally {
            this.annotate.enterDone();
        }
    }

    void checkType(JCTree tree, Type type, String diag) {
        if (!tree.type.isErroneous() && !this.types.isSameType(tree.type, type)) {
            this.log.error(tree, diag, type, tree.type);
        }
    }

    void checkReceiver(JCTree.JCVariableDecl tree, Env<AttrContext> localEnv) {
        this.attr.attribExpr(tree.nameexpr, localEnv);
        Symbol.MethodSymbol m = localEnv.enclMethod.sym;
        if (m.isConstructor()) {
            Type outertype = m.owner.owner.type;
            if (outertype.hasTag(TypeTag.METHOD)) {
                outertype = m.owner.owner.owner.type;
            }
            if (outertype.hasTag(TypeTag.CLASS)) {
                this.checkType(tree.vartype, outertype, "incorrect.constructor.receiver.type");
                this.checkType(tree.nameexpr, outertype, "incorrect.constructor.receiver.name");
            } else {
                this.log.error(tree, "receiver.parameter.not.applicable.constructor.toplevel.class", new Object[0]);
            }
        } else {
            this.checkType(tree.vartype, m.owner.type, "incorrect.receiver.type");
            this.checkType(tree.nameexpr, m.owner.type, "incorrect.receiver.name");
        }
    }

    public boolean needsLazyConstValue(JCTree tree) {
        InitTreeVisitor initTreeVisitor = new InitTreeVisitor();
        tree.accept(initTreeVisitor);
        return initTreeVisitor.result;
    }

    Env<AttrContext> initEnv(JCTree.JCVariableDecl tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dupto(new AttrContextEnv((JCTree)tree, ((AttrContext)env.info).dup()));
        if (tree.sym.owner.kind == 2) {
            ((AttrContext)localEnv.info).scope = ((AttrContext)env.info).scope.dupUnshared(tree.sym);
        }
        if ((tree.mods.flags & 8L) != 0L || (env.enclClass.sym.flags() & 0x200L) != 0L && env.enclMethod == null) {
            ++((AttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    @Override
    public void visitTree(JCTree tree) {
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        if (tree.errs != null) {
            this.memberEnter(tree.errs, this.env);
        }
    }

    public Env<AttrContext> getMethodEnv(JCTree.JCMethodDecl tree, Env<AttrContext> env) {
        Env<AttrContext> mEnv = this.methodEnv(tree, env);
        ((AttrContext)mEnv.info).lint = ((AttrContext)mEnv.info).lint.augment(tree.sym);
        List<JCTree> l = tree.typarams;
        while (l.nonEmpty()) {
            ((AttrContext)mEnv.info).scope.enterIfAbsent(((JCTree.JCTypeParameter)l.head).type.tsym);
            l = l.tail;
        }
        l = tree.params;
        while (l.nonEmpty()) {
            ((AttrContext)mEnv.info).scope.enterIfAbsent(((JCTree.JCVariableDecl)l.head).sym);
            l = l.tail;
        }
        return mEnv;
    }

    public Env<AttrContext> getInitEnv(JCTree.JCVariableDecl tree, Env<AttrContext> env) {
        Env<AttrContext> iEnv = this.initEnv(tree, env);
        return iEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type attribImportType(JCTree tree, Env<AttrContext> env) {
        Assert.check(this.completionEnabled);
        try {
            this.completionEnabled = false;
            Type type = this.attr.attribType(tree, env);
            return type;
        }
        finally {
            this.completionEnabled = true;
        }
    }

    private boolean hasDeprecatedAnnotation(List<JCTree.JCAnnotation> annotations) {
        List<JCTree.JCAnnotation> al = annotations;
        while (!al.isEmpty()) {
            JCTree.JCAnnotation a = (JCTree.JCAnnotation)al.head;
            if (a.annotationType.type == this.syms.deprecatedType && a.args.isEmpty()) {
                return true;
            }
            al = al.tail;
        }
        return false;
    }

    void annotateDefaultValueLater(final JCTree.JCExpression defaultValue, final Env<AttrContext> localEnv, final Symbol.MethodSymbol m) {
        this.annotate.normal(new Annotate.Worker(){

            @Override
            public String toString() {
                String string = String.valueOf(String.valueOf(m.owner));
                String string2 = String.valueOf(String.valueOf(m));
                String string3 = String.valueOf(String.valueOf(defaultValue));
                return new StringBuilder(19 + string.length() + string2.length() + string3.length()).append("annotate ").append(string).append(".").append(string2).append(" default ").append(string3).toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject prev = MemberEnter.this.log.useSource(localEnv.toplevel.sourcefile);
                try {
                    MemberEnter.this.enterDefaultValue(defaultValue, localEnv, m);
                }
                finally {
                    MemberEnter.this.log.useSource(prev);
                }
            }
        });
        this.annotate.validate(new Annotate.Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject prev = MemberEnter.this.log.useSource(localEnv.toplevel.sourcefile);
                try {
                    MemberEnter.this.chk.validateAnnotationTree(defaultValue);
                }
                finally {
                    MemberEnter.this.log.useSource(prev);
                }
            }
        });
    }

    private void enterDefaultValue(JCTree.JCExpression defaultValue, Env<AttrContext> localEnv, Symbol.MethodSymbol m) {
        m.defaultValue = this.annotate.enterAttributeValue(m.type.getReturnType(), defaultValue, localEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (!this.completionEnabled) {
            Assert.check((sym.flags() & 0x1000000L) == 0L);
            sym.completer = this;
            return;
        }
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
        Type.ClassType ct = (Type.ClassType)c.type;
        Env<AttrContext> env = this.typeEnvs.get(c);
        JCTree.JCClassDecl tree = (JCTree.JCClassDecl)env.tree;
        boolean wasFirst = this.isFirst;
        this.isFirst = false;
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        JCDiagnostic.DiagnosticPosition prevLintPos = this.deferredLintHandler.setPos(tree.pos());
        try {
            Type supertype;
            this.dependencies.push(c);
            this.halfcompleted.append(env);
            c.flags_field |= 0x10000000L;
            if (c.owner.kind == 1) {
                this.memberEnter(env.toplevel, env.enclosing(JCTree.Tag.TOPLEVEL));
                this.todo.append(env);
            }
            if (c.owner.kind == 2) {
                c.owner.complete();
            }
            Env<AttrContext> baseEnv = this.baseEnv(tree, env);
            if (tree.extending != null) {
                this.annotate.annotateTypeLater(tree.extending, baseEnv, sym, tree.pos());
            }
            for (JCTree.JCExpression impl : tree.implementing) {
                this.annotate.annotateTypeLater(impl, baseEnv, sym, tree.pos());
            }
            this.annotate.flush();
            if (tree.extending != null) {
                this.dependencies.push(Dependencies.AttributionKind.EXTENDS, tree.extending);
                try {
                    supertype = this.attr.attribBase(tree.extending, baseEnv, true, false, true);
                }
                finally {
                    this.dependencies.pop();
                }
            } else {
                supertype = (tree.mods.flags & 0x4000L) != 0L ? this.attr.attribBase(this.enumBase(tree.pos, c), baseEnv, true, false, false) : (c.fullname == this.names.java_lang_Object ? Type.noType : this.syms.objectType);
            }
            ct.supertype_field = this.modelMissingTypes(supertype, tree.extending, false);
            ListBuffer<Type> interfaces = new ListBuffer<Type>();
            ListBuffer<Type> all_interfaces = null;
            HashSet<Type> interfaceSet = new HashSet<Type>();
            List<JCTree.JCExpression> interfaceTrees = tree.implementing;
            for (JCTree.JCExpression iface : interfaceTrees) {
                this.dependencies.push(Dependencies.AttributionKind.IMPLEMENTS, iface);
                try {
                    Type it = this.attr.attribBase(iface, baseEnv, false, true, true);
                    if (it.hasTag(TypeTag.CLASS)) {
                        interfaces.append(it);
                        if (all_interfaces != null) {
                            all_interfaces.append(it);
                        }
                        this.chk.checkNotRepeated(iface.pos(), this.types.erasure(it), interfaceSet);
                        continue;
                    }
                    if (all_interfaces == null) {
                        all_interfaces = new ListBuffer<Type>().appendList(interfaces);
                    }
                    all_interfaces.append(this.modelMissingTypes(it, iface, true));
                }
                finally {
                    this.dependencies.pop();
                }
            }
            if ((c.flags_field & 0x2000L) != 0L) {
                ct.interfaces_field = List.of(this.syms.annotationType);
                ct.all_interfaces_field = ct.interfaces_field;
            } else {
                ct.interfaces_field = interfaces.toList();
                List<Type> list = ct.all_interfaces_field = all_interfaces == null ? ct.interfaces_field : all_interfaces.toList();
            }
            if (c.fullname == this.names.java_lang_Object) {
                if (tree.extending != null) {
                    this.chk.checkNonCyclic(tree.extending.pos(), supertype);
                    ct.supertype_field = Type.noType;
                } else if (tree.implementing.nonEmpty()) {
                    this.chk.checkNonCyclic(((JCTree.JCExpression)tree.implementing.head).pos(), (Type)ct.interfaces_field.head);
                    ct.interfaces_field = List.nil();
                }
            }
            this.attr.attribAnnotationTypes(tree.mods.annotations, baseEnv);
            if (this.hasDeprecatedAnnotation(tree.mods.annotations)) {
                c.flags_field |= 0x20000L;
            }
            this.annotate.annotateLater(tree.mods.annotations, baseEnv, c, tree.pos());
            this.chk.checkNonCyclicDecl(tree);
            this.attr.attribTypeVariables(tree.typarams, baseEnv);
            for (JCTree.JCTypeParameter tp : tree.typarams) {
                this.annotate.annotateTypeLater(tp, baseEnv, sym, tree.pos());
            }
            if ((c.flags() & 0x200L) == 0L && !TreeInfo.hasConstructors(tree.defs)) {
                List<Type> argtypes = List.nil();
                List<Type> typarams = List.nil();
                List<Type> thrown = List.nil();
                long ctorFlags = 0L;
                boolean based = false;
                boolean addConstructor = true;
                JCTree.JCNewClass nc = null;
                if (c.name.isEmpty()) {
                    nc = (JCTree.JCNewClass)env.next.tree;
                    if (nc.constructor != null) {
                        addConstructor = nc.constructor.kind != 63;
                        Type superConstrType = this.types.memberType(c.type, nc.constructor);
                        argtypes = superConstrType.getParameterTypes();
                        typarams = superConstrType.getTypeArguments();
                        ctorFlags = nc.constructor.flags() & 0x400000000L;
                        if (nc.encl != null) {
                            argtypes = argtypes.prepend(nc.encl.type);
                            based = true;
                        }
                        thrown = superConstrType.getThrownTypes();
                    }
                }
                if (addConstructor) {
                    Symbol.MethodSymbol basedConstructor = nc != null ? (Symbol.MethodSymbol)nc.constructor : null;
                    JCTree constrDef = this.DefaultConstructor(this.make.at(tree.pos), c, basedConstructor, typarams, argtypes, thrown, ctorFlags, based);
                    tree.defs = tree.defs.prepend(constrDef);
                }
            }
            Symbol.VarSymbol thisSym = new Symbol.VarSymbol(262160L, this.names._this, c.type, c);
            thisSym.pos = 0;
            ((AttrContext)env.info).scope.enter(thisSym);
            if ((c.flags_field & 0x200L) == 0L && ct.supertype_field.hasTag(TypeTag.CLASS)) {
                Symbol.VarSymbol superSym = new Symbol.VarSymbol(262160L, this.names._super, ct.supertype_field, c);
                superSym.pos = 0;
                ((AttrContext)env.info).scope.enter(superSym);
            }
            if (c.owner.kind == 1 && c.owner != this.syms.unnamedPackage && this.syms.packageExists(c.fullname)) {
                this.log.error(tree.pos, "clash.with.pkg.of.same.name", Kinds.kindName(sym), c);
            }
            if (c.owner.kind == 1 && (c.flags_field & 1L) == 0L && !env.toplevel.sourcefile.isNameCompatible(c.name.toString(), JavaFileObject.Kind.SOURCE)) {
                c.flags_field |= 0x100000000000L;
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos(), ex);
        }
        finally {
            this.deferredLintHandler.setPos(prevLintPos);
            this.log.useSource(prev);
            this.dependencies.pop();
        }
        if (wasFirst) {
            HashSet<JCTree.JCCompilationUnit> topLevels = new HashSet<JCTree.JCCompilationUnit>();
            try {
                while (this.halfcompleted.nonEmpty()) {
                    Env<AttrContext> toFinish = this.halfcompleted.next();
                    topLevels.add(toFinish.toplevel);
                    this.finish(toFinish);
                    if (!this.allowTypeAnnos) continue;
                    this.typeAnnotations.organizeTypeAnnotationsSignatures(toFinish, (JCTree.JCClassDecl)toFinish.tree);
                    this.typeAnnotations.validateTypeAnnotationsSignatures(toFinish, (JCTree.JCClassDecl)toFinish.tree);
                }
            }
            finally {
                this.isFirst = true;
            }
            for (JCTree.JCCompilationUnit toplevel : topLevels) {
                this.chk.checkImportsResolvable(toplevel);
            }
        }
    }

    private Env<AttrContext> baseEnv(JCTree.JCClassDecl tree, Env<AttrContext> env) {
        Scope.WriteableScope baseScope = Scope.WriteableScope.create(tree.sym);
        for (Symbol sym : ((AttrContext)env.outer.info).scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (!sym.isLocal()) continue;
            baseScope.enter(sym);
        }
        if (tree.typarams != null) {
            List<JCTree.JCTypeParameter> typarams = tree.typarams;
            while (typarams.nonEmpty()) {
                baseScope.enter(((JCTree.JCTypeParameter)typarams.head).type.tsym);
                typarams = typarams.tail;
            }
        }
        Env<AttrContext> outer = env.outer;
        Env<AttrContext> localEnv = outer.dup(tree, ((AttrContext)outer.info).dup(baseScope));
        localEnv.baseClause = true;
        localEnv.outer = outer;
        ((AttrContext)localEnv.info).isSelfCall = false;
        return localEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(Env<AttrContext> env) {
        JavaFileObject prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            JCTree.JCClassDecl tree = (JCTree.JCClassDecl)env.tree;
            this.finishClass(tree, env);
        }
        finally {
            this.log.useSource(prev);
        }
    }

    private JCTree.JCExpression enumBase(int pos, Symbol.ClassSymbol c) {
        JCTree.JCTypeApply result = this.make.at(pos).TypeApply(this.make.QualIdent(this.syms.enumSym), List.of(this.make.Type(c.type)));
        return result;
    }

    Type modelMissingTypes(Type t, final JCTree.JCExpression tree, final boolean interfaceExpected) {
        if (!t.hasTag(TypeTag.ERROR)) {
            return t;
        }
        return new Type.ErrorType(t.getOriginalType(), t.tsym){
            private Type modelType;

            @Override
            public Type getModelType() {
                if (this.modelType == null) {
                    this.modelType = new Synthesizer(this.getOriginalType(), interfaceExpected).visit(tree);
                }
                return this.modelType;
            }
        };
    }

    JCTree DefaultConstructor(TreeMaker make, Symbol.ClassSymbol c, Symbol.MethodSymbol baseInit, List<Type> typarams, List<Type> argtypes, List<Type> thrown, long flags, boolean based) {
        flags = (c.flags() & 0x4000L) != 0L && this.types.supertype((Type)c.type).tsym == this.syms.enumSym ? flags & 0xFFFFFFFFFFFFFFF8L | 2L | 0x1000000000L : (flags |= c.flags() & 7L | 0x1000000000L);
        if (c.name.isEmpty()) {
            flags |= 0x20000000L;
        }
        Type.MethodType mType = new Type.MethodType(argtypes, null, thrown, c);
        Type initType = typarams.nonEmpty() ? new Type.ForAll(typarams, mType) : mType;
        Symbol.MethodSymbol init = new Symbol.MethodSymbol(flags, this.names.init, initType, c);
        init.params = this.createDefaultConstructorParams(make, baseInit, init, argtypes, based);
        List<JCTree.JCVariableDecl> params = make.Params(argtypes, init);
        List<JCTree.JCStatement> stats = List.nil();
        if (c.type != this.syms.objectType) {
            stats = stats.prepend(this.SuperCall(make, typarams, params, based));
        }
        JCTree.JCMethodDecl result = make.MethodDef(init, make.Block(0L, stats));
        return result;
    }

    private List<Symbol.VarSymbol> createDefaultConstructorParams(TreeMaker make, Symbol.MethodSymbol baseInit, Symbol.MethodSymbol init, List<Type> argtypes, boolean based) {
        List<Symbol.VarSymbol> initParams = null;
        List<Type> argTypesList = argtypes;
        if (based) {
            initParams = List.nil();
            Symbol.VarSymbol param = new Symbol.VarSymbol(0x200000000L, make.paramName(0), (Type)argtypes.head, init);
            initParams = initParams.append(param);
            argTypesList = argTypesList.tail;
        }
        if (baseInit != null && baseInit.params != null && baseInit.params.nonEmpty() && argTypesList.nonEmpty()) {
            initParams = initParams == null ? List.nil() : initParams;
            List<Symbol.VarSymbol> baseInitParams = baseInit.params;
            while (baseInitParams.nonEmpty() && argTypesList.nonEmpty()) {
                Symbol.VarSymbol param = new Symbol.VarSymbol(((Symbol.VarSymbol)baseInitParams.head).flags() | 0x200000000L, ((Symbol.VarSymbol)baseInitParams.head).name, (Type)argTypesList.head, init);
                initParams = initParams.append(param);
                baseInitParams = baseInitParams.tail;
                argTypesList = argTypesList.tail;
            }
        }
        return initParams;
    }

    JCTree.JCExpressionStatement SuperCall(TreeMaker make, List<Type> typarams, List<JCTree.JCVariableDecl> params, boolean based) {
        JCTree.JCExpression meth;
        if (based) {
            meth = make.Select(make.Ident((JCTree.JCVariableDecl)params.head), this.names._super);
            params = params.tail;
        } else {
            meth = make.Ident(this.names._super);
        }
        List<JCTree.JCExpression> typeargs = typarams.nonEmpty() ? make.Types(typarams) : null;
        return make.Exec(make.Apply(typeargs, meth, make.Idents(params)));
    }

    private class Synthesizer
    extends JCTree.Visitor {
        Type originalType;
        boolean interfaceExpected;
        List<Symbol.ClassSymbol> synthesizedSymbols = List.nil();
        Type result;

        Synthesizer(Type originalType, boolean interfaceExpected) {
            this.originalType = originalType;
            this.interfaceExpected = interfaceExpected;
        }

        Type visit(JCTree tree) {
            tree.accept(this);
            return this.result;
        }

        List<Type> visit(List<? extends JCTree> trees) {
            ListBuffer<Type> lb = new ListBuffer<Type>();
            for (JCTree jCTree : trees) {
                lb.append(this.visit(jCTree));
            }
            return lb.toList();
        }

        @Override
        public void visitTree(JCTree tree) {
            this.result = ((MemberEnter)MemberEnter.this).syms.errType;
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            this.result = !tree.type.hasTag(TypeTag.ERROR) ? tree.type : this.synthesizeClass((Name)tree.name, (Symbol)((MemberEnter)MemberEnter.this).syms.unnamedPackage).type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            if (!tree.type.hasTag(TypeTag.ERROR)) {
                this.result = tree.type;
            } else {
                Type selectedType;
                boolean prev = this.interfaceExpected;
                try {
                    this.interfaceExpected = false;
                    selectedType = this.visit(tree.selected);
                }
                finally {
                    this.interfaceExpected = prev;
                }
                Symbol.ClassSymbol c = this.synthesizeClass(tree.name, selectedType.tsym);
                this.result = c.type;
            }
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            if (!tree.type.hasTag(TypeTag.ERROR)) {
                this.result = tree.type;
            } else {
                Type.ClassType clazzType = (Type.ClassType)this.visit(tree.clazz);
                if (this.synthesizedSymbols.contains(clazzType.tsym)) {
                    this.synthesizeTyparams((Symbol.ClassSymbol)clazzType.tsym, tree.arguments.size());
                }
                final List<Type> actuals = this.visit(tree.arguments);
                this.result = new Type.ErrorType(tree.type, clazzType.tsym){

                    @Override
                    public List<Type> getTypeArguments() {
                        return actuals;
                    }
                };
            }
        }

        Symbol.ClassSymbol synthesizeClass(Name name, Symbol owner) {
            int flags = this.interfaceExpected ? 512 : 0;
            Symbol.ClassSymbol c = new Symbol.ClassSymbol(flags, name, owner);
            c.members_field = new Scope.ErrorScope(c);
            c.type = new Type.ErrorType(this.originalType, (Symbol.TypeSymbol)c){

                @Override
                public List<Type> getTypeArguments() {
                    return this.typarams_field;
                }
            };
            this.synthesizedSymbols = this.synthesizedSymbols.prepend(c);
            return c;
        }

        void synthesizeTyparams(Symbol.ClassSymbol sym, int n) {
            Type.ClassType ct = (Type.ClassType)sym.type;
            Assert.check(ct.typarams_field.isEmpty());
            if (n == 1) {
                Type.TypeVar v = new Type.TypeVar(MemberEnter.this.names.fromString("T"), sym, ((MemberEnter)MemberEnter.this).syms.botType, Type.noAnnotations);
                ct.typarams_field = ct.typarams_field.prepend(v);
            } else {
                int i = n;
                while (i > 0) {
                    int n2 = i--;
                    Type.TypeVar v = new Type.TypeVar(MemberEnter.this.names.fromString(new StringBuilder(12).append("T").append(n2).toString()), sym, ((MemberEnter)MemberEnter.this).syms.botType, Type.noAnnotations);
                    ct.typarams_field = ct.typarams_field.prepend(v);
                }
            }
        }
    }

    static class InitTreeVisitor
    extends JCTree.Visitor {
        private boolean result = true;

        InitTreeVisitor() {
        }

        @Override
        public void visitTree(JCTree tree) {
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass that) {
            this.result = false;
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray that) {
            this.result = false;
        }

        @Override
        public void visitLambda(JCTree.JCLambda that) {
            this.result = false;
        }

        @Override
        public void visitReference(JCTree.JCMemberReference that) {
            this.result = false;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation that) {
            this.result = false;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            tree.selected.accept(this);
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            tree.cond.accept(this);
            tree.truepart.accept(this);
            tree.falsepart.accept(this);
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            tree.expr.accept(this);
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            tree.expr.accept(this);
        }
    }

    abstract class SymbolImporter {
        Set<Symbol> processed = new HashSet<Symbol>();

        SymbolImporter() {
        }

        void importFrom(Symbol.TypeSymbol tsym) {
            if (tsym == null || !this.processed.add(tsym)) {
                return;
            }
            this.importFrom(((MemberEnter)MemberEnter.this).types.supertype((Type)tsym.type).tsym);
            for (Type t : MemberEnter.this.types.interfaces(tsym.type)) {
                this.importFrom(t.tsym);
            }
            this.doImport(tsym);
        }

        abstract void doImport(Symbol.TypeSymbol var1);
    }

    class MaskedImportFilter
    implements Scope.ImportFilter {
        private final Scope.ImportFilter delegate;
        private final Set<Symbol> maskedOut;

        public MaskedImportFilter(Scope.ImportFilter delegate, Set<Symbol> maskedOut) {
            this.delegate = delegate;
            this.maskedOut = maskedOut;
        }

        @Override
        public boolean accepts(Scope origin, Symbol sym) {
            return !this.maskedOut.contains(sym) && this.delegate.accepts(origin, sym);
        }
    }
}

