/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.X;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.io.protocol.GrowableProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.MessageVisitor;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.RawMessage;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageSet
extends ProtocolMessage<MessageSet> {
    private static final byte TAG_BEGIN_ITEM_GROUP = 11;
    private static final byte TAG_END_ITEM_GROUP = 12;
    private static final byte TAG_TYPE_ID = 16;
    private static final byte TAG_MESSAGE = 26;
    private final Map<Integer, Item> items;
    private static final Logger LOG = Logger.getLogger(MessageSet.class.getName());
    public static final MessageSet IMMUTABLE_DEFAULT_INSTANCE = new MessageSet(ImmutableMap.<Integer, Item>of());
    private static ProtocolType cachedClassProtocolType;
    private static final ConcurrentMap<Object, TypedIdInfo> typedIdHash;
    private static final TypedIdInfo TYPED_ID_ERROR;
    private static boolean allowDuplicates;
    public static final int NO_TYPE_ID = 0;

    @Override
    public MessageSet getDefaultInstanceForType() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public MessageSet() {
        this.items = Maps.newTreeMap();
    }

    private MessageSet(Map<Integer, Item> items) {
        this.items = items;
    }

    public <T extends ProtocolMessage> T get(Class<T> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        Item item = this.items.get(typeId);
        if (item == null || !item.parse(messageClass)) {
            return ProtocolSupport.newInstance(messageClass);
        }
        return (T)item.message;
    }

    public <T extends ProtocolMessage> T mutable(Class<T> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        Item item = this.items.get(typeId);
        if (item == null || !item.parse(messageClass)) {
            item = new Item(messageClass);
            this.items.put(typeId, item);
        }
        return (T)item.message;
    }

    public <T extends ProtocolMessage> void add(T message) {
        int typeId = MessageSet.getTypeId(message.getClass());
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(message.getClass());
        }
        Item item = new Item(message);
        this.items.put(typeId, item);
    }

    public boolean has(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            return false;
        }
        Item item = this.items.get(typeId);
        return item != null && item.parse(messageClass);
    }

    public boolean hasUnparsed(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        return typeId != 0 && this.items.containsKey(typeId);
    }

    public void remove(Class<? extends ProtocolMessage> messageClass) {
        int typeId = MessageSet.getTypeId(messageClass);
        if (typeId == 0) {
            throw MessageSet.newNoTypeIdException(messageClass);
        }
        this.items.remove(typeId);
    }

    public Set<Integer> getTypeIds() {
        return Collections.unmodifiableSet(this.items.keySet());
    }

    public int numMessages() {
        return this.items.size();
    }

    @Override
    public MessageSet mergeFrom(MessageSet that) {
        X.assertTrue(that != this);
        for (Map.Entry<Integer, Item> entry : that.items.entrySet()) {
            Item item = this.items.get(entry.getKey());
            if (item != null) {
                item.mergeFrom(entry.getValue());
                continue;
            }
            this.items.put(entry.getKey(), entry.getValue().copy());
        }
        return this;
    }

    @Override
    public boolean equals(MessageSet that, boolean ignoreUninterpreted) {
        if (this == that) {
            return true;
        }
        return ((Object)this.items).equals(that.items);
    }

    @Override
    public boolean equalsIgnoreUninterpreted(MessageSet that) {
        return this.equals(that, true);
    }

    @Override
    public boolean equals(MessageSet that) {
        return this.equals(that, false);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof MessageSet && this.equals((MessageSet)that);
    }

    @Override
    public int hashCode() {
        throw new RuntimeException("Do not use MessageSets as hash table keys.");
    }

    @Override
    public boolean isInitialized() {
        for (Item item : this.items.values()) {
            if (item.isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int encodingSize() {
        int size = 0;
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            size += entry.getValue().encodingSize(entry.getKey());
        }
        return size;
    }

    @Override
    public int maxEncodingSize() {
        int size = this.items.size() * 14;
        for (Item item : this.items.values()) {
            size += item.message.maxEncodingSize();
        }
        return size;
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public MessageSet newInstance() {
        return new MessageSet();
    }

    @Override
    public void outputTo(ProtocolSink sink) {
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            entry.getValue().output(sink, entry.getKey());
        }
    }

    @Override
    public boolean merge(ProtocolSource source) {
        block4: while (source.remaining() > 0) {
            int tag = source.getVarInt();
            switch (tag) {
                case 0: {
                    return false;
                }
                case 11: {
                    Item item = new Item();
                    int typeId = item.decode(source);
                    if (typeId == 0) {
                        return false;
                    }
                    Item oldItem = this.items.get(typeId);
                    if (oldItem == null) {
                        this.items.put(typeId, item);
                        continue block4;
                    }
                    oldItem.mergeFrom(item);
                    continue block4;
                }
            }
            source.skipData(tag);
        }
        return true;
    }

    @Override
    public ProtocolType getProtocolType() {
        return MessageSet.getClassProtocolType();
    }

    private static synchronized ProtocolType getClassProtocolType() {
        if (cachedClassProtocolType == null) {
            String name = MessageSet.class.getName();
            String fileName = "java/" + name.replace('.', '/') + ".java";
            final ProtocolDescriptor descriptor = new ProtocolDescriptor().setName(name).setProtoName("MessageSet").setFilename(fileName);
            cachedClassProtocolType = new ProtocolType(MessageSet.class, null, new ProtocolType.FieldType[0]){

                @Override
                protected void visitInternal(ProtocolMessage message, ProtocolType.Visitor visitor, Iterable<ProtocolType.FieldType> fields) {
                    ((MessageSet)message).visit(visitor);
                }

                @Override
                protected void visitInternal(ProtocolMessage message, MessageVisitor visitor, Iterable<ProtocolType.FieldType> fields) {
                    ((MessageSet)message).visit(visitor);
                }

                @Override
                public ProtocolDescriptor getProtocolDescriptor() {
                    return descriptor;
                }
            };
        }
        return cachedClassProtocolType;
    }

    private void visit(ProtocolType.Visitor visitor) {
        for (Map.Entry<Integer, Item> entry : this.items.entrySet()) {
            FieldType fieldType;
            Class<? extends ProtocolMessage> clazz;
            int typeId = entry.getKey();
            Item item = entry.getValue();
            if (item.messageClass == null && (clazz = MessageSet.getRegisteredClazz(typeId)) != null) {
                item.parse(clazz);
            }
            if (!visitor.shouldVisitField(fieldType = item.messageClass == null ? new FieldType(typeId) : new FieldType(item.messageClass, typeId), 1)) continue;
            visitor.visitForeign(fieldType, 0, item.message);
        }
    }

    static void outputTo(GrowableProtocolSink sink, int typeId, GrowableProtocolSink typeValue) {
        sink.putByte((byte)11);
        sink.putByte((byte)16);
        sink.putVarInt(typeId);
        sink.putByte((byte)26);
        sink.putVarInt(typeValue.position());
        sink.putBytes(typeValue.array(), 0, typeValue.position());
        sink.putByte((byte)12);
    }

    public static Class<? extends ProtocolMessage> getRegisteredClazz(int typeId) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typedIdHash.get(typeId);
        return typedIdInfo != null ? typedIdInfo.clazz : null;
    }

    public static Class<? extends ProtocolMessage> getRegisteredClazz(String typeName) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typedIdHash.get(typeName);
        return typedIdInfo != null ? typedIdInfo.clazz : null;
    }

    private static RuntimeException newNoTypeIdException(Class<? extends ProtocolMessage> cls) {
        return new RuntimeException("MESSAGE_TYPE_ID not defined for class: " + cls.getName());
    }

    public static int getTypeId(Class<? extends ProtocolMessage> clazz) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typedIdHash.get(clazz);
        if (typedIdInfo == null) {
            ProtocolSupport.newInstance(clazz);
            typedIdInfo = (TypedIdInfo)typedIdHash.get(clazz);
            if (typedIdInfo == null) {
                LOG.warning(String.format("Class %s has no type id", clazz.getName()));
                typedIdInfo = new TypedIdInfo(clazz, null, 0);
                typedIdHash.put(clazz, typedIdInfo);
            }
        }
        return typedIdInfo.typeId;
    }

    static void setAllowMessageSetNameAndTypeDuplicates(boolean value) {
        allowDuplicates = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTypeId(Class<? extends ProtocolMessage> clazz, int typeId, String name) {
        TypedIdInfo typedIdInfo = new TypedIdInfo(clazz, name, typeId);
        ConcurrentMap<Object, TypedIdInfo> concurrentMap = typedIdHash;
        synchronized (concurrentMap) {
            typedIdHash.put(clazz, typedIdInfo);
            if (allowDuplicates) {
                typedIdHash.put(name, typedIdInfo);
                typedIdHash.put(typeId, typedIdInfo);
            } else {
                TypedIdInfo oldInfo = typedIdHash.putIfAbsent(name, typedIdInfo);
                if (oldInfo != null && !oldInfo.equals(typedIdInfo)) {
                    LOG.warning(String.format("Class %s has an ambiguous external name", clazz.getName()));
                    typedIdHash.put(name, TYPED_ID_ERROR);
                }
                if ((oldInfo = typedIdHash.putIfAbsent(typeId, typedIdInfo)) != null && !oldInfo.equals(typedIdInfo)) {
                    LOG.severe(String.format("Class %s has an ambiguous MESSAGE_TYPE_ID", clazz.getName()));
                    typedIdHash.put(typeId, TYPED_ID_ERROR);
                }
            }
        }
    }

    static Class<? extends ProtocolMessage> findClass(String name) {
        TypedIdInfo typedIdInfo = (TypedIdInfo)typedIdHash.get(name);
        if (typedIdInfo == null) {
            return null;
        }
        if (typedIdInfo.clazz == null) {
            throw new RuntimeException("Ambiguous name: " + name);
        }
        return typedIdInfo.clazz;
    }

    @Override
    public MessageSet freeze() {
        for (Item item : this.items.values()) {
            item.message.freeze();
        }
        return this;
    }

    @Override
    public MessageSet unfreeze() {
        for (Item item : this.items.values()) {
            item.message.unfreeze();
        }
        return this;
    }

    @Override
    public boolean isFrozen() {
        for (Item item : this.items.values()) {
            if (!item.message.isFrozen()) continue;
            return true;
        }
        return false;
    }

    static {
        typedIdHash = Maps.newConcurrentMap();
        TYPED_ID_ERROR = new TypedIdInfo(null, null, 0);
        allowDuplicates = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypedIdInfo {
        final Class<? extends ProtocolMessage> clazz;
        final String name;
        final int typeId;

        public TypedIdInfo(Class<? extends ProtocolMessage> clazz, String name, int typeId) {
            this.clazz = clazz;
            this.name = name;
            this.typeId = typeId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TypedIdInfo)) {
                return false;
            }
            TypedIdInfo info = (TypedIdInfo)obj;
            if (this.typeId != info.typeId) {
                return false;
            }
            if (this.clazz != info.clazz) {
                return false;
            }
            return this.name != null && this.name.equals(info.name);
        }

        public int hashCode() {
            throw new RuntimeException("Do not use TypedIdInfo as hash table keys.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Item
    implements Serializable {
        ProtocolMessage message;
        Class<? extends ProtocolMessage> messageClass;
        private static final int MAX_ENCODING_OVERHEAD_PER_LINE = 14;

        public Item() {
        }

        public Item(Class<? extends ProtocolMessage> messageClass) {
            this.messageClass = messageClass;
            this.message = ProtocolSupport.newInstance(messageClass);
        }

        public Item(ProtocolMessage message) {
            this.messageClass = message.getClass();
            this.message = message;
        }

        public boolean parse(Class<? extends ProtocolMessage> newMessageClass) {
            if (this.messageClass != null) {
                return true;
            }
            ProtocolMessage newMessage = ProtocolSupport.newInstance(newMessageClass);
            if (!newMessage.parseFrom(((RawMessage)this.message).contents())) {
                LOG.warning("Parse error in message inside MessageSet.  Tried to parse as: " + newMessageClass.getName());
                return false;
            }
            this.message = newMessage;
            this.messageClass = newMessageClass;
            return true;
        }

        public void mergeFrom(Item other) {
            if (this.messageClass == null) {
                if (other.messageClass != null && !this.parse(other.messageClass)) {
                    this.messageClass = other.messageClass;
                    this.message = ProtocolSupport.newInstance(this.messageClass);
                }
            } else if (other.messageClass == null && !other.parse(this.messageClass)) {
                return;
            }
            this.message.mergeFrom(other.message);
        }

        public Item copy() {
            Item result = new Item();
            if (this.messageClass == null) {
                result.message = new RawMessage();
            } else {
                result.messageClass = this.messageClass;
                result.message = ProtocolSupport.newInstance(this.messageClass);
            }
            result.message.mergeFrom(this.message);
            return result;
        }

        public boolean equals(Item other) {
            if (this.messageClass == null ? other.messageClass != null && !this.parse(other.messageClass) : other.messageClass == null && !other.parse(this.messageClass)) {
                return false;
            }
            return this.message.equals(other.message);
        }

        public int hashCode() {
            throw new RuntimeException("Do not use MessageSets as hash table keys.");
        }

        public boolean equals(Object that) {
            return that instanceof Item && this.equals((Item)that);
        }

        public String findInitializationError() {
            return this.message.findInitializationError();
        }

        public boolean isInitialized() {
            return this.message.isInitialized();
        }

        public int encodingSize(int typeId) {
            return Protocol.stringSize(this.message.encodingSize()) + Protocol.varIntSize(typeId) + 4;
        }

        public void output(ProtocolSink sink, int typeId) {
            sink.putByte((byte)11);
            sink.putByte((byte)16);
            sink.putVarInt(typeId);
            sink.putByte((byte)26);
            sink.putVarInt(this.message.encodingSize());
            this.message.outputTo(sink);
            sink.putByte((byte)12);
        }

        public int decode(ProtocolSource source) {
            int tag;
            int typeId = 0;
            block5: while ((tag = source.getVarInt()) != 12) {
                switch (tag) {
                    case 0: {
                        return 0;
                    }
                    case 16: {
                        typeId = source.getVarInt();
                        continue block5;
                    }
                    case 26: {
                        int len = source.getVarInt();
                        source.push(len);
                        this.message = new RawMessage();
                        if (!this.message.merge(source)) {
                            return 0;
                        }
                        source.pop();
                        continue block5;
                    }
                }
                source.skipData(tag);
            }
            return typeId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldType
    extends ProtocolType.FieldType {
        public FieldType(Class<? extends ProtocolMessage> cls, int typeId) {
            super(((TypedIdInfo)typedIdHash.get(cls)).name, cls.getName(), typeId, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, cls);
        }

        public FieldType(int typeId) {
            super(String.valueOf(typeId), String.valueOf(typeId), typeId, ProtocolType.FieldBaseType.FOREIGN, ProtocolType.Presence.OPTIONAL, RawMessage.class);
        }

        @Override
        public int size(ProtocolMessage message) {
            return ((MessageSet)message).items.containsKey(this.getTag()) ? 1 : 0;
        }

        @Override
        public void visit(ProtocolMessage message, ProtocolType.Visitor visitor) {
            MessageSet messageSet = (MessageSet)message;
            Item item = (Item)messageSet.items.get(this.getTag());
            if (!visitor.shouldVisitField(this, item == null ? 0 : 1)) {
                return;
            }
            if (item != null) {
                visitor.visitForeign(this, 0, item.message);
            }
        }
    }
}

