/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueXml {
    static final String RATE_REGEX = "([0-9]+(\\.[0-9]+)?)/([smhd])";
    static final Pattern RATE_PATTERN = Pattern.compile("([0-9]+(\\.[0-9]+)?)/([smhd])");
    static final String TOTAL_STORAGE_LIMIT_REGEX = "^([0-9]+(\\.[0-9]*)?[BKMGT]?)";
    static final Pattern TOTAL_STORAGE_LIMIT_PATTERN = Pattern.compile("^([0-9]+(\\.[0-9]*)?[BKMGT]?)");
    private static final int MAX_QUEUE_NAME_LENGTH = 100;
    private static final String QUEUE_NAME_REGEX = "[a-zA-Z\\d-]{1,100}";
    private static final Pattern QUEUE_NAME_PATTERN = Pattern.compile("[a-zA-Z\\d-]{1,100}");
    private static final String DEFAULT_QUEUE = "default";
    private final LinkedHashMap<String, Entry> entries = new LinkedHashMap();
    private Entry lastEntry;
    private String totalStorageLimit = "";

    public static Entry defaultEntry() {
        return new Entry(DEFAULT_QUEUE, 5.0, RateUnit.SECOND, 5);
    }

    public Entry addNewEntry() {
        this.validateLastEntry();
        this.lastEntry = new Entry();
        return this.lastEntry;
    }

    public void addEntry(Entry entry) {
        this.validateLastEntry();
        this.lastEntry = entry;
        this.validateLastEntry();
    }

    public Collection<Entry> getEntries() {
        this.validateLastEntry();
        return this.entries.values();
    }

    public void validateLastEntry() {
        if (this.lastEntry == null) {
            return;
        }
        if (this.lastEntry.getName() == null) {
            throw new AppEngineConfigException("Queue entry must have a name.");
        }
        if (this.entries.containsKey(this.lastEntry.getName())) {
            throw new AppEngineConfigException("Queue entry has duplicate name.");
        }
        if (this.lastEntry.getRate() == null) {
            throw new AppEngineConfigException("A queue rate is required.");
        }
        this.entries.put(this.lastEntry.getName(), this.lastEntry);
        this.lastEntry = null;
    }

    public void setTotalStorageLimit(String s) {
        this.totalStorageLimit = s;
    }

    public String getTotalStorageLimit() {
        return this.totalStorageLimit;
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder();
        if (this.getTotalStorageLimit().length() > 0) {
            builder.append("total_storage_limit: " + this.getTotalStorageLimit() + "\n\n");
        }
        builder.append("queue:\n");
        for (Entry ent : this.getEntries()) {
            builder.append("- name: " + ent.getName() + "\n");
            builder.append("  rate: " + ent.getRate().toString() + '/' + ent.getRateUnit().getIdent() + "\n");
            Integer bucketSize = ent.getBucketSize();
            if (bucketSize == null) continue;
            builder.append("  bucket_size: " + bucketSize.toString() + "\n");
        }
        return builder.toString();
    }

    public static class Entry {
        private String name;
        private Double rate;
        private RateUnit rateUnit;
        private Integer bucketSize;

        public Entry() {
            this.name = null;
            this.rate = null;
            this.rateUnit = RateUnit.SECOND;
            this.bucketSize = null;
        }

        public Entry(String name, double rate, RateUnit rateUnit, int bucketSize) {
            this.name = name;
            this.rate = rate;
            this.rateUnit = rateUnit;
            this.bucketSize = bucketSize;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String queueName) {
            if (queueName == null || queueName.length() == 0 || !QUEUE_NAME_PATTERN.matcher(queueName).matches()) {
                throw new AppEngineConfigException("Queue name does not match expression " + QUEUE_NAME_PATTERN + "; found '" + queueName + "'");
            }
            this.name = queueName;
        }

        public Double getRate() {
            return this.rate;
        }

        public void setRate(double rate) {
            this.rate = rate;
        }

        public void setRate(String rateString) {
            if (rateString.equals("0")) {
                this.rate = 0.0;
                this.rateUnit = RateUnit.SECOND;
                return;
            }
            Matcher matcher = RATE_PATTERN.matcher(rateString);
            if (!matcher.matches()) {
                throw new AppEngineConfigException("Invalid queue rate was specified.");
            }
            String digits = matcher.group(1);
            this.rateUnit = RateUnit.valueOf(matcher.group(3).charAt(0));
            this.rate = Double.valueOf(digits);
        }

        public RateUnit getRateUnit() {
            return this.rateUnit;
        }

        public void setRateUnit(RateUnit rateUnit) {
            this.rateUnit = rateUnit;
        }

        public Integer getBucketSize() {
            return this.bucketSize;
        }

        public void setBucketSize(int bucketSize) {
            this.bucketSize = bucketSize;
        }

        public void setBucketSize(String bucketSize) {
            try {
                this.bucketSize = Integer.valueOf(bucketSize);
            }
            catch (NumberFormatException exception) {
                throw new AppEngineConfigException("Invalid bucket-size was specified.", exception);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bucketSize == null ? 0 : this.bucketSize.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.rate == null ? 0 : this.rate.hashCode());
            result = 31 * result + (this.rateUnit == null ? 0 : this.rateUnit.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.bucketSize == null ? other.bucketSize != null : !this.bucketSize.equals(other.bucketSize)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.rate == null ? other.rate != null : !this.rate.equals(other.rate)) {
                return false;
            }
            return !(this.rateUnit == null ? other.rateUnit != null : !this.rateUnit.equals((Object)other.rateUnit));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RateUnit {
        SECOND('s', 1),
        MINUTE('m', SECOND.getSeconds() * 60),
        HOUR('h', MINUTE.getSeconds() * 60),
        DAY('d', HOUR.getSeconds() * 24);

        final char ident;
        final int seconds;

        private RateUnit(char ident, int seconds) {
            this.ident = ident;
            this.seconds = seconds;
        }

        static RateUnit valueOf(char unit) {
            switch (unit) {
                case 's': {
                    return SECOND;
                }
                case 'm': {
                    return MINUTE;
                }
                case 'h': {
                    return HOUR;
                }
                case 'd': {
                    return DAY;
                }
            }
            throw new AppEngineConfigException("Invalid rate was specified.");
        }

        public char getIdent() {
            return this.ident;
        }

        public int getSeconds() {
            return this.seconds;
        }
    }
}

