/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import java.util.ArrayList;
import java.util.List;

public class IndexesXml {
    private List<Index> indexes = new ArrayList<Index>();

    public Index addNewIndex(String kind, boolean ancestors) {
        Index index = new Index(kind, ancestors);
        this.indexes.add(index);
        return index;
    }

    public String toYaml() {
        StringBuilder builder = new StringBuilder("indexes:\n");
        for (Index index : this.indexes) {
            builder.append("- kind: " + index.getKind() + "\n");
            if (index.doIndexAncestors()) {
                builder.append("  ancestor: yes\n");
            }
            builder.append("  properties:\n");
            for (PropertySort prop : index.getProperties()) {
                builder.append("  - name: " + prop.getPropertyName() + "\n");
                builder.append("    direction: " + (prop.isAscending() ? "asc" : "desc") + "\n");
            }
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Index {
        private String kind;
        private boolean ancestors;
        private List<PropertySort> properties;

        public Index(String kind, boolean ancestors) {
            this.kind = kind;
            this.ancestors = ancestors;
            this.properties = new ArrayList<PropertySort>();
        }

        public void addNewProperty(String name, boolean ascending) {
            this.properties.add(new PropertySort(name, ascending));
        }

        public String getKind() {
            return this.kind;
        }

        public boolean doIndexAncestors() {
            return this.ancestors;
        }

        public List<PropertySort> getProperties() {
            return this.properties;
        }
    }

    public class PropertySort {
        private String propName;
        private boolean ascending;

        public PropertySort(String propName, boolean ascending) {
            this.propName = propName;
            this.ascending = ascending;
        }

        public String getPropertyName() {
            return this.propName;
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }
}

