/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.payloads;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Token;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.payloads.PayloadHelper;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import com.google.appengine.repackaged.org.apache.lucene.index.Payload;
import java.io.IOException;

public class NumericPayloadTokenFilter
extends TokenFilter {
    private String typeMatch;
    private Payload thePayload;
    private PayloadAttribute payloadAtt;
    private TypeAttribute typeAtt;

    public NumericPayloadTokenFilter(TokenStream input, float payload, String typeMatch) {
        super(input);
        this.thePayload = new Payload(PayloadHelper.encodeFloat(payload));
        this.typeMatch = typeMatch;
        this.payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (this.typeAtt.type().equals(this.typeMatch)) {
                this.payloadAtt.setPayload(this.thePayload);
            }
            return true;
        }
        return false;
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }
}

