/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.geometry.Matrix3x3;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;

@GwtCompatible
public strictfp final class S2 {
    public static final double M_PI = Math.PI;
    public static final double M_1_PI = 0.3183098861837907;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_PI_4 = 0.7853981633974483;
    public static final double M_SQRT1_2 = 1.0 / Math.sqrt(2.0);
    public static final double M_SQRT2 = Math.sqrt(2.0);
    public static final double M_E = Math.E;
    public static final double DBL_EPSILON;
    private static final S2Point ORIGIN;
    public static final int SWAP_MASK = 1;
    public static final int INVERT_MASK = 2;
    private static final int[] posToOrientation;
    private static final int[][] posToIj;
    private static final int[][] IJ_TO_POS;
    private static final S2Point[] ORTHO_BASES;

    public static int posToOrientation(int position) {
        Preconditions.checkArgument((0 <= position && position < 4 ? 1 : 0) != 0);
        return posToOrientation[position];
    }

    public static int posToIJ(int orientation, int position) {
        return posToIj[orientation][position];
    }

    public static final int ijToPos(int orientation, int ijIndex) {
        return IJ_TO_POS[orientation][ijIndex];
    }

    public static S2Point origin() {
        return ORIGIN;
    }

    public static boolean isUnitLength(S2Point p) {
        return Math.abs(p.norm2() - 1.0) <= 5.0 * DBL_EPSILON;
    }

    public static boolean simpleCrossing(S2Point a, S2Point b, S2Point c, S2Point d) {
        S2Point ab = S2Point.crossProd(a, b);
        S2Point cd = S2Point.crossProd(c, d);
        double acb = -ab.dotProd(c);
        double cbd = -cd.dotProd(b);
        double bda = ab.dotProd(d);
        double dac = cd.dotProd(a);
        return acb * cbd > 0.0 && cbd * bda > 0.0 && bda * dac > 0.0;
    }

    public static S2Point robustCrossProd(S2Point a, S2Point b) {
        S2Point x = S2Point.crossProd(S2Point.add(b, a), S2Point.sub(b, a));
        if (!x.equalsPoint(S2Point.ORIGIN)) {
            return x;
        }
        return S2.ortho(a);
    }

    public static S2Point ortho(S2Point a) {
        int k = a.largestAbsComponent() - 1;
        if (k < 0) {
            k = 2;
        }
        return S2Point.normalize(S2Point.crossProd(a, ORTHO_BASES[k]));
    }

    static double area(S2Point a, S2Point b, S2Point c) {
        double sc;
        double sb;
        double sa = b.angle(c);
        double s = 0.5 * (sa + (sb = c.angle(a)) + (sc = a.angle(b)));
        if (s >= 3.0E-4) {
            double area;
            double s2 = s * s;
            double dmin = s - Math.max(sa, Math.max(sb, sc));
            if (dmin < 0.01 * s * s2 * s2 && dmin < s * (0.1 * (area = S2.girardArea(a, b, c)))) {
                return area;
            }
        }
        return 4.0 * Math.atan(Math.sqrt(Math.max(0.0, Math.tan(0.5 * s) * Math.tan(0.5 * (s - sa)) * Math.tan(0.5 * (s - sb)) * Math.tan(0.5 * (s - sc)))));
    }

    public static double girardArea(S2Point a, S2Point b, S2Point c) {
        S2Point ab = S2Point.crossProd(a, b);
        S2Point bc = S2Point.crossProd(b, c);
        S2Point ac = S2Point.crossProd(a, c);
        return Math.max(0.0, ab.angle(ac) - ab.angle(bc) + bc.angle(ac));
    }

    public static double signedArea(S2Point a, S2Point b, S2Point c) {
        return S2.area(a, b, c) * (double)S2.robustCCW(a, b, c);
    }

    public static S2Point planarCentroid(S2Point a, S2Point b, S2Point c) {
        return new S2Point((a.x + b.x + c.x) / 3.0, (a.y + b.y + c.y) / 3.0, (a.z + b.z + c.z) / 3.0);
    }

    public static S2Point trueCentroid(S2Point a, S2Point b, S2Point c) {
        double aAngle = b.angle(c);
        double bAngle = c.angle(a);
        double cAngle = a.angle(b);
        double ra = aAngle == 0.0 ? 1.0 : aAngle / Math.sin(aAngle);
        double rb = bAngle == 0.0 ? 1.0 : bAngle / Math.sin(bAngle);
        double rc = cAngle == 0.0 ? 1.0 : cAngle / Math.sin(cAngle);
        S2Point x = new S2Point(a.x, b.x - a.x, c.x - a.x);
        S2Point y = new S2Point(a.y, b.y - a.y, c.y - a.y);
        S2Point z = new S2Point(a.z, b.z - a.z, c.z - a.z);
        S2Point r = new S2Point(ra, rb - ra, rc - ra);
        return new S2Point(0.5 * S2Point.scalarTripleProduct(r, y, z), 0.5 * S2Point.scalarTripleProduct(r, z, x), 0.5 * S2Point.scalarTripleProduct(r, x, y));
    }

    public static boolean simpleCCW(S2Point a, S2Point b, S2Point c) {
        return S2Point.scalarTripleProduct(b, c, a) > 0.0;
    }

    public static int triageCCW(double det) {
        double kMaxDetError = 1.6E-15;
        if (det >= 1.6E-15) {
            return 1;
        }
        if (det <= -1.6E-15) {
            return -1;
        }
        return 0;
    }

    public static int robustCCW(S2Point a, S2Point b, S2Point c) {
        int ccw = S2.triageCCW(S2Point.scalarTripleProduct(c, a, b));
        if (ccw == 0) {
            ccw = S2.expensiveCCW(a, b, c);
        }
        return ccw;
    }

    public static int robustCCW(S2Point a, S2Point b, S2Point c, S2Point aCrossB) {
        int ccw = S2.triageCCW(aCrossB.dotProd(c));
        if (ccw == 0) {
            ccw = S2.expensiveCCW(a, b, c);
        }
        return ccw;
    }

    static int expensiveCCW(S2Point a, S2Point b, S2Point c) {
        if (a.equalsPoint(b) || b.equalsPoint(c) || c.equalsPoint(a)) {
            return 0;
        }
        int sign = S2.stableCCW(a, b, c);
        if (sign != 0) {
            return sign;
        }
        return S2.exactCCW(a, b, c);
    }

    private static final int stableCCW(S2Point a, S2Point b, S2Point c) {
        double maxError;
        double det;
        S2Point ab = S2Point.sub(b, a);
        S2Point bc = S2Point.sub(c, b);
        S2Point ca = S2Point.sub(a, c);
        double ab2 = ab.norm2();
        double bc2 = bc.norm2();
        double ca2 = ca.norm2();
        double detErrorMultiplier = 3.2321 * DBL_EPSILON;
        if (ab2 >= bc2 && ab2 >= ca2) {
            det = -S2Point.scalarTripleProduct(c, ca, bc);
            maxError = detErrorMultiplier * Math.sqrt(ca2 * bc2);
        } else if (bc2 >= ca2) {
            det = -S2Point.scalarTripleProduct(a, ab, ca);
            maxError = detErrorMultiplier * Math.sqrt(ab2 * ca2);
        } else {
            det = -S2Point.scalarTripleProduct(b, bc, ab);
            maxError = detErrorMultiplier * Math.sqrt(bc2 * ab2);
        }
        return Math.abs(det) <= maxError ? 0 : (det > 0.0 ? 1 : -1);
    }

    private static final int exactCCW(S2Point a, S2Point b, S2Point c) {
        int sign = Platform.sign(a, b, c);
        if (sign != 0) {
            return sign;
        }
        return S2.symbolicCCW(a, b, c);
    }

    private static final int symbolicCCW(S2Point a, S2Point b, S2Point c) {
        double sab = a.dotProd(b) > 0.0 ? -1.0 : 1.0;
        double sbc = b.dotProd(c) > 0.0 ? -1.0 : 1.0;
        double sca = c.dotProd(a) > 0.0 ? -1.0 : 1.0;
        S2Point vab = S2Point.add(a, S2Point.mul(b, sab));
        S2Point vbc = S2Point.add(b, S2Point.mul(c, sbc));
        S2Point vca = S2Point.add(c, S2Point.mul(a, sca));
        double dab = vab.norm2();
        double dbc = vbc.norm2();
        double dca = vca.norm2();
        double sign = dca < dbc || dca == dbc && a.lessThan(b) ? (dab < dbc || dab == dbc && a.lessThan(c) ? S2Point.scalarTripleProduct(a, vab, vca) * sab : S2Point.scalarTripleProduct(c, vca, vbc) * sca) : (dab < dca || dab == dca && b.lessThan(c) ? S2Point.scalarTripleProduct(b, vbc, vab) * sbc : S2Point.scalarTripleProduct(c, vca, vbc) * sca);
        if (sign > 0.0) {
            return 1;
        }
        if (sign < 0.0) {
            return -1;
        }
        int ccw = S2.planarOrderedCCW(new R2Vector(a.y, a.z), new R2Vector(b.y, b.z), new R2Vector(c.y, c.z));
        if (ccw == 0 && (ccw = S2.planarOrderedCCW(new R2Vector(a.z, a.x), new R2Vector(b.z, b.x), new R2Vector(c.z, c.x))) == 0) {
            ccw = S2.planarOrderedCCW(new R2Vector(a.x, a.y), new R2Vector(b.x, b.y), new R2Vector(c.x, c.y));
        }
        return ccw;
    }

    public static int planarCCW(R2Vector a, R2Vector b) {
        double db;
        double sab = a.dotProd(b) > 0.0 ? -1.0 : 1.0;
        R2Vector vab = R2Vector.add(a, R2Vector.mul(b, sab));
        double da = a.norm2();
        double sign = da < (db = b.norm2()) || da == db && a.lessThan(b) ? a.crossProd(vab) * sab : vab.crossProd(b);
        if (sign > 0.0) {
            return 1;
        }
        if (sign < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int planarOrderedCCW(R2Vector a, R2Vector b, R2Vector c) {
        int sum = 0;
        sum += S2.planarCCW(a, b);
        sum += S2.planarCCW(b, c);
        if ((sum += S2.planarCCW(c, a)) > 0) {
            return 1;
        }
        if (sum < 0) {
            return -1;
        }
        return 0;
    }

    public static boolean orderedCCW(S2Point a, S2Point b, S2Point c, S2Point o) {
        int sum = 0;
        if (S2.robustCCW(b, o, a) >= 0) {
            ++sum;
        }
        if (S2.robustCCW(c, o, b) >= 0) {
            ++sum;
        }
        if (S2.robustCCW(a, o, c) > 0) {
            ++sum;
        }
        return sum >= 2;
    }

    public static double angle(S2Point a, S2Point b, S2Point c) {
        return S2Point.crossProd(a, b).angle(S2Point.crossProd(c, b));
    }

    public static double turnAngle(S2Point a, S2Point b, S2Point c) {
        double outAngle = S2Point.crossProd(b, a).angle(S2Point.crossProd(c, b));
        return S2.robustCCW(a, b, c) > 0 ? outAngle : -outAngle;
    }

    public static ImmutableList<S2Point> getFrame(S2Point p0) {
        S2Point p1 = S2.ortho(p0);
        S2Point p2 = S2Point.normalize(S2Point.crossProd(p1, p0));
        return ImmutableList.of((Object)p2, (Object)p1, (Object)p0);
    }

    static S2Point rotate(S2Point p, Matrix3x3 r) {
        Matrix3x3 rotated = r.mult(new Matrix3x3(1, p.x, p.y, p.z));
        return S2Point.normalize(new S2Point(rotated.get(0, 0), rotated.get(1, 0), rotated.get(2, 0)));
    }

    public static boolean approxEquals(S2Point a, S2Point b, double maxError) {
        return a.angle(b) <= maxError;
    }

    public static boolean approxEquals(S2Point a, S2Point b) {
        return S2.approxEquals(a, b, 1.0E-15);
    }

    public static boolean approxEquals(double a, double b, double maxError) {
        return Math.abs(a - b) <= maxError;
    }

    public static boolean approxEquals(double a, double b) {
        return S2.approxEquals(a, b, 1.0E-15);
    }

    private S2() {
    }

    static {
        double machEps = 1.0;
        while (1.0 + (machEps /= 2.0) / 2.0 != 1.0) {
        }
        DBL_EPSILON = machEps;
        ORIGIN = new S2Point(-0.00999946643502502, 0.002592454260932412, 0.999946643502502);
        posToOrientation = new int[]{1, 0, 0, 3};
        posToIj = new int[][]{{0, 1, 3, 2}, {0, 2, 3, 1}, {3, 2, 0, 1}, {3, 1, 0, 2}};
        IJ_TO_POS = new int[][]{{0, 1, 3, 2}, {0, 3, 1, 2}, {2, 3, 1, 0}, {2, 1, 3, 0}};
        ORTHO_BASES = new S2Point[]{new S2Point(1.0, 0.0053, 0.00457), new S2Point(0.012, 1.0, 0.00457), new S2Point(0.012, 0.0053, 1.0)};
    }

    @GwtCompatible(emulated=true, serializable=false)
    public strictfp static final class Metric {
        private final double deriv;
        private final int dim;

        public Metric(int dim, double deriv) {
            this.deriv = deriv;
            this.dim = dim;
        }

        public double deriv() {
            return this.deriv;
        }

        public double getValue(int level) {
            return Math.scalb(this.deriv, -this.dim * level);
        }

        public int getClosestLevel(double value) {
            return this.getMinLevel((this.dim == 1 ? M_SQRT2 : 2.0) * value);
        }

        public int getMinLevel(double value) {
            if (value <= 0.0) {
                return 30;
            }
            int exponent = Platform.getExponent(value / this.deriv);
            int level = Math.max(0, Math.min(30, -(exponent >> this.dim - 1)));
            return level;
        }

        public int getMaxLevel(double value) {
            if (value <= 0.0) {
                return 30;
            }
            int exponent = Platform.getExponent(this.deriv / value);
            int level = Math.max(0, Math.min(30, exponent >> this.dim - 1));
            return level;
        }
    }
}

