/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import java.util.List;
import javax.annotation.CheckReturnValue;

@GwtCompatible
public final class Matrix3x3 {
    private final double[] values;
    private final int rows;
    private final int cols;

    public static Matrix3x3 fromCols(S2Point ... columns) {
        Matrix3x3 result = new Matrix3x3(3, columns.length);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                result.set(row, col, columns[col].get(row));
            }
        }
        return result;
    }

    public static Matrix3x3 fromCols(List<S2Point> frame) {
        return Matrix3x3.fromCols(frame.toArray(new S2Point[frame.size()]));
    }

    public Matrix3x3(int cols, double ... values) {
        Preconditions.checkArgument((cols >= 0 ? 1 : 0) != 0, (Object)"Negative rows not allowed.");
        this.rows = values.length / cols;
        this.cols = cols;
        Preconditions.checkArgument((this.rows * cols == values.length ? 1 : 0) != 0, (Object)"Values not an even multiple of 'cols'");
        this.values = values;
    }

    public Matrix3x3(int rows, int cols) {
        Preconditions.checkArgument((rows >= 0 ? 1 : 0) != 0, (Object)"Negative rows not allowed.");
        Preconditions.checkArgument((cols >= 0 ? 1 : 0) != 0, (Object)"Negative cols not allowed.");
        this.rows = rows;
        this.cols = cols;
        this.values = new double[rows * cols];
    }

    public int rows() {
        return this.rows;
    }

    public int cols() {
        return this.cols;
    }

    public void set(int row, int col, double value) {
        this.values[row * this.cols + col] = value;
    }

    public double get(int row, int col) {
        return this.values[row * this.cols + col];
    }

    @CheckReturnValue
    public Matrix3x3 transpose() {
        Matrix3x3 result = new Matrix3x3(this.cols, this.rows);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                result.set(row, col, this.get(col, row));
            }
        }
        return result;
    }

    @CheckReturnValue
    public Matrix3x3 mult(Matrix3x3 m) {
        Preconditions.checkArgument((this.cols == m.rows ? 1 : 0) != 0);
        Matrix3x3 result = new Matrix3x3(this.rows, m.cols);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                double sum = 0.0;
                for (int i = 0; i < this.cols; ++i) {
                    sum += this.get(row, i) * m.get(i, col);
                }
                result.set(row, col, sum);
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matrix3x3)) {
            return false;
        }
        Matrix3x3 m = (Matrix3x3)o;
        if (this.rows != m.rows || this.cols != m.cols) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == m.values[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long hash = 37L * (long)this.cols;
        for (int i = 0; i < this.values.length; ++i) {
            hash = 37L * hash + Platform.doubleHash(this.values[i]);
        }
        return (int)hash;
    }
}

