/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.KeyFilteredPseudoKind;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamespacePseudoKind
extends KeyFilteredPseudoKind {
    static final long EMPTY_NAMESPACE_ID = 1L;

    NamespacePseudoKind(LocalDatastoreService localDatastore) {
        super(localDatastore);
    }

    @Override
    public String getKindName() {
        return "__namespace__";
    }

    private String namespaceKeyToString(Key key) {
        if (key == null) {
            return null;
        }
        this.checkRequest(key.getParent() == null, String.format("Key filter on %s is invalid (key has parent) - received %s", "__namespace__", key));
        this.checkRequest(key.getKind().equals("__namespace__"), String.format("Key filter on %s is invalid (must be a key for %s) - received %s", "__namespace__", "__namespace__", key));
        if (key.getName() != null) {
            return key.getName();
        }
        this.checkRequest(key.getId() == 1L, String.format("Key filter on %s is invalid (key must be a name or the number %d) - received %s", "__namespace__", 1L, key));
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OnestoreEntity.EntityProto> runQuery(DatastorePb.Query query, Key startKey, boolean startInclusive, Key endKey, boolean endInclusive) {
        this.checkRequest(!query.hasAncestor(), "ancestor queries on __namespace__ not allowed");
        String app = query.getApp();
        String startNamespace = this.namespaceKeyToString(startKey);
        String endNamespace = this.namespaceKeyToString(endKey);
        LocalDatastoreService.Profile profile = this.getDatastore().getOrCreateProfile(app);
        Map<String, LocalDatastoreService.Extent> extents = profile.getExtents();
        HashSet<String> namespaceSet = new HashSet<String>();
        Map<String, LocalDatastoreService.Extent> map = extents;
        synchronized (map) {
            for (Map.Entry<String, LocalDatastoreService.Extent> entry : extents.entrySet()) {
                for (OnestoreEntity.EntityProto entity : entry.getValue().getEntities().values()) {
                    int namespacesCompared;
                    String namespace = entity.getKey().getNameSpace();
                    if (startNamespace != null) {
                        namespacesCompared = namespace.compareTo(startNamespace);
                        if (startInclusive && namespacesCompared < 0 || !startInclusive && namespacesCompared <= 0) continue;
                    }
                    if (endNamespace != null) {
                        namespacesCompared = namespace.compareTo(endNamespace);
                        if (endInclusive && namespacesCompared > 0 || !endInclusive && namespacesCompared >= 0) continue;
                    }
                    namespaceSet.add(namespace);
                }
            }
        }
        return this.makeNamespaceEntities(namespaceSet, app, query.getNameSpace());
    }

    private List<OnestoreEntity.EntityProto> makeNamespaceEntities(Set<String> namespaceSet, String app, String executionNamespace) {
        ArrayList namespaces = Lists.newArrayListWithCapacity((int)namespaceSet.size());
        for (String namespace : namespaceSet) {
            OnestoreEntity.EntityProto namespaceEntity = new OnestoreEntity.EntityProto();
            namespaces.add(namespaceEntity);
            OnestoreEntity.Path path = new OnestoreEntity.Path();
            if (namespace.equals("")) {
                path.addElement().setType("__namespace__").setId(1L);
            } else {
                path.addElement().setType("__namespace__").setName(namespace);
            }
            OnestoreEntity.Reference key = new OnestoreEntity.Reference().setApp(app).setPath(path);
            if (executionNamespace.length() > 0) {
                key.setNameSpace(executionNamespace);
            }
            namespaceEntity.setKey(key);
            namespaceEntity.getMutableEntityGroup().addElement(path.getElement(0));
        }
        return namespaces;
    }
}

