/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue.dev;

import com.google.appengine.api.labs.taskqueue.TaskQueuePb;
import com.google.appengine.api.labs.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.labs.taskqueue.dev.UrlFetchJob;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

class UrlFetchJobDetail
extends JobDetail {
    private static final String TASK_NAME_PROP = "taskName";
    private static final String QUEUE_NAME_PROP = "queueName";
    private static final String ADD_REQUEST_PROP = "addRequest";
    private static final String SERVER_URL = "serverUrl";
    private static final String RETRY_COUNT = "retryCount";
    private static final String RETRY_DELAY_MS = "retryDelayMs";
    private static final String CALLBACK = "callback";
    private static final int INITIAL_RETRY_DELAY_MS = 100;
    private static final int MAX_RETRY_DELAY_MS = 3600000;

    UrlFetchJobDetail(String taskName, String queueName, TaskQueuePb.TaskQueueAddRequest addRequest, String url, LocalTaskQueueCallback callback) {
        super(taskName, queueName, UrlFetchJob.class);
        JobDataMap dataMap = this.getJobDataMap();
        dataMap.put(TASK_NAME_PROP, taskName);
        dataMap.put(QUEUE_NAME_PROP, queueName);
        dataMap.put((Object)ADD_REQUEST_PROP, addRequest);
        dataMap.put(SERVER_URL, url);
        dataMap.put((Object)CALLBACK, callback);
        dataMap.put(RETRY_COUNT, 0);
        dataMap.put(RETRY_DELAY_MS, 50);
    }

    String getTaskName() {
        return (String)this.getJobDataMap().get(TASK_NAME_PROP);
    }

    String getQueueName() {
        return (String)this.getJobDataMap().get(QUEUE_NAME_PROP);
    }

    TaskQueuePb.TaskQueueAddRequest getAddRequest() {
        return (TaskQueuePb.TaskQueueAddRequest)this.getJobDataMap().get(ADD_REQUEST_PROP);
    }

    String getServerUrl() {
        return (String)this.getJobDataMap().get(SERVER_URL);
    }

    int getRetryCount() {
        return (Integer)this.getJobDataMap().get(RETRY_COUNT);
    }

    int getRetryDelayMs() {
        return (Integer)this.getJobDataMap().get(RETRY_DELAY_MS);
    }

    UrlFetchJobDetail retry() {
        UrlFetchJobDetail newJob = new UrlFetchJobDetail(this.getTaskName(), this.getQueueName(), this.getAddRequest(), this.getServerUrl(), this.getCallback());
        JobDataMap newDataMap = newJob.getJobDataMap();
        newDataMap.put(RETRY_COUNT, this.getRetryCount());
        newDataMap.put(RETRY_DELAY_MS, this.getRetryDelayMs());
        newJob.incrementRetryCount();
        newJob.incrementRetryDelayMs();
        return newJob;
    }

    int incrementRetryCount() {
        int newRetryCount = this.getRetryCount() + 1;
        this.getJobDataMap().put(RETRY_COUNT, newRetryCount);
        return newRetryCount;
    }

    int incrementRetryDelayMs() {
        int newRetryDelayMs = Math.min(this.getRetryDelayMs() * 2, this.getMaxRetryDelayMs());
        this.getJobDataMap().put(RETRY_DELAY_MS, newRetryDelayMs);
        return newRetryDelayMs;
    }

    int getMaxRetryDelayMs() {
        return 3600000;
    }

    LocalTaskQueueCallback getCallback() {
        return (LocalTaskQueueCallback)this.getJobDataMap().get(CALLBACK);
    }
}

