/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.io.TemplateLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class AbstractTemplateLoader
implements TemplateLoader {
    private String prefix = "/";
    private String suffix = ".hbs";

    @Override
    public String resolve(String uri) {
        return this.prefix + this.normalize(uri) + this.suffix;
    }

    protected String normalize(String location) {
        if (location.toString().startsWith("/")) {
            return location.substring(1);
        }
        return location;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = (String)Validate.notNull((Object)prefix, (String)"A view prefix is required.", (Object[])new Object[0]);
        if (!this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix = StringUtils.defaultString((String)suffix, (String)"");
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }
}

