/*
 * Decompiled with CFR 0.152.
 */
package smile.math.rbf;

import smile.math.rbf.RadialBasisFunction;

public class ThinPlateRadialBasis
implements RadialBasisFunction {
    private static final long serialVersionUID = 1L;
    private final double r0;

    public ThinPlateRadialBasis() {
        this(1.0);
    }

    public ThinPlateRadialBasis(double scale) {
        this.r0 = scale;
    }

    @Override
    public double f(double r) {
        return r <= 0.0 ? 0.0 : r * r * Math.log(r / this.r0);
    }

    public String toString() {
        return String.format("Thin Plate Radial Basis (r0 = %.4f)", this.r0);
    }
}

