/*
 * Decompiled with CFR 0.152.
 */
package smile.data.formula;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import smile.data.Tuple;
import smile.data.formula.AbstractFunction;
import smile.data.formula.Feature;
import smile.data.formula.Term;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class IntFunction
extends AbstractFunction {
    private final smile.util.function.IntFunction lambda;

    public IntFunction(String name, Term x, smile.util.function.IntFunction lambda) {
        super(name, x);
        this.lambda = lambda;
    }

    @Override
    public List<Feature> bind(StructType schema) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (final Feature feature : this.x.bind(schema)) {
            final StructField xfield = feature.field();
            final DataType dtype = xfield.dtype();
            if (!(dtype.isInt() || dtype.isShort() || dtype.isByte())) {
                throw new IllegalStateException(String.format("Invalid expression: %s(%s)", this.name, dtype));
            }
            features.add(new Feature(){
                final StructField field;
                final /* synthetic */ IntFunction this$0;
                {
                    IntFunction intFunction = this$0;
                    Objects.requireNonNull(intFunction);
                    this.this$0 = intFunction;
                    this.field = new StructField(String.format("%s(%s)", this.this$0.name, xfield.name()), dtype.isNullable() ? DataTypes.NullableIntType : DataTypes.IntType, xfield.measure());
                }

                @Override
                public StructField field() {
                    return this.field;
                }

                @Override
                public Integer apply(Tuple o) {
                    Object y = feature.apply(o);
                    if (y == null) {
                        return null;
                    }
                    return this.this$0.lambda.apply(((Number)y).intValue());
                }

                @Override
                public int applyAsInt(Tuple o) {
                    return this.this$0.lambda.apply(feature.applyAsInt(o));
                }
            });
        }
        return features;
    }
}

