/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.phantomjs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.service.DriverService;

public class PhantomJSDriverService
extends DriverService {
    private static final Logger LOG = Logger.getLogger(PhantomJSDriverService.class.getName());
    public static final String PHANTOMJS_EXECUTABLE_PATH_PROPERTY = "phantomjs.binary.path";
    public static final String PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY = "phantomjs.ghostdriver.path";
    public static final String PHANTOMJS_CLI_ARGS = "phantomjs.cli.args";
    public static final String PHANTOMJS_GHOSTDRIVER_CLI_ARGS = "phantomjs.ghostdriver.cli.args";
    public static final String PHANTOMJS_PAGE_SETTINGS_PREFIX = "phantomjs.page.settings.";
    public static final String PHANTOMJS_PAGE_CUSTOMHEADERS_PREFIX = "phantomjs.page.customHeaders.";
    private static final String PHANTOMJS_DEFAULT_LOGFILE = "phantomjsdriver.log";
    private static final String PHANTOMJS_DEFAULT_EXECUTABLE = "phantomjs";
    private static final String PHANTOMJS_DOC_LINK = "https://github.com/ariya/phantomjs/wiki";
    private static final String PHANTOMJS_DOWNLOAD_LINK = "http://phantomjs.org/download.html";
    private static final String GHOSTDRIVER_DOC_LINK = "https://github.com/detro/ghostdriver/blob/master/README.md";
    private static final String GHOSTDRIVER_DOWNLOAD_LINK = "https://github.com/detro/ghostdriver/downloads";

    private PhantomJSDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
        LOG.info("executable: " + executable.getAbsolutePath());
        LOG.info("port: " + port);
        LOG.info("arguments: " + args.toString());
        LOG.info("environment: " + environment.toString());
    }

    public static PhantomJSDriverService createDefaultService(Capabilities desiredCapabilities) {
        Proxy proxy = null;
        if (desiredCapabilities != null) {
            proxy = Proxies.extractProxy((Capabilities)desiredCapabilities);
        }
        File phantomjsfile = PhantomJSDriverService.findPhantomJS(desiredCapabilities, PHANTOMJS_DOC_LINK, PHANTOMJS_DOWNLOAD_LINK);
        File ghostDriverfile = PhantomJSDriverService.findGhostDriver(desiredCapabilities, GHOSTDRIVER_DOC_LINK, GHOSTDRIVER_DOWNLOAD_LINK);
        return new Builder().usingPhantomJSExecutable(phantomjsfile).usingGhostDriver(ghostDriverfile).usingAnyFreePort().withProxy(proxy).withLogFile(new File(PHANTOMJS_DEFAULT_LOGFILE)).usingCommandLineArguments(PhantomJSDriverService.findCLIArgumentsFromCaps(desiredCapabilities, PHANTOMJS_CLI_ARGS)).usingGhostDriverCommandLineArguments(PhantomJSDriverService.findCLIArgumentsFromCaps(desiredCapabilities, PHANTOMJS_GHOSTDRIVER_CLI_ARGS)).build();
    }

    public static PhantomJSDriverService createDefaultService() {
        return PhantomJSDriverService.createDefaultService(null);
    }

    protected static File findPhantomJS(Capabilities desiredCapabilities, String docsLink, String downloadLink) {
        String phantomjspath = null;
        if (desiredCapabilities != null && desiredCapabilities.getCapability(PHANTOMJS_EXECUTABLE_PATH_PROPERTY) != null) {
            phantomjspath = (String)desiredCapabilities.getCapability(PHANTOMJS_EXECUTABLE_PATH_PROPERTY);
        } else {
            phantomjspath = CommandLine.find((String)PHANTOMJS_DEFAULT_EXECUTABLE);
            phantomjspath = System.getProperty(PHANTOMJS_EXECUTABLE_PATH_PROPERTY, phantomjspath);
        }
        Preconditions.checkState((phantomjspath != null ? 1 : 0) != 0, (String)"The path to the driver executable must be set by the %s capability/system property/PATH variable; for more information, see %s. The latest version can be downloaded from %s", (Object[])new Object[]{PHANTOMJS_EXECUTABLE_PATH_PROPERTY, docsLink, downloadLink});
        File phantomjs = new File(phantomjspath);
        PhantomJSDriverService.checkExecutable((File)phantomjs);
        return phantomjs;
    }

    protected static File findGhostDriver(Capabilities desiredCapabilities, String docsLink, String downloadLink) {
        String ghostdriverpath = null;
        ghostdriverpath = desiredCapabilities != null && (String)desiredCapabilities.getCapability(PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY) != null ? (String)desiredCapabilities.getCapability(PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY) : System.getProperty(PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY, ghostdriverpath);
        if (ghostdriverpath != null) {
            Preconditions.checkState((ghostdriverpath != null ? 1 : 0) != 0, (String)"The path to the driver executable must be set by the '%s' capability/system property; for more information, see %s. The latest version can be downloaded from %s", (Object[])new Object[]{PHANTOMJS_GHOSTDRIVER_PATH_PROPERTY, docsLink, downloadLink});
            File ghostdriver = new File(ghostdriverpath);
            Preconditions.checkState((boolean)ghostdriver.exists(), (String)"The GhostDriver does not exist: %s", (Object[])new Object[]{ghostdriver.getAbsolutePath()});
            Preconditions.checkState((boolean)ghostdriver.isFile(), (String)"The GhostDriver is a directory: %s", (Object[])new Object[]{ghostdriver.getAbsolutePath()});
            Preconditions.checkState((boolean)ghostdriver.canRead(), (String)"The GhostDriver is not a readable file: %s", (Object[])new Object[]{ghostdriver.getAbsolutePath()});
            return ghostdriver;
        }
        return null;
    }

    private static String[] findCLIArgumentsFromCaps(Capabilities desiredCapabilities, String capabilityName) {
        Object cap;
        if (desiredCapabilities != null && (cap = desiredCapabilities.getCapability(capabilityName)) != null) {
            if (cap instanceof String[]) {
                return (String[])cap;
            }
            if (cap instanceof Collection) {
                try {
                    Collection capCollection = (Collection)cap;
                    return capCollection.toArray(new String[capCollection.size()]);
                }
                catch (Exception e) {
                    LOG.warning(String.format("Unable to set Capability '%s' as it was neither a String[] or a Collection<String>", capabilityName));
                }
            }
        }
        return new String[0];
    }

    public static class Builder {
        private int port = 0;
        private File phantomjs = null;
        private File ghostdriver = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;
        private Proxy proxy = null;
        private String[] commandLineArguments = null;
        private String[] ghostdriverCommandLineArguments = null;

        public Builder usingPhantomJSExecutable(File file) {
            Preconditions.checkNotNull((Object)file);
            PhantomJSDriverService.checkExecutable((File)file);
            this.phantomjs = file;
            return this;
        }

        public Builder usingGhostDriver(File file) {
            this.ghostdriver = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"Invalid port number: %d", (Object[])new Object[]{port});
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder usingCommandLineArguments(String[] commandLineArguments) {
            this.commandLineArguments = commandLineArguments;
            return this;
        }

        public Builder usingGhostDriverCommandLineArguments(String[] ghostdriverCommandLineArguments) {
            this.ghostdriverCommandLineArguments = ghostdriverCommandLineArguments;
            return this;
        }

        public PhantomJSDriverService build() {
            this.port = this.port == 0 ? PortProber.findFreePort() : this.port;
            Preconditions.checkState((this.phantomjs != null ? 1 : 0) != 0, (Object)"Path to PhantomJS executable not specified");
            try {
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                if (this.proxy != null) {
                    switch (this.proxy.getProxyType()) {
                        case MANUAL: {
                            if (!this.proxy.getHttpProxy().isEmpty()) {
                                argsBuilder.add((Object)"--proxy-type=http");
                                argsBuilder.add((Object)String.format("--proxy=%s", this.proxy.getHttpProxy()));
                                break;
                            }
                            if (!this.proxy.getSocksProxy().isEmpty()) {
                                argsBuilder.add((Object)"--proxy-type=socks5");
                                argsBuilder.add((Object)String.format("--proxy=%s", this.proxy.getSocksProxy()));
                                argsBuilder.add((Object)String.format("--proxy-auth=%s:%s", this.proxy.getSocksUsername(), this.proxy.getSocksPassword()));
                                break;
                            }
                            Preconditions.checkArgument((boolean)true, (Object)"PhantomJS supports only HTTP and Socks5 Proxy currently");
                            break;
                        }
                        case PAC: {
                            Preconditions.checkArgument((boolean)true, (Object)"PhantomJS doesn't support Proxy PAC files");
                            break;
                        }
                        case SYSTEM: {
                            argsBuilder.add((Object)"--proxy-type=system");
                            break;
                        }
                        case AUTODETECT: {
                            Preconditions.checkArgument((boolean)true, (Object)"PhantomJS doesn't support Proxy Auto-configuration");
                            break;
                        }
                        default: {
                            argsBuilder.add((Object)"--proxy-type=none");
                        }
                    }
                }
                if (this.commandLineArguments != null) {
                    argsBuilder.add((Object[])this.commandLineArguments);
                }
                if (this.ghostdriver != null) {
                    argsBuilder.add((Object)this.ghostdriver.getCanonicalPath());
                    argsBuilder.add((Object)String.format("--port=%d", this.port));
                    if (this.logFile != null) {
                        argsBuilder.add((Object)String.format("--logFile=%s", this.logFile.getAbsolutePath()));
                    }
                    if (this.ghostdriverCommandLineArguments != null) {
                        argsBuilder.add((Object[])this.ghostdriverCommandLineArguments);
                    }
                } else {
                    argsBuilder.add((Object)String.format("--webdriver=%d", this.port));
                    if (this.logFile != null) {
                        argsBuilder.add((Object)String.format("--webdriver-logfile=%s", this.logFile.getAbsolutePath()));
                    }
                }
                return new PhantomJSDriverService(this.phantomjs, this.port, argsBuilder.build(), this.environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

