/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.template.exception;

import com.github.adminfaces.template.util.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ApplicationException;
import javax.faces.application.FacesMessage;

@ApplicationException(rollback=true)
public class BusinessException
extends RuntimeException
implements Serializable {
    private String summary;
    private String detail;
    private String fieldId;
    private FacesMessage.Severity severity;
    private List<BusinessException> exceptionList = new ArrayList<BusinessException>();

    public BusinessException() {
    }

    public BusinessException(Throwable cause) {
        super(cause);
    }

    public BusinessException(String detail) {
        super(detail);
        this.detail = detail;
    }

    public BusinessException(String summary, String detail) {
        super(summary);
        this.detail = detail;
        this.summary = summary;
    }

    public BusinessException(String summary, FacesMessage.Severity severity) {
        super(summary);
        this.summary = summary;
        this.severity = severity;
    }

    public BusinessException(String summary, FacesMessage.Severity severity, String idToFocus) {
        super(summary);
        this.summary = summary;
        this.severity = severity;
        this.fieldId = idToFocus;
    }

    public BusinessException(String summary, String detail, String idToFocus) {
        super(summary);
        this.detail = detail;
        this.summary = summary;
        this.fieldId = idToFocus;
    }

    public BusinessException(String summary, String detail, FacesMessage.Severity severity) {
        super(summary);
        this.detail = detail;
        this.summary = summary;
        this.severity = severity;
    }

    public String getDetail() {
        return this.detail;
    }

    public BusinessException setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public BusinessException setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public FacesMessage.Severity getSeverity() {
        if (this.severity == null) {
            this.severity = FacesMessage.SEVERITY_ERROR;
        }
        return this.severity;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public BusinessException setFieldId(String fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    public BusinessException setSeverity(FacesMessage.Severity severity) {
        this.severity = severity;
        return this;
    }

    public List<BusinessException> getExceptionList() {
        return this.exceptionList;
    }

    public BusinessException setExceptionList(List<BusinessException> exceptionList) {
        this.exceptionList = exceptionList;
        return this;
    }

    public BusinessException addException(BusinessException be) {
        this.exceptionList.add(be);
        return this;
    }

    public void build() {
        if (Assert.has(this.summary) || Assert.has(this.detail) || Assert.has(this.exceptionList)) {
            throw this;
        }
    }
}

