/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply;

import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.services.service.ldap.Contact;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyAttachmentModel;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class ReplyFormUIModel
extends AbstractSerializableBean {
    public static final String PROPERTY_CONTACT = "contact";
    public static final String PROPERTY_TO = "to";
    public static final String PROPERTY_CC = "cc";
    public static final String PROPERTY_CCI = "cci";
    public static final String PROPERTY_FROM = "from";
    public static final String PROPERTY_SUBJECT = "subject";
    public static final String PROPERTY_MESSAGE = "message";
    public static final String PROPERTY_ORIGINAL_DEMAND = "originalDemand";
    public static final String PROPERTY_STAMP = "stamp";
    public static final String PROPERTY_ATTACHMENT = "attachment";
    public static final String PROPERTY_MAX_ATTACHMENT_LENGTH = "maxAttachmentLength";
    public static final String PROPERTY_TOTAL_ATTACHMENT_LENGTH = "totalAttachmentLength";
    public static final String PROPERTY_VALID = "valid";
    public static final String PROPERTY_SENDER_ALLOWED_DOMAINS = "senderAllowedDomains";
    public static final String PROPERTY_SENDER_ALLOWED_ADDRESSES = "senderAllowedAddresses";
    public static final String PROPERTY_READONLY = "readonly";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_READ_SENT_DATE = "readSentDate";
    protected Contact contact;
    protected String to;
    protected String cc;
    protected String cci;
    protected String from;
    protected String subject;
    protected String message;
    protected DemandeUIModel originalDemand;
    protected Stamp stamp;
    protected long maxAttachmentLength = 0L;
    protected long totalAttachmentLength = 0L;
    protected boolean valid = true;
    protected boolean readonly = false;
    protected boolean editable = false;
    protected Date readSentDate;
    protected List<String> senderAllowedDomains;
    protected List<String> senderAllowedAddresses;
    protected Set<ReplyAttachmentModel> attachments = new HashSet<ReplyAttachmentModel>();
    protected Set<ReplyAttachmentModel> availableAttachments = new HashSet<ReplyAttachmentModel>();
    protected File lastVisitedDirectory = FileUtils.getUserDirectory();
    protected Binder<ReplyFormUIModel, ReplyFormUIModel> copyBinder = BinderFactory.newBinder(ReplyFormUIModel.class);

    public void fromModel(ReplyFormUIModel other) {
        this.copyBinder.copyExcluding((Object)other, (Object)this, new String[]{PROPERTY_ORIGINAL_DEMAND});
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        Contact oldValue = this.getContact();
        this.contact = contact;
        this.firePropertyChange(PROPERTY_CONTACT, oldValue, contact);
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        String oldValue = this.getTo();
        this.to = to;
        this.firePropertyChange(PROPERTY_TO, oldValue, to);
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        String oldValue = this.cc;
        this.cc = cc;
        this.firePropertyChange(PROPERTY_CC, oldValue, cc);
    }

    public String getCci() {
        return this.cci;
    }

    public void setCci(String cci) {
        String oldValue = this.cci;
        this.cci = cci;
        this.firePropertyChange(PROPERTY_CCI, oldValue, cci);
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        String oldValue = this.getFrom();
        this.from = from;
        this.firePropertyChange(PROPERTY_FROM, oldValue, from);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        String oldValue = this.getSubject();
        this.subject = subject;
        this.firePropertyChange(PROPERTY_SUBJECT, oldValue, subject);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldValue = this.getMessage();
        this.message = message;
        this.firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }

    public DemandeUIModel getOriginalDemand() {
        return this.originalDemand;
    }

    public void setOriginalDemand(DemandeUIModel originalDemand) {
        DemandeUIModel oldValue = this.getOriginalDemand();
        this.originalDemand = originalDemand;
        this.firePropertyChange(PROPERTY_ORIGINAL_DEMAND, oldValue, originalDemand);
    }

    public Stamp getStamp() {
        return this.stamp;
    }

    public void setStamp(Stamp stamp) {
        Stamp oldValue = this.getStamp();
        this.stamp = stamp;
        this.firePropertyChange(PROPERTY_STAMP, oldValue, stamp);
    }

    public Set<ReplyAttachmentModel> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(ReplyAttachmentModel attachment) {
        this.attachments.add(attachment);
        this.firePropertyChange(PROPERTY_ATTACHMENT, null, this.getAttachments());
        this.setTotalAttachmentLength(this.totalAttachmentLength + attachment.getLength());
    }

    public void removeAttachment(ReplyAttachmentModel attachment) {
        this.attachments.remove(attachment);
        this.firePropertyChange(PROPERTY_ATTACHMENT, null, this.getAttachments());
        this.setTotalAttachmentLength(this.totalAttachmentLength - attachment.getLength());
    }

    public void setAttachments(Set<ReplyAttachmentModel> attachments) {
        this.attachments = attachments;
        if (this.availableAttachments != null) {
            this.availableAttachments.removeAll(attachments);
        }
        this.firePropertyChange(PROPERTY_ATTACHMENT, null, this.getAttachments());
    }

    public Set<ReplyAttachmentModel> getAvailableAttachments() {
        return this.availableAttachments;
    }

    public void addAvailableAttachment(ReplyAttachmentModel attachment) {
        this.availableAttachments.add(attachment);
    }

    public void removeAvailableAttachment(ReplyAttachmentModel attachment) {
        this.availableAttachments.remove(attachment);
    }

    public File getLastVisitedDirectory() {
        return this.lastVisitedDirectory;
    }

    public void setLastVisitedDirectory(File lastVisitedDirectory) {
        this.lastVisitedDirectory = lastVisitedDirectory;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        Boolean oldValue = this.isReadonly();
        this.readonly = readonly;
        this.firePropertyChange(PROPERTY_READONLY, oldValue, readonly);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        Boolean oldValue = this.isEditable();
        this.editable = editable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setReadSentDate(Date readSentDate) {
        Date oldValue = this.readSentDate;
        this.readSentDate = readSentDate;
        this.firePropertyChange(PROPERTY_READ_SENT_DATE, oldValue, readSentDate);
    }

    public Date getReadSentDate() {
        return this.readSentDate;
    }

    public long getMaxAttachmentLength() {
        return this.maxAttachmentLength / 1024L;
    }

    public void setMaxAttachmentLength(long maxAttachmentLength) {
        Long oldValue = this.getMaxAttachmentLength();
        this.maxAttachmentLength = maxAttachmentLength;
        this.firePropertyChange(PROPERTY_MAX_ATTACHMENT_LENGTH, oldValue, maxAttachmentLength);
    }

    public long getTotalAttachmentLength() {
        return this.totalAttachmentLength / 1024L;
    }

    public void setTotalAttachmentLength(long totalAttachmentLength) {
        Long oldValue = this.getTotalAttachmentLength();
        this.totalAttachmentLength = totalAttachmentLength;
        this.firePropertyChange(PROPERTY_TOTAL_ATTACHMENT_LENGTH, oldValue, this.getTotalAttachmentLength());
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        Boolean oldValue = this.isValid();
        this.valid = valid;
        this.firePropertyChange(PROPERTY_VALID, oldValue, valid);
    }

    public boolean isValid(String field) {
        boolean result = true;
        if (PROPERTY_FROM.equals(field)) {
            result = this.isEmailAllowed(this.getFrom());
        }
        return result;
    }

    protected boolean isEmailAllowed(String mail) {
        Preconditions.checkNotNull((Object)mail);
        List<String> senderAllowedAddresses = this.getSenderAllowedAddresses();
        if (senderAllowedAddresses != null) {
            for (String address : senderAllowedAddresses) {
                if (!mail.equalsIgnoreCase(address)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isDomainAllowed(String mail) {
        Preconditions.checkNotNull((Object)mail);
        List<String> senderAllowedDomains = this.getSenderAllowedDomains();
        if (CollectionUtils.isEmpty(senderAllowedDomains)) {
            return true;
        }
        for (String domain : senderAllowedDomains) {
            if (!mail.endsWith(domain)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttachmentSizeValid(long totalAttachmentLength) {
        boolean valid = this.maxAttachmentLength == 0L || this.totalAttachmentLength < this.maxAttachmentLength;
        return valid;
    }

    public List<String> getSenderAllowedDomains() {
        return this.senderAllowedDomains;
    }

    public void setSenderAllowedDomains(List<String> senderAllowedDomains) {
        List<String> oldValue = this.getSenderAllowedDomains();
        this.senderAllowedDomains = senderAllowedDomains;
        this.firePropertyChange(PROPERTY_SENDER_ALLOWED_DOMAINS, oldValue, senderAllowedDomains);
    }

    public void setSenderAllowedAddresses(List<String> senderAllowedAddresses) {
        List<String> oldValue = this.getSenderAllowedAddresses();
        this.senderAllowedAddresses = senderAllowedAddresses;
        this.firePropertyChange(PROPERTY_SENDER_ALLOWED_ADDRESSES, oldValue, senderAllowedAddresses);
    }

    public List<String> getSenderAllowedAddresses() {
        return this.senderAllowedAddresses;
    }
}

