/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryImpl;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentListener;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeRowModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.RangeTableModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.actions.SaveDemandeAction;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.tab.TabHandler;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.MoveToNextEditableCellAction;
import org.nuiton.jaxx.application.swing.table.MoveToNextEditableRowAction;
import org.nuiton.jaxx.application.swing.table.MoveToPreviousEditableCellAction;
import org.nuiton.jaxx.application.swing.table.MoveToPreviousEditableRowAction;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.util.beans.BeanMonitor;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class DemandeUIHandler
extends AbstractFaxToMailUIHandler<DemandeUIModel, DemandeUI>
implements CloseableUI,
TabHandler {
    private static final Log log = LogFactory.getLog(DemandeUIHandler.class);
    protected BeanMonitor monitor;
    protected PropertyChangeListener rangeRowListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DemandeUIModel model = (DemandeUIModel)DemandeUIHandler.this.getModel();
            String propertyName = evt.getPropertyName();
            if ("valid".equals(propertyName)) {
                RangeRowModel row = (RangeRowModel)((Object)evt.getSource());
                Boolean valid = (Boolean)evt.getNewValue();
                if (Boolean.TRUE.equals(valid)) {
                    model.addValidRangeRow(row);
                } else {
                    model.removeValidRangeRow(row);
                }
            }
            if ("valid".equals(propertyName) || "quotationQuantity".equals(propertyName) || "productQuantity".equals(propertyName) || "savQuantity".equals(propertyName)) {
                RangeTableModel rangeTableModel = (RangeTableModel)((Object)((DemandeUI)DemandeUIHandler.this.getUI()).getRangeTable().getModel());
                List rangeRows = rangeTableModel.getRows();
                Map<String, Integer> quantities = FaxToMailUIUtil.computeQuantities(rangeRows);
                model.setQuotationNb(quantities.get("quotationNb"));
                model.setPfNb(quantities.get("pfNb"));
                model.setSavNb(quantities.get("savNb"));
            }
        }
    };
    protected final PropertyChangeListener demandTypeListener = new PropertyChangeListener(){
        private int dividerLocation = -1;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DemandType oldType = (DemandType)evt.getOldValue();
            DemandType newType = (DemandType)evt.getNewValue();
            boolean oldRangePanelVisible = FaxToMailUIUtil.isRangePanelVisible(oldType);
            boolean newRangePanelVisible = FaxToMailUIUtil.isRangePanelVisible(newType);
            JSplitPane leftVerticalSplitPanel = ((DemandeUI)DemandeUIHandler.this.getUI()).getLeftVerticalSplitPanel();
            if (oldRangePanelVisible != newRangePanelVisible) {
                if (newRangePanelVisible) {
                    if (this.dividerLocation < 0) {
                        this.dividerLocation = leftVerticalSplitPanel.getLeftComponent().getPreferredSize().height + 10;
                    }
                    leftVerticalSplitPanel.setDividerLocation(this.dividerLocation);
                } else {
                    this.dividerLocation = leftVerticalSplitPanel.getDividerLocation();
                    leftVerticalSplitPanel.setDividerLocation(leftVerticalSplitPanel.getHeight());
                }
                leftVerticalSplitPanel.setName("leftVerticalSplitPanel" + newRangePanelVisible);
                DemandeUIHandler.this.getContext().getSwingSession().add((Component)leftVerticalSplitPanel, true);
            }
        }
    };

    public void afterInit(DemandeUI ui) {
        this.initUI(ui);
        DemandeUIModel model = (DemandeUIModel)this.getModel();
        Set<String> propertiesToIgnore = this.getPropertiesToIgnore();
        this.monitor = new BeanMonitor(true, propertiesToIgnore.toArray(new String[propertiesToIgnore.size()]));
        this.monitor.setBean((Object)model);
        MailFolder folder = model.getMailFolder();
        this.initBeanFilterableComboBox(ui.getPriorityComboBox(), this.getContext().getPriorityCache(), model.getPriority());
        this.initBeanFilterableComboBox(ui.getStatusComboBox(), Arrays.asList(DemandStatus.values()), model.getDemandStatus());
        ArrayList<DemandType> demandTypes = new ArrayList<DemandType>();
        Collection<DemandType> folderDemandTypes = this.getDemandTypeForFolder(folder);
        if (CollectionUtils.isEmpty(folderDemandTypes)) {
            demandTypes.addAll(this.getContext().getDemandTypeCache());
        } else {
            demandTypes.addAll(folderDemandTypes);
        }
        this.initBeanFilterableComboBox(ui.getDocTypeComboBox(), demandTypes, model.getDemandType());
        ArrayList<WaitingState> waitingStates = new ArrayList<WaitingState>();
        Collection<WaitingState> folderWaitingStates = this.getWaitingStateForFolder(folder);
        if (CollectionUtils.isEmpty(folderWaitingStates)) {
            waitingStates.addAll(this.getContext().getWaitingStateCache());
        } else {
            waitingStates.addAll(folderWaitingStates);
        }
        this.initBeanFilterableComboBox(ui.getWaitingStateComboBox(), waitingStates, model.getWaitingState());
        JTextPane editor = ui.getMailBodyField();
        FaxToMailUIUtil.setEmailContentInTextPane(this, editor, model);
        final JXTable table = ui.getRangeTable();
        ArrayList<Range> ranges = new ArrayList<Range>();
        Collection<Range> folderRanges = this.getRangeForFolder(folder);
        if (CollectionUtils.isEmpty(folderRanges)) {
            ranges.addAll(this.getContext().getRangeCache());
        } else {
            ranges.addAll(folderRanges);
        }
        Collections.sort(ranges, new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                return ObjectUtils.compare((Comparable)((Object)o1.getLabel()), (Comparable)((Object)o2.getLabel()));
            }
        });
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addComboDataColumnToModel((TableColumnModel)columnModel, RangeTableModel.RANGE_COLUMN, this.getDecorator(Range.class, null), ranges);
        this.addColumnToModel((TableColumnModel)columnModel, RangeTableModel.COMMAND_NUMBER_COLUMN);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, RangeTableModel.QUOTATION_QUANTITY_COLUMN, null, (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, RangeTableModel.PRODUCT_QUANTITY_COLUMN, null, (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, RangeTableModel.SAV_QUANTITY_COLUMN, null, (JTable)table);
        final RangeTableModel rangeTableModel = new RangeTableModel((TableColumnModelExt)columnModel);
        ArrayList<RangeRowModel> rangeRowModels = new ArrayList<RangeRowModel>(model.getValidRangeRowModels());
        rangeTableModel.setRows(rangeRowModels);
        Map<String, Integer> quantities = FaxToMailUIUtil.computeQuantities(rangeRowModels);
        model.setQuotationNb(quantities.get("quotationNb"));
        model.setPfNb(quantities.get("pfNb"));
        model.setSavNb(quantities.get("savNb"));
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            protected RangeRowModel currentRow;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel source = (ListSelectionModel)e.getSource();
                if (this.currentRow != null) {
                    this.currentRow.removePropertyChangeListener(DemandeUIHandler.this.rangeRowListener);
                }
                if (source.isSelectionEmpty()) {
                    this.currentRow = null;
                } else {
                    int rowIndex = source.getLeadSelectionIndex();
                    rowIndex = table.convertRowIndexToModel(rowIndex);
                    this.currentRow = (RangeRowModel)((Object)rangeTableModel.getEntry(rowIndex));
                    this.currentRow.addPropertyChangeListener(DemandeUIHandler.this.rangeRowListener);
                }
            }
        });
        table.setModel((TableModel)((Object)rangeTableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        table.getTableHeader().setReorderingAllowed(false);
        final MoveToNextEditableCellAction nextCellAction = MoveToNextEditableCellAction.newAction((AbstractApplicationTableModel)rangeTableModel, (JTable)table);
        final MoveToPreviousEditableCellAction previousCellAction = MoveToPreviousEditableCellAction.newAction((AbstractApplicationTableModel)rangeTableModel, (JTable)table);
        final MoveToNextEditableRowAction nextRowAction = MoveToNextEditableRowAction.newAction((AbstractApplicationTableModel)rangeTableModel, (JTable)table);
        final MoveToPreviousEditableRowAction previousRowAction = MoveToPreviousEditableRowAction.newAction((AbstractApplicationTableModel)rangeTableModel, (JTable)table);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TableCellEditor editor = table.getCellEditor();
                int keyCode = e.getKeyCode();
                if (keyCode == 37 || keyCode == 9 && e.isShiftDown()) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    previousCellAction.actionPerformed(null);
                } else if (keyCode == 39 || keyCode == 9) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    nextCellAction.actionPerformed(null);
                } else if (keyCode == 38 || keyCode == 10 && e.isShiftDown()) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    previousRowAction.actionPerformed(null);
                } else if (e.getKeyCode() == 10 || keyCode == 40) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    nextRowAction.actionPerformed(null);
                }
            }
        };
        table.addKeyListener((KeyListener)keyAdapter);
        HighlightPredicate rowIsInvalidPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int viewRow;
                int modelRow;
                boolean result = false;
                AbstractApplicationTableModel model = (AbstractApplicationTableModel)table.getModel();
                RangeRowModel row = (RangeRowModel)((Object)model.getEntry(modelRow = adapter.convertRowIndexToModel(viewRow = adapter.row)));
                result = !row.isValid();
                return result;
            }
        };
        Color color = new Color(255, 51, 51);
        table.addHighlighter((Highlighter)new ColorHighlighter(rowIsInvalidPredicate, color, Color.WHITE, color.darker(), Color.WHITE));
        SwingValidator<DemandeUIModel> validator = this.getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        model.setModify(false);
        ui.getAttachmentsButton().getBean().addAttachmentListener(new AttachmentListener(){

            @Override
            public void onAttachmentOpened(Attachment attachment, boolean original) {
                String topiaId = ((DemandeUIModel)DemandeUIHandler.this.getModel()).getTopiaId();
                if (topiaId != null && attachment.isPersisted()) {
                    String filename = original ? attachment.getOriginalFileName() : FaxToMailUIUtil.getEditedFileName(attachment.getOriginalFileName());
                    FaxToMailServiceContext serviceContext = DemandeUIHandler.this.getContext().newServiceContext();
                    Email email = serviceContext.getEmailService().addToHistory(topiaId, HistoryType.ATTACHMENT_OPENING, DemandeUIHandler.this.getContext().getCurrentUser(), new Date(), new String[]{filename});
                    ((DemandeUIModel)DemandeUIHandler.this.getModel()).setHistory(email.getHistory());
                }
            }

            @Override
            public void onAttachmentEdited(Attachment attachment) {
                String topiaId = ((DemandeUIModel)DemandeUIHandler.this.getModel()).getTopiaId();
                if (topiaId != null && attachment.isPersisted()) {
                    HistoryImpl history = new HistoryImpl();
                    history.setType(HistoryType.ATTACHMENT_MODIFICATION);
                    history.setFaxToMailUser(DemandeUIHandler.this.getContext().getCurrentUser());
                    history.setModificationDate(new Date());
                    history.setFields((Set)Sets.newHashSet((Object[])new String[]{attachment.getOriginalFileName()}));
                    ((DemandeUIModel)DemandeUIHandler.this.getModel()).getHistory().add((History)history);
                }
                ((DemandeUIModel)DemandeUIHandler.this.getModel()).setModify(true);
            }
        });
        JSplitPane leftVerticalSplitPanel = ((DemandeUI)this.getUI()).getLeftVerticalSplitPanel();
        model.addPropertyChangeListener("demandType", this.demandTypeListener);
        leftVerticalSplitPanel.setName("leftVerticalSplitPanel" + FaxToMailUIUtil.isRangePanelVisible(model.getDemandType()));
        this.getContext().getSwingSession().add((Component)leftVerticalSplitPanel, true);
        JPopupMenu menu = ui.getMatchingClientsPopup();
        Collection<Client> matchingClients = model.getMatchingClients();
        if (matchingClients != null) {
            for (final Client client : matchingClients) {
                menu.add(new JMenuItem(new AbstractAction(this.decorate((Serializable)client)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((DemandeUIModel)DemandeUIHandler.this.getModel()).setClient(client);
                    }
                }));
            }
        }
        BeanFilterableComboBox<Client> clientComboBox = ui.getClientComboBox();
        clientComboBox.getComboBoxModel().setWildcardCharacter(null);
        this.initBeanFilterableComboBox(clientComboBox, model.getAllowedClients(), model.getClient());
        this.listModelIsModify(model);
    }

    protected JComponent getComponentToFocus() {
        return ((DemandeUI)this.getUI()).getObjectField();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.add("editable");
        result.add("history");
        result.add("groupedDemandes");
        result.add("replies");
        result.add("validRangeRowModels");
        return result;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
        DemandeUIModel model = (DemandeUIModel)this.getModel();
        serviceContext.getEmailService().unlockEmail(model.getTopiaId());
        model.removePropertyChangeListener(this.listModelListener);
        model.removePropertyChangeListener("demandType", this.demandTypeListener);
        for (RangeRowModel row : model.getValidRangeRowModels()) {
            row.removePropertyChangeListener(this.rangeRowListener);
        }
        ((DemandeUI)this.ui).getAttachmentsButton().onCloseUI();
        ((DemandeUI)this.ui).getHistoryButton().onCloseUI();
        ((DemandeUI)this.ui).getDemandRepliesButton().onCloseUI();
        this.clearValidators();
    }

    public void closeButtonPopups() {
        ((DemandeUI)this.ui).getAttachmentsButton().setSelected(false);
        ((DemandeUI)this.ui).getHistoryButton().setSelected(false);
        ((DemandeUI)this.ui).getDemandRepliesButton().setSelected(false);
    }

    public boolean quitUI() {
        boolean result = this.quitScreen2(true, ((DemandeUIModel)this.getModel()).isModify(), I18n.t((String)"faxtomail.demande.askCancelEditBeforeLeaving.cancelSave", (Object[])new Object[0]), I18n.t((String)"faxtomail.demande.askSaveBeforeLeaving.save", (Object[])new Object[0]), this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, SaveDemandeAction.class));
        return result;
    }

    public SwingValidator<DemandeUIModel> getValidator() {
        return ((DemandeUI)this.ui).getValidator();
    }

    @Override
    public Component getTopestUI() {
        return (Component)this.getUI();
    }

    protected Collection<WaitingState> getWaitingStateForFolder(MailFolder folder) {
        Collection result = null;
        while (CollectionUtils.isEmpty(result) && folder != null) {
            result = folder.getWaitingStates();
            folder = folder.getParent();
        }
        return result;
    }

    protected Collection<DemandType> getDemandTypeForFolder(MailFolder folder) {
        Collection result = null;
        while (CollectionUtils.isEmpty(result) && folder != null) {
            result = folder.getDemandTypes();
            folder = folder.getParent();
        }
        return result;
    }

    protected Collection<Range> getRangeForFolder(MailFolder folder) {
        Collection result = null;
        while (CollectionUtils.isEmpty(result) && folder != null) {
            result = folder.getRanges();
            folder = folder.getParent();
        }
        return result;
    }

    public BeanMonitor getMonitor() {
        return this.monitor;
    }

    public boolean onHideTab(int currentIndex, int newIndex) {
        this.closeButtonPopups();
        return true;
    }

    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators(this.getValidator());
        JFrame frame = (JFrame)SwingUtil.getParentContainer((Object)this.getUI(), JFrame.class);
        if (frame != null) {
            frame.setTitle(((DemandeUIModel)this.getModel()).getTitle());
        }
    }

    public boolean onRemoveTab() {
        boolean result = this.quitUI();
        if (result) {
            this.onCloseUI();
        }
        return result;
    }

    public void showMatchingClientsPopup(ActionEvent event) {
        JButton button = (JButton)event.getSource();
        ((DemandeUI)this.getUI()).getMatchingClientsPopup().show(button, 0, button.getBounds().height);
    }

    protected void registerValidators(SwingValidator ... validators) {
        DemandesUI demandesUI = (DemandesUI)JAXXWidgetUtil.getParent((Object)this.getUI(), DemandesUI.class);
        DemandesUIHandler handler = demandesUI.getHandler();
        handler.clearValidators();
        for (SwingValidator validator : validators) {
            handler.registerValidator(validator);
        }
    }

    protected void clearValidators() {
        DemandesUI demandesUI = (DemandesUI)JAXXWidgetUtil.getParent((Object)this.getUI(), DemandesUI.class);
        DemandesUIHandler handler = demandesUI.getHandler();
        handler.clearValidators();
    }
}

