/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.testutils;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RefKey;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.PdfContentStreamProcessor;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.SimpleTextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TaggedPdfReaderTool;
import com.itextpdf.text.pdf.parser.TextExtractionStrategy;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.xml.XMLUtil;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.XMPMetaFactory;
import com.itextpdf.xmp.XMPUtils;
import com.itextpdf.xmp.options.SerializeOptions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTool {
    private String gsExec = System.getProperty("gsExec");
    private String compareExec = System.getProperty("compareExec");
    private final String gsParams = " -dNOPAUSE -dBATCH -sDEVICE=png16m -r150 -sOutputFile=<outputfile> <inputfile>";
    private final String compareParams = " \"<image1>\" \"<image2>\" \"<difference>\"";
    private static final String cannotOpenTargetDirectory = "Cannot open target directory for <filename>.";
    private static final String gsFailed = "GhostScript failed for <filename>.";
    private static final String unexpectedNumberOfPages = "Unexpected number of pages for <filename>.";
    private static final String differentPages = "File <filename> differs on page <pagenumber>.";
    private static final String undefinedGsPath = "Path to GhostScript is not specified. Please use -DgsExec=<path_to_ghostscript> (e.g. -DgsExec=\"C:/Program Files/gs/gs9.14/bin/gswin32c.exe\")";
    private static final String ignoredAreasPrefix = "ignored_areas_";
    private String cmpPdf;
    private String cmpPdfName;
    private String cmpImage;
    private String outPdf;
    private String outPdfName;
    private String outImage;
    List<PdfDictionary> outPages;
    List<RefKey> outPagesRef;
    List<PdfDictionary> cmpPages;
    List<RefKey> cmpPagesRef;
    private int compareByContentErrorsLimit = 1;
    private boolean generateCompareByContentXmlReport = false;

    private String compare(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException, InterruptedException, DocumentException {
        return this.compare(outPath, differenceImagePrefix, ignoredAreas, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String compare(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas, List<Integer> equalPages) throws IOException, InterruptedException, DocumentException {
        int cnt;
        String line;
        File[] cmpImageFiles;
        File[] imageFiles;
        File targetDir;
        if (this.gsExec == null) {
            return undefinedGsPath;
        }
        if (!new File(this.gsExec).exists()) {
            return new File(this.gsExec).getAbsolutePath() + " does not exist";
        }
        if (!outPath.endsWith("/")) {
            outPath = outPath + "/";
        }
        if (!(targetDir = new File(outPath)).exists()) {
            targetDir.mkdirs();
        } else {
            for (File file : imageFiles = targetDir.listFiles(new PngFileFilter())) {
                file.delete();
            }
            for (File file : cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter())) {
                file.delete();
            }
        }
        File diffFile = new File(outPath + differenceImagePrefix);
        if (diffFile.exists()) {
            diffFile.delete();
        }
        if (ignoredAreas != null && !ignoredAreas.isEmpty()) {
            PdfReader cmpReader = new PdfReader(this.cmpPdf);
            PdfReader outReader = new PdfReader(this.outPdf);
            PdfStamper outStamper = new PdfStamper(outReader, new FileOutputStream(outPath + ignoredAreasPrefix + this.outPdfName));
            PdfStamper cmpStamper = new PdfStamper(cmpReader, new FileOutputStream(outPath + ignoredAreasPrefix + this.cmpPdfName));
            for (Map.Entry<Integer, List<Rectangle>> entry : ignoredAreas.entrySet()) {
                int pageNumber = entry.getKey();
                List<Rectangle> rectangles = entry.getValue();
                if (rectangles == null || rectangles.isEmpty()) continue;
                PdfContentByte outCB = outStamper.getOverContent(pageNumber);
                PdfContentByte cmpCB = cmpStamper.getOverContent(pageNumber);
                for (Rectangle rect : rectangles) {
                    rect.setBackgroundColor(BaseColor.BLACK);
                    outCB.rectangle(rect);
                    cmpCB.rectangle(rect);
                }
            }
            outStamper.close();
            cmpStamper.close();
            outReader.close();
            cmpReader.close();
            this.init(outPath + ignoredAreasPrefix + this.outPdfName, outPath + ignoredAreasPrefix + this.cmpPdfName);
        }
        if (!targetDir.exists()) return cannotOpenTargetDirectory.replace("<filename>", this.outPdf);
        String gsParams = this.gsParams.replace("<outputfile>", outPath + this.cmpImage).replace("<inputfile>", this.cmpPdf);
        Process p = Runtime.getRuntime().exec(this.gsExec + gsParams);
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
        if (p.waitFor() != 0) return gsFailed.replace("<filename>", this.cmpPdf);
        gsParams = this.gsParams.replace("<outputfile>", outPath + this.outImage).replace("<inputfile>", this.outPdf);
        p = Runtime.getRuntime().exec(this.gsExec + gsParams);
        bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = bri.readLine()) != null) {
            System.out.println(line);
        }
        bri.close();
        while ((line = bre.readLine()) != null) {
            System.out.println(line);
        }
        bre.close();
        int exitValue = p.waitFor();
        if (exitValue != 0) return gsFailed.replace("<filename>", this.outPdf);
        imageFiles = targetDir.listFiles(new PngFileFilter());
        cmpImageFiles = targetDir.listFiles(new CmpPngFileFilter());
        boolean bUnexpectedNumberOfPages = false;
        if (imageFiles.length != cmpImageFiles.length) {
            bUnexpectedNumberOfPages = true;
        }
        if ((cnt = Math.min(imageFiles.length, cmpImageFiles.length)) < 1) {
            return "No files for comparing!!!\nThe result or sample pdf file is not processed by GhostScript.";
        }
        Arrays.sort(imageFiles, new ImageNameComparator());
        Arrays.sort(cmpImageFiles, new ImageNameComparator());
        String differentPagesFail = null;
        for (int i = 0; i < cnt; ++i) {
            if (equalPages != null && equalPages.contains(i)) continue;
            System.out.print("Comparing page " + Integer.toString(i + 1) + " (" + imageFiles[i].getAbsolutePath() + ")...");
            FileInputStream is1 = new FileInputStream(imageFiles[i]);
            FileInputStream is2 = new FileInputStream(cmpImageFiles[i]);
            boolean cmpResult = this.compareStreams(is1, is2);
            is1.close();
            is2.close();
            if (!cmpResult) {
                if (this.compareExec != null && new File(this.compareExec).exists()) {
                    String compareParams = this.compareParams.replace("<image1>", imageFiles[i].getAbsolutePath()).replace("<image2>", cmpImageFiles[i].getAbsolutePath()).replace("<difference>", outPath + differenceImagePrefix + Integer.toString(i + 1) + ".png");
                    p = Runtime.getRuntime().exec(this.compareExec + compareParams);
                    bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while ((line = bre.readLine()) != null) {
                        System.out.println(line);
                    }
                    bre.close();
                    int cmpExitValue = p.waitFor();
                    if (cmpExitValue == 0) {
                        if (differentPagesFail == null) {
                            differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                            differentPagesFail = differentPagesFail + "\nPlease, examine " + outPath + differenceImagePrefix + Integer.toString(i + 1) + ".png for more details.";
                        } else {
                            differentPagesFail = "File " + this.outPdf + " differs.\nPlease, examine difference images for more details.";
                        }
                    } else {
                        differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                    }
                } else {
                    differentPagesFail = differentPages.replace("<filename>", this.outPdf).replace("<pagenumber>", Integer.toString(i + 1));
                    differentPagesFail = differentPagesFail + "\nYou can optionally specify path to ImageMagick compare tool (e.g. -DcompareExec=\"C:/Program Files/ImageMagick-6.5.4-2/compare.exe\") to visualize differences.";
                    break;
                }
                System.out.println(differentPagesFail);
                continue;
            }
            System.out.println("done.");
        }
        if (differentPagesFail != null) {
            return differentPagesFail;
        }
        if (!bUnexpectedNumberOfPages) return null;
        return unexpectedNumberOfPages.replace("<filename>", this.outPdf);
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException, InterruptedException, DocumentException {
        this.init(outPdf, cmpPdf);
        return this.compare(outPath, differenceImagePrefix, ignoredAreas);
    }

    public String compare(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws IOException, InterruptedException, DocumentException {
        return this.compare(outPdf, cmpPdf, outPath, differenceImagePrefix, null);
    }

    public CompareTool setCompareByContentErrorsLimit(int compareByContentMaxErrorCount) {
        this.compareByContentErrorsLimit = compareByContentMaxErrorCount;
        return this;
    }

    public void setGenerateCompareByContentXmlReport(boolean generateCompareByContentXmlReport) {
        this.generateCompareByContentXmlReport = generateCompareByContentXmlReport;
    }

    private String compareByContent(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws DocumentException, InterruptedException, IOException {
        System.out.print("[itext] INFO  Comparing by content..........");
        PdfReader outReader = new PdfReader(this.outPdf);
        this.outPages = new ArrayList<PdfDictionary>();
        this.outPagesRef = new ArrayList<RefKey>();
        this.loadPagesFromReader(outReader, this.outPages, this.outPagesRef);
        PdfReader cmpReader = new PdfReader(this.cmpPdf);
        this.cmpPages = new ArrayList<PdfDictionary>();
        this.cmpPagesRef = new ArrayList<RefKey>();
        this.loadPagesFromReader(cmpReader, this.cmpPages, this.cmpPagesRef);
        if (this.outPages.size() != this.cmpPages.size()) {
            return this.compare(outPath, differenceImagePrefix, ignoredAreas);
        }
        CompareResult compareResult = new CompareResult(this.compareByContentErrorsLimit);
        ArrayList<Integer> equalPages = new ArrayList<Integer>(this.cmpPages.size());
        for (int i = 0; i < this.cmpPages.size(); ++i) {
            ObjectPath currentPath = new ObjectPath(this.cmpPagesRef.get(i), this.outPagesRef.get(i));
            if (!this.compareDictionariesExtended(this.outPages.get(i), this.cmpPages.get(i), currentPath, compareResult)) continue;
            equalPages.add(i);
        }
        PdfObject outStructTree = outReader.getCatalog().get(PdfName.STRUCTTREEROOT);
        PdfObject cmpStructTree = cmpReader.getCatalog().get(PdfName.STRUCTTREEROOT);
        RefKey outStructTreeRef = outStructTree == null ? null : new RefKey((PdfIndirectReference)outStructTree);
        RefKey cmpStructTreeRef = cmpStructTree == null ? null : new RefKey((PdfIndirectReference)cmpStructTree);
        this.compareObjects(outStructTree, cmpStructTree, new ObjectPath(outStructTreeRef, cmpStructTreeRef), compareResult);
        PdfObject outOcProperties = outReader.getCatalog().get(PdfName.OCPROPERTIES);
        PdfObject cmpOcProperties = cmpReader.getCatalog().get(PdfName.OCPROPERTIES);
        RefKey outOcPropertiesRef = outOcProperties == null ? null : new RefKey((PdfIndirectReference)outOcProperties);
        RefKey cmpOcPropertiesRef = cmpOcProperties == null ? null : new RefKey((PdfIndirectReference)cmpOcProperties);
        this.compareObjects(outOcProperties, cmpOcProperties, new ObjectPath(outOcPropertiesRef, cmpOcPropertiesRef), compareResult);
        outReader.close();
        cmpReader.close();
        if (this.generateCompareByContentXmlReport) {
            try {
                compareResult.writeReportToXml(new FileOutputStream(outPath + "/report.xml"));
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        if (equalPages.size() == this.cmpPages.size() && compareResult.isOk()) {
            System.out.println("OK");
            System.out.flush();
            return null;
        }
        System.out.println("Fail");
        System.out.flush();
        String compareByContentReport = "Compare by content report:\n" + compareResult.getReport();
        System.out.println(compareByContentReport);
        System.out.flush();
        String message = this.compare(outPath, differenceImagePrefix, ignoredAreas, equalPages);
        if (message == null || message.length() == 0) {
            return "Compare by content fails. No visual differences";
        }
        return message;
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws DocumentException, InterruptedException, IOException {
        this.init(outPdf, cmpPdf);
        return this.compareByContent(outPath, differenceImagePrefix, ignoredAreas);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws DocumentException, InterruptedException, IOException {
        return this.compareByContent(outPdf, cmpPdf, outPath, differenceImagePrefix, null);
    }

    private void loadPagesFromReader(PdfReader reader, List<PdfDictionary> pages, List<RefKey> pagesRef) {
        PdfObject pagesDict = reader.getCatalog().get(PdfName.PAGES);
        this.addPagesFromDict(pagesDict, pages, pagesRef);
    }

    private void addPagesFromDict(PdfObject dictRef, List<PdfDictionary> pages, List<RefKey> pagesRef) {
        PdfDictionary dict = (PdfDictionary)PdfReader.getPdfObject(dictRef);
        if (dict.isPages()) {
            PdfArray kids = dict.getAsArray(PdfName.KIDS);
            if (kids == null) {
                return;
            }
            for (PdfObject kid : kids) {
                this.addPagesFromDict(kid, pages, pagesRef);
            }
        } else if (dict.isPage()) {
            pages.add(dict);
            pagesRef.add(new RefKey((PdfIndirectReference)((PRIndirectReference)dictRef)));
        }
    }

    private boolean compareObjects(PdfObject outObj, PdfObject cmpObj, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        PdfObject outDirectObj = PdfReader.getPdfObject(outObj);
        PdfObject cmpDirectObj = PdfReader.getPdfObject(cmpObj);
        if (cmpDirectObj == null && outDirectObj == null) {
            return true;
        }
        if (outDirectObj == null) {
            compareResult.addError(currentPath, "Expected object was not found.");
            return false;
        }
        if (cmpDirectObj == null) {
            compareResult.addError(currentPath, "Found object which was not expected to be found.");
            return false;
        }
        if (cmpDirectObj.type() != outDirectObj.type()) {
            compareResult.addError(currentPath, String.format("Types do not match. Expected: %s. Found: %s.", cmpDirectObj.getClass().getSimpleName(), outDirectObj.getClass().getSimpleName()));
            return false;
        }
        if (cmpObj.isIndirect() && outObj.isIndirect()) {
            currentPath = new ObjectPath(new RefKey((PdfIndirectReference)cmpObj), new RefKey((PdfIndirectReference)outObj));
        }
        if (cmpDirectObj.isDictionary()) {
            PdfDictionary cmpDict = (PdfDictionary)cmpDirectObj;
            PdfDictionary outDict = (PdfDictionary)outDirectObj;
            if (cmpDict.isPage()) {
                if (!outDict.isPage()) {
                    if (compareResult != null && currentPath != null) {
                        compareResult.addError(currentPath, String.format("Expected a page. Found not a page.", new Object[0]));
                    }
                    return false;
                }
                RefKey cmpRefKey = new RefKey((PdfIndirectReference)((PRIndirectReference)cmpObj));
                RefKey outRefKey = new RefKey((PdfIndirectReference)((PRIndirectReference)outObj));
                if (this.cmpPagesRef.contains(cmpRefKey) && this.cmpPagesRef.indexOf(cmpRefKey) == this.outPagesRef.indexOf(outRefKey)) {
                    return true;
                }
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, String.format("The dictionaries refer to different pages. Expected page number: %s. Found: %s", this.cmpPagesRef.indexOf(cmpRefKey), this.outPagesRef.indexOf(outRefKey)));
                }
                return false;
            }
            if (!this.compareDictionariesExtended(outDict, cmpDict, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isStream()) {
            if (!this.compareStreamsExtended((PRStream)outDirectObj, (PRStream)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isArray()) {
            if (!this.compareArraysExtended((PdfArray)outDirectObj, (PdfArray)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isName()) {
            if (!this.compareNamesExtended((PdfName)outDirectObj, (PdfName)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isNumber()) {
            if (!this.compareNumbersExtended((PdfNumber)outDirectObj, (PdfNumber)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isString()) {
            if (!this.compareStringsExtended((PdfString)outDirectObj, (PdfString)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (cmpDirectObj.isBoolean()) {
            if (!this.compareBooleansExtended((PdfBoolean)outDirectObj, (PdfBoolean)cmpDirectObj, currentPath, compareResult)) {
                return false;
            }
        } else if (!outDirectObj.isNull() || !cmpDirectObj.isNull()) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    public boolean compareDictionaries(PdfDictionary outDict, PdfDictionary cmpDict) throws IOException {
        return this.compareDictionariesExtended(outDict, cmpDict, null, null);
    }

    private boolean compareDictionariesExtended(PdfDictionary outDict, PdfDictionary cmpDict, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        if (cmpDict != null && outDict == null || outDict != null && cmpDict == null) {
            compareResult.addError(currentPath, "One of the dictionaries is null, the other is not.");
            return false;
        }
        boolean dictsAreSame = true;
        HashSet<PdfName> mergedKeys = new HashSet<PdfName>(cmpDict.getKeys());
        mergedKeys.addAll(outDict.getKeys());
        for (PdfName key : mergedKeys) {
            PdfObject cmpObj;
            if (key.compareTo(PdfName.PARENT) == 0 || key.compareTo(PdfName.P) == 0 || outDict.isStream() && cmpDict.isStream() && (key.equals(PdfName.FILTER) || key.equals(PdfName.LENGTH))) continue;
            if ((key.compareTo(PdfName.BASEFONT) == 0 || key.compareTo(PdfName.FONTNAME) == 0) && (cmpObj = cmpDict.getDirectObject(key)).isName() && cmpObj.toString().indexOf(43) > 0) {
                String outName;
                String cmpName;
                PdfObject outObj = outDict.getDirectObject(key);
                if (!outObj.isName() || outObj.toString().indexOf(43) == -1) {
                    if (compareResult != null && currentPath != null) {
                        compareResult.addError(currentPath, String.format("PdfDictionary %s entry: Expected: %s. Found: %s", key.toString(), cmpObj.toString(), outObj.toString()));
                    }
                    dictsAreSame = false;
                }
                if ((cmpName = cmpObj.toString().substring(cmpObj.toString().indexOf(43))).equals(outName = outObj.toString().substring(outObj.toString().indexOf(43)))) continue;
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, String.format("PdfDictionary %s entry: Expected: %s. Found: %s", key.toString(), cmpObj.toString(), outObj.toString()));
                }
                dictsAreSame = false;
                continue;
            }
            if (currentPath != null) {
                currentPath.pushDictItemToPath(key.toString());
            }
            boolean bl = dictsAreSame = this.compareObjects(outDict.get(key), cmpDict.get(key), currentPath, compareResult) && dictsAreSame;
            if (currentPath != null) {
                currentPath.pop();
            }
            if (dictsAreSame || currentPath != null && compareResult != null && !compareResult.isMessageLimitReached()) continue;
            return false;
        }
        return dictsAreSame;
    }

    public boolean compareStreams(PRStream outStream, PRStream cmpStream) throws IOException {
        return this.compareStreamsExtended(outStream, cmpStream, null, null);
    }

    private boolean compareStreamsExtended(PRStream outStream, PRStream cmpStream, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        boolean decodeStreams = PdfName.FLATEDECODE.equals(outStream.get(PdfName.FILTER));
        byte[] outStreamBytes = PdfReader.getStreamBytesRaw(outStream);
        byte[] cmpStreamBytes = PdfReader.getStreamBytesRaw(cmpStream);
        if (decodeStreams) {
            outStreamBytes = PdfReader.decodeBytes(outStreamBytes, outStream);
            cmpStreamBytes = PdfReader.decodeBytes(cmpStreamBytes, cmpStream);
        }
        if (Arrays.equals(outStreamBytes, cmpStreamBytes)) {
            return this.compareDictionariesExtended(outStream, cmpStream, currentPath, compareResult);
        }
        if (cmpStreamBytes.length != outStreamBytes.length) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, String.format("PRStream. Lengths are different. Expected: %s. Found: %s", cmpStreamBytes.length, outStreamBytes.length));
            }
        } else {
            for (int i = 0; i < cmpStreamBytes.length; ++i) {
                if (cmpStreamBytes[i] == outStreamBytes[i]) continue;
                int l = Math.max(0, i - 10);
                int r = Math.min(cmpStreamBytes.length, i + 10);
                if (compareResult == null || currentPath == null) continue;
                currentPath.pushOffsetToPath(i);
                compareResult.addError(currentPath, String.format("PRStream. The bytes differ at index %s. Expected: %s (%s). Found: %s (%s)", i, new String(new byte[]{cmpStreamBytes[i]}), new String(cmpStreamBytes, l, r - l).replace("\n", "\\n"), new String(new byte[]{outStreamBytes[i]}), new String(outStreamBytes, l, r - l).replace("\n", "\\n")));
                currentPath.pop();
            }
        }
        return false;
    }

    public boolean compareArrays(PdfArray outArray, PdfArray cmpArray) throws IOException {
        return this.compareArraysExtended(outArray, cmpArray, null, null);
    }

    private boolean compareArraysExtended(PdfArray outArray, PdfArray cmpArray, ObjectPath currentPath, CompareResult compareResult) throws IOException {
        if (outArray == null) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, "Found null. Expected PdfArray.");
            }
            return false;
        }
        if (outArray.size() != cmpArray.size()) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, String.format("PdfArrays. Lengths are different. Expected: %s. Found: %s.", cmpArray.size(), outArray.size()));
            }
            return false;
        }
        boolean arraysAreEqual = true;
        for (int i = 0; i < cmpArray.size(); ++i) {
            if (currentPath != null) {
                currentPath.pushArrayItemToPath(i);
            }
            boolean bl = arraysAreEqual = this.compareObjects(outArray.getPdfObject(i), cmpArray.getPdfObject(i), currentPath, compareResult) && arraysAreEqual;
            if (currentPath != null) {
                currentPath.pop();
            }
            if (arraysAreEqual || currentPath != null && compareResult != null && !compareResult.isMessageLimitReached()) continue;
            return false;
        }
        return arraysAreEqual;
    }

    public boolean compareNames(PdfName outName, PdfName cmpName) {
        return cmpName.compareTo(outName) == 0;
    }

    private boolean compareNamesExtended(PdfName outName, PdfName cmpName, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpName.compareTo(outName) == 0) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, String.format("PdfName. Expected: %s. Found: %s", cmpName.toString(), outName.toString()));
        }
        return false;
    }

    public boolean compareNumbers(PdfNumber outNumber, PdfNumber cmpNumber) {
        return cmpNumber.doubleValue() == outNumber.doubleValue();
    }

    private boolean compareNumbersExtended(PdfNumber outNumber, PdfNumber cmpNumber, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpNumber.doubleValue() == outNumber.doubleValue()) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, String.format("PdfNumber. Expected: %s. Found: %s", cmpNumber, outNumber));
        }
        return false;
    }

    public boolean compareStrings(PdfString outString, PdfString cmpString) {
        return Arrays.equals(cmpString.getBytes(), outString.getBytes());
    }

    private boolean compareStringsExtended(PdfString outString, PdfString cmpString, ObjectPath currentPath, CompareResult compareResult) {
        block3: {
            String outStr;
            String cmpStr;
            block2: {
                if (Arrays.equals(cmpString.getBytes(), outString.getBytes())) {
                    return true;
                }
                cmpStr = cmpString.toUnicodeString();
                outStr = outString.toUnicodeString();
                if (cmpStr.length() == outStr.length()) break block2;
                if (compareResult == null || currentPath == null) break block3;
                compareResult.addError(currentPath, String.format("PdfString. Lengths are different. Expected: %s. Found: %s", cmpStr.length(), outStr.length()));
                break block3;
            }
            for (int i = 0; i < cmpStr.length(); ++i) {
                if (cmpStr.charAt(i) == outStr.charAt(i)) continue;
                int l = Math.max(0, i - 10);
                int r = Math.min(cmpStr.length(), i + 10);
                if (compareResult == null || currentPath == null) break;
                currentPath.pushOffsetToPath(i);
                compareResult.addError(currentPath, String.format("PdfString. Characters differ at position %s. Expected: %s (%s). Found: %s (%s).", i, Character.toString(cmpStr.charAt(i)), cmpStr.substring(l, r).replace("\n", "\\n"), Character.toString(outStr.charAt(i)), outStr.substring(l, r).replace("\n", "\\n")));
                currentPath.pop();
                break;
            }
        }
        return false;
    }

    public boolean compareBooleans(PdfBoolean outBoolean, PdfBoolean cmpBoolean) {
        return Arrays.equals(cmpBoolean.getBytes(), outBoolean.getBytes());
    }

    private boolean compareBooleansExtended(PdfBoolean outBoolean, PdfBoolean cmpBoolean, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpBoolean.booleanValue() == outBoolean.booleanValue()) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, String.format("PdfBoolean. Expected: %s. Found: %s.", cmpBoolean.booleanValue(), outBoolean.booleanValue()));
        }
        return false;
    }

    public String compareXmp(String outPdf, String cmpPdf) {
        return this.compareXmp(outPdf, cmpPdf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compareXmp(String outPdf, String cmpPdf, boolean ignoreDateAndProducerProperties) {
        this.init(outPdf, cmpPdf);
        PdfReader cmpReader = null;
        PdfReader outReader = null;
        try {
            cmpReader = new PdfReader(this.cmpPdf);
            outReader = new PdfReader(this.outPdf);
            byte[] cmpBytes = cmpReader.getMetadata();
            byte[] outBytes = outReader.getMetadata();
            if (ignoreDateAndProducerProperties) {
                XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(cmpBytes);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                cmpBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
                xmpMeta = XMPMetaFactory.parseFromBuffer(outBytes);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                outBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
            }
            if (!this.compareXmls(cmpBytes, outBytes)) {
                String string = "The XMP packages different!";
                return string;
            }
        }
        catch (XMPException xmpExc) {
            String string = "XMP parsing failure!";
            return string;
        }
        catch (IOException ioExc) {
            String string = "XMP parsing failure!";
            return string;
        }
        catch (ParserConfigurationException parseExc) {
            String string = "XMP parsing failure!";
            return string;
        }
        catch (SAXException parseExc) {
            String string = "XMP parsing failure!";
            return string;
        }
        finally {
            if (cmpReader != null) {
                cmpReader.close();
            }
            if (outReader != null) {
                outReader.close();
            }
        }
        return null;
    }

    public boolean compareXmls(byte[] xml1, byte[] xml2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new ByteArrayInputStream(xml1));
        doc1.normalizeDocument();
        Document doc2 = db.parse(new ByteArrayInputStream(xml2));
        doc2.normalizeDocument();
        return doc2.isEqualNode(doc1);
    }

    public String compareDocumentInfo(String outPdf, String cmpPdf) throws IOException {
        System.out.print("[itext] INFO  Comparing document info.......");
        String message = null;
        PdfReader outReader = new PdfReader(outPdf);
        PdfReader cmpReader = new PdfReader(cmpPdf);
        String[] cmpInfo = this.convertInfo(cmpReader.getInfo());
        String[] outInfo = this.convertInfo(outReader.getInfo());
        for (int i = 0; i < cmpInfo.length; ++i) {
            if (cmpInfo[i].equals(outInfo[i])) continue;
            message = "Document info fail";
            break;
        }
        outReader.close();
        cmpReader.close();
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    private boolean linksAreSame(PdfAnnotation.PdfImportedLink cmpLink, PdfAnnotation.PdfImportedLink outLink) {
        if (cmpLink.getDestinationPage() != outLink.getDestinationPage()) {
            return false;
        }
        if (!cmpLink.getRect().toString().equals(outLink.getRect().toString())) {
            return false;
        }
        Map<PdfName, PdfObject> cmpParams = cmpLink.getParameters();
        Map<PdfName, PdfObject> outParams = outLink.getParameters();
        if (cmpParams.size() != outParams.size()) {
            return false;
        }
        for (Map.Entry<PdfName, PdfObject> cmpEntry : cmpParams.entrySet()) {
            PdfObject cmpObj = cmpEntry.getValue();
            if (!outParams.containsKey(cmpEntry.getKey())) {
                return false;
            }
            PdfObject outObj = outParams.get(cmpEntry.getKey());
            if (cmpObj.type() != outObj.type()) {
                return false;
            }
            switch (cmpObj.type()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    if (cmpObj.toString().equals(outObj.toString())) break;
                    return false;
                }
            }
        }
        return true;
    }

    public String compareLinks(String outPdf, String cmpPdf) throws IOException {
        System.out.print("[itext] INFO  Comparing link annotations....");
        String message = null;
        PdfReader outReader = new PdfReader(outPdf);
        PdfReader cmpReader = new PdfReader(cmpPdf);
        block0: for (int i = 0; i < outReader.getNumberOfPages() && i < cmpReader.getNumberOfPages(); ++i) {
            ArrayList<PdfAnnotation.PdfImportedLink> outLinks = outReader.getLinks(i + 1);
            ArrayList<PdfAnnotation.PdfImportedLink> cmpLinks = cmpReader.getLinks(i + 1);
            if (cmpLinks.size() != outLinks.size()) {
                message = String.format("Different number of links on page %d.", i + 1);
                break;
            }
            for (int j = 0; j < cmpLinks.size(); ++j) {
                if (this.linksAreSame((PdfAnnotation.PdfImportedLink)cmpLinks.get(j), (PdfAnnotation.PdfImportedLink)outLinks.get(j))) continue;
                message = String.format("Different links on page %d.\n%s\n%s", i + 1, ((PdfAnnotation.PdfImportedLink)cmpLinks.get(j)).toString(), ((PdfAnnotation.PdfImportedLink)outLinks.get(j)).toString());
                continue block0;
            }
        }
        outReader.close();
        cmpReader.close();
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    public String compareTagStructures(String outPdf, String cmpPdf) throws IOException, ParserConfigurationException, SAXException {
        System.out.print("[itext] INFO  Comparing tag structures......");
        String outXml = outPdf.replace(".pdf", ".xml");
        String cmpXml = outPdf.replace(".pdf", ".cmp.xml");
        String message = null;
        PdfReader reader = new PdfReader(outPdf);
        FileOutputStream xmlOut1 = new FileOutputStream(outXml);
        new CmpTaggedPdfReaderTool().convertToXml(reader, xmlOut1);
        reader.close();
        reader = new PdfReader(cmpPdf);
        FileOutputStream xmlOut2 = new FileOutputStream(cmpXml);
        new CmpTaggedPdfReaderTool().convertToXml(reader, xmlOut2);
        reader.close();
        if (!this.compareXmls(outXml, cmpXml)) {
            message = "The tag structures are different.";
        }
        xmlOut1.close();
        xmlOut2.close();
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    private String[] convertInfo(HashMap<String, String> info) {
        String[] convertedInfo = new String[]{"", "", "", ""};
        for (Map.Entry<String, String> entry : info.entrySet()) {
            if ("title".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[0] = entry.getValue();
                continue;
            }
            if ("author".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[1] = entry.getValue();
                continue;
            }
            if ("subject".equalsIgnoreCase(entry.getKey())) {
                convertedInfo[2] = entry.getValue();
                continue;
            }
            if (!"keywords".equalsIgnoreCase(entry.getKey())) continue;
            convertedInfo[3] = entry.getValue();
        }
        return convertedInfo;
    }

    public boolean compareXmls(String xml1, String xml2) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc1 = db.parse(new File(xml1));
        doc1.normalizeDocument();
        Document doc2 = db.parse(new File(xml2));
        doc2.normalizeDocument();
        return doc2.isEqualNode(doc1);
    }

    private void init(String outPdf, String cmpPdf) {
        this.outPdf = outPdf;
        this.cmpPdf = cmpPdf;
        this.outPdfName = new File(outPdf).getName();
        this.cmpPdfName = new File(cmpPdf).getName();
        this.outImage = this.outPdfName + "-%03d.png";
        this.cmpImage = this.cmpPdfName.startsWith("cmp_") ? this.cmpPdfName + "-%03d.png" : "cmp_" + this.cmpPdfName + "-%03d.png";
    }

    private boolean compareStreams(InputStream is1, InputStream is2) throws IOException {
        int len1;
        byte[] buffer1 = new byte[65536];
        byte[] buffer2 = new byte[65536];
        do {
            int len2;
            if ((len1 = is1.read(buffer1)) != (len2 = is2.read(buffer2))) {
                return false;
            }
            if (Arrays.equals(buffer1, buffer2)) continue;
            return false;
        } while (len1 != -1);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CmpMarkedContentRenderFilter
    implements RenderListener {
        Map<Integer, TextExtractionStrategy> tagsByMcid = new HashMap<Integer, TextExtractionStrategy>();

        CmpMarkedContentRenderFilter() {
        }

        public Map<Integer, String> getParsedTagContent() {
            HashMap<Integer, String> content = new HashMap<Integer, String>();
            for (int id : this.tagsByMcid.keySet()) {
                content.put(id, this.tagsByMcid.get(id).getResultantText());
            }
            return content;
        }

        @Override
        public void beginTextBlock() {
            for (int id : this.tagsByMcid.keySet()) {
                this.tagsByMcid.get(id).beginTextBlock();
            }
        }

        @Override
        public void renderText(TextRenderInfo renderInfo) {
            Integer mcid = renderInfo.getMcid();
            if (mcid != null && this.tagsByMcid.containsKey(mcid)) {
                this.tagsByMcid.get(mcid).renderText(renderInfo);
            } else if (mcid != null) {
                this.tagsByMcid.put(mcid, new SimpleTextExtractionStrategy());
                this.tagsByMcid.get(mcid).renderText(renderInfo);
            }
        }

        @Override
        public void endTextBlock() {
            for (int id : this.tagsByMcid.keySet()) {
                this.tagsByMcid.get(id).endTextBlock();
            }
        }

        @Override
        public void renderImage(ImageRenderInfo renderInfo) {
        }
    }

    class CmpTaggedPdfReaderTool
    extends TaggedPdfReaderTool {
        Map<PdfDictionary, Map<Integer, String>> parsedTags = new HashMap<PdfDictionary, Map<Integer, String>>();

        CmpTaggedPdfReaderTool() {
        }

        public void parseTag(String tag, PdfObject object, PdfDictionary page) throws IOException {
            if (object instanceof PdfNumber) {
                if (!this.parsedTags.containsKey(page)) {
                    CmpMarkedContentRenderFilter listener = new CmpMarkedContentRenderFilter();
                    PdfContentStreamProcessor processor = new PdfContentStreamProcessor(listener);
                    processor.processContent(PdfReader.getPageContent(page), page.getAsDict(PdfName.RESOURCES));
                    this.parsedTags.put(page, listener.getParsedTagContent());
                }
                String tagContent = "";
                if (this.parsedTags.get(page).containsKey(((PdfNumber)object).intValue())) {
                    tagContent = this.parsedTags.get(page).get(((PdfNumber)object).intValue());
                }
                this.out.print(XMLUtil.escapeXML(tagContent, true));
            } else {
                super.parseTag(tag, object, page);
            }
        }

        public void inspectChildDictionary(PdfDictionary k) throws IOException {
            this.inspectChildDictionary(k, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImageNameComparator
    implements Comparator<File> {
        ImageNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String f1Name = f1.getAbsolutePath();
            String f2Name = f2.getAbsolutePath();
            return f1Name.compareTo(f2Name);
        }
    }

    class CmpPngFileFilter
    implements FileFilter {
        CmpPngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && b2 && ap.contains(CompareTool.this.cmpPdfName);
        }
    }

    class PngFileFilter
    implements FileFilter {
        PngFileFilter() {
        }

        public boolean accept(File pathname) {
            String ap = pathname.getAbsolutePath();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && !b2 && ap.contains(CompareTool.this.outPdfName);
        }
    }

    protected class CompareResult {
        protected HashMap<ObjectPath, String> differences = new HashMap();
        protected int messageLimit = 1;

        public CompareResult(int messageLimit) {
            this.messageLimit = messageLimit;
        }

        public boolean isOk() {
            return this.differences.size() == 0;
        }

        public int getErrorCount() {
            return this.differences.size();
        }

        protected boolean isMessageLimitReached() {
            return this.differences.size() >= this.messageLimit;
        }

        public String getReport() {
            StringBuilder sb = new StringBuilder();
            boolean firstEntry = true;
            for (Map.Entry<ObjectPath, String> entry : this.differences.entrySet()) {
                if (!firstEntry) {
                    sb.append("-----------------------------").append("\n");
                }
                ObjectPath diffPath = entry.getKey();
                sb.append(entry.getValue()).append("\n").append(diffPath.toString()).append("\n");
                firstEntry = false;
            }
            return sb.toString();
        }

        protected void addError(ObjectPath path, String message) {
            if (this.differences.size() < this.messageLimit) {
                this.differences.put((ObjectPath)path.clone(), message);
            }
        }

        public void writeReportToXml(OutputStream stream) throws ParserConfigurationException, TransformerException {
            Document xmlReport = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = xmlReport.createElement("report");
            Element errors = xmlReport.createElement("errors");
            errors.setAttribute("count", String.valueOf(this.differences.size()));
            root.appendChild(errors);
            for (Map.Entry<ObjectPath, String> entry : this.differences.entrySet()) {
                Element errorNode = xmlReport.createElement("error");
                Element message = xmlReport.createElement("message");
                message.appendChild(xmlReport.createTextNode(entry.getValue()));
                Node path = entry.getKey().toXmlNode(xmlReport);
                errorNode.appendChild(message);
                errorNode.appendChild(path);
                errors.appendChild(errorNode);
            }
            xmlReport.appendChild(root);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(xmlReport);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPath {
        protected RefKey baseCmpObject;
        protected RefKey baseOutObject;
        protected Stack<PathItem> path = new Stack();

        public ObjectPath() {
        }

        protected ObjectPath(RefKey baseCmpObject, RefKey baseOutObject) {
            this.baseCmpObject = baseCmpObject;
            this.baseOutObject = baseOutObject;
        }

        private ObjectPath(RefKey baseCmpObject, RefKey baseOutObject, Stack<PathItem> path) {
            this.baseCmpObject = baseCmpObject;
            this.baseOutObject = baseOutObject;
            this.path = path;
        }

        public void pushArrayItemToPath(int index) {
            this.path.add(new ArrayPathItem(index));
        }

        public void pushDictItemToPath(String key) {
            this.path.add(new DictPathItem(key));
        }

        public void pushOffsetToPath(int offset) {
            this.path.add(new OffsetPathItem(offset));
        }

        public void pop() {
            this.path.pop();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Base cmp object: %s obj. Base out object: %s obj", this.baseCmpObject, this.baseOutObject));
            for (PathItem pathItem : this.path) {
                sb.append("\n");
                sb.append(pathItem.toString());
            }
            return sb.toString();
        }

        public int hashCode() {
            int hashCode = this.baseCmpObject.hashCode() * 31 + this.baseOutObject.hashCode();
            for (PathItem pathItem : this.path) {
                hashCode *= 31;
                hashCode += pathItem.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof ObjectPath && this.baseCmpObject.equals(((ObjectPath)obj).baseCmpObject) && this.baseOutObject.equals(((ObjectPath)obj).baseOutObject) && this.path.equals(((ObjectPath)obj).path);
        }

        protected Object clone() {
            return new ObjectPath(this.baseCmpObject, this.baseOutObject, (Stack)this.path.clone());
        }

        public Node toXmlNode(Document document) {
            Element element = document.createElement("path");
            Element baseNode = document.createElement("base");
            baseNode.setAttribute("cmp", this.baseCmpObject.toString() + " obj");
            baseNode.setAttribute("out", this.baseOutObject.toString() + " obj");
            element.appendChild(baseNode);
            for (PathItem pathItem : this.path) {
                element.appendChild(pathItem.toXmlNode(document));
            }
            return element;
        }

        private class OffsetPathItem
        extends PathItem {
            int offset;

            public OffsetPathItem(int offset) {
                this.offset = offset;
            }

            public String toString() {
                return "Offset: " + String.valueOf(this.offset);
            }

            public int hashCode() {
                return this.offset;
            }

            public boolean equals(Object obj) {
                return obj instanceof OffsetPathItem && this.offset == ((OffsetPathItem)obj).offset;
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("offset");
                element.appendChild(document.createTextNode(String.valueOf(this.offset)));
                return element;
            }
        }

        private class ArrayPathItem
        extends PathItem {
            int index;

            public ArrayPathItem(int index) {
                this.index = index;
            }

            public String toString() {
                return "Array index: " + String.valueOf(this.index);
            }

            public int hashCode() {
                return this.index;
            }

            public boolean equals(Object obj) {
                return obj instanceof ArrayPathItem && this.index == ((ArrayPathItem)obj).index;
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("arrayIndex");
                element.appendChild(document.createTextNode(String.valueOf(this.index)));
                return element;
            }
        }

        private class DictPathItem
        extends PathItem {
            String key;

            public DictPathItem(String key) {
                this.key = key;
            }

            public String toString() {
                return "Dict key: " + this.key;
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof DictPathItem && this.key.equals(((DictPathItem)obj).key);
            }

            protected Node toXmlNode(Document document) {
                Element element = document.createElement("dictKey");
                element.appendChild(document.createTextNode(this.key));
                return element;
            }
        }

        private abstract class PathItem {
            private PathItem() {
            }

            protected abstract Node toXmlNode(Document var1);
        }
    }
}

