/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.legacy.Collector;
import org.nuiton.topia.persistence.util.DiffState;
import org.nuiton.topia.persistence.util.TopiaEntityIdsMap;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class TopiaEntityHelper {
    private static final Log log = LogFactory.getLog(TopiaEntityHelper.class);
    public static final String ASSOCIATION_PATTERN = "%1$s[@topiaId=\"%2$s\"]";

    public static void bindTechnical(TopiaEntity from, TopiaEntity dst) {
        if (from == null) {
            dst.setTopiaId(null);
            dst.setTopiaVersion(0L);
            dst.setTopiaCreateDate(null);
        } else {
            dst.setTopiaId(from.getTopiaId());
            dst.setTopiaVersion(from.getTopiaVersion());
            dst.setTopiaCreateDate(from.getTopiaCreateDate());
        }
    }

    public static <E extends TopiaEntity> E getExistingEntity(TopiaDao<E> dao, String topiaId) throws TopiaException, IllegalArgumentException {
        E entity = dao.forTopiaIdEquals(topiaId).findUniqueOrNull();
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)("could not find entity with topiaId " + topiaId));
        return entity;
    }

    public static <E extends TopiaEntity> E getEntityByTopiaId(Collection<E> entities, String topiaId) {
        if (entities != null) {
            for (TopiaEntity e : entities) {
                if (!topiaId.equals(e.getTopiaId())) continue;
                return (E)e;
            }
        }
        return null;
    }

    public static <O> O getEntityByIndex(Collection<O> entities, int index) throws IndexOutOfBoundsException {
        if (entities != null) {
            return (O)Iterables.get(entities, (int)index);
        }
        return null;
    }

    public static <E extends TopiaEntity> void checkNotNullAndExistingEntity(String paramName, E bean) throws IllegalStateException, NullPointerException {
        Preconditions.checkNotNull(bean, (Object)(paramName + " can not be null"));
        Preconditions.checkState((bean.getTopiaId() != null ? 1 : 0) != 0, (Object)("can not create " + bean.getClass() + " here..."));
    }

    public static <E extends TopiaEntity> void checkNotNullAndNoneExistingEntity(String paramName, E bean) throws NullPointerException, IllegalStateException {
        Preconditions.checkNotNull(bean, (Object)(paramName + " can not be null"));
        Preconditions.checkState((bean.getTopiaId() == null ? 1 : 0) != 0, (Object)("can not update " + bean.getClass() + " here..."));
    }

    public static Comparator<TopiaEntity> getTopiaIdComparator() {
        return new Comparator<TopiaEntity>(){

            @Override
            public int compare(TopiaEntity o1, TopiaEntity o2) {
                if (o1.getTopiaId() == null) {
                    return -1;
                }
                if (o2.getTopiaId() == null) {
                    return 1;
                }
                return o1.getTopiaId().compareTo(o2.getTopiaId());
            }
        };
    }

    public static List<TopiaEntity> filter(Collection<TopiaEntity> entities, Class<? extends TopiaEntity> filterClass) {
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : entities) {
            if (!filterClass.isAssignableFrom(e.getClass())) continue;
            result.add(e);
        }
        return result;
    }

    public static Class<? extends TopiaEntity> getContractClass(TopiaEntityEnum[] contracts, Class<? extends TopiaEntity> klass) {
        if (contracts == null || contracts.length == 0) {
            return null;
        }
        Set<Class<? extends TopiaEntity>> klassInterfaces = TopiaEntityHelper.getInterfaces(klass, new HashSet<Class<? extends TopiaEntity>>());
        for (TopiaEntityEnum contract : contracts) {
            Class<? extends TopiaEntity> contractClass = contract.getContract();
            if (!klassInterfaces.contains(contractClass)) continue;
            return contractClass;
        }
        return null;
    }

    public static Set<Class<? extends TopiaEntity>> getContractClasses(TopiaEntityEnum[] contracts, Iterable<Class<? extends TopiaEntity>> klasses) {
        HashSet<Class<? extends TopiaEntity>> result = new HashSet<Class<? extends TopiaEntity>>();
        if (contracts == null || contracts.length == 0) {
            return result;
        }
        for (Class<? extends TopiaEntity> klass : klasses) {
            Class<? extends TopiaEntity> c = TopiaEntityHelper.getContractClass(contracts, klass);
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    public static TopiaEntityEnum getEntityEnum(Class<? extends TopiaEntity> klass, TopiaEntityEnum ... contracts) {
        if (contracts == null || contracts.length == 0) {
            return null;
        }
        Class<? extends TopiaEntity> contractClass = TopiaEntityHelper.getContractClass(contracts, klass);
        if (contractClass != null) {
            for (TopiaEntityEnum t : contracts) {
                if (!t.accept(contractClass)) continue;
                return t;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<? extends TopiaEntity>> retainContracts(TopiaEntityEnum[] contracts, Set<Class<? extends TopiaEntity>> classes) {
        HashMap<Class<? extends TopiaEntity>, Class<? extends TopiaEntity>> dico = new HashMap<Class<? extends TopiaEntity>, Class<? extends TopiaEntity>>();
        try {
            HashSet<Class<? extends TopiaEntity>> result = new HashSet<Class<? extends TopiaEntity>>();
            for (Class<? extends TopiaEntity> c : classes) {
                Class<? extends TopiaEntity> contractClass = (Class<? extends TopiaEntity>)dico.get(c);
                if (contractClass == null) {
                    for (TopiaEntityEnum contract : contracts) {
                        if (!contract.accept(c)) continue;
                        contractClass = contract.getContract();
                        dico.put(c, contractClass);
                    }
                }
                if (contractClass == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("detected type : " + contractClass));
                }
                result.add(contractClass);
            }
            HashSet<Class<? extends TopiaEntity>> hashSet = result;
            return hashSet;
        }
        finally {
            dico.clear();
        }
    }

    public static Class<? extends TopiaEntity>[] getContracts(TopiaEntityEnum[] contracts) {
        Class[] result = new Class[contracts.length];
        int index = 0;
        for (TopiaEntityEnum e : contracts) {
            result[index++] = e.getContract();
        }
        return result;
    }

    public static Set<Class<? extends TopiaEntity>> detectTypes(TopiaEntityEnum[] contracts, TopiaEntity ... entities) throws TopiaException {
        Collector<Set<Class<? extends TopiaEntity>>> collector = new Collector<Set<Class<? extends TopiaEntity>>>(contracts){
            protected Set<Class<? extends TopiaEntity>> detectedTypes = new HashSet<Class<? extends TopiaEntity>>();

            @Override
            protected boolean onStarting(TopiaEntity e) {
                super.onStarting(e);
                Class<?> entityClass = e.getClass();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(entityClass + " : " + e.getTopiaId()));
                }
                this.detectedTypes.add(entityClass);
                return true;
            }

            @Override
            protected Set<Class<? extends TopiaEntity>> afterAll(Collector.CollectorVisitor visitor, TopiaEntity ... entities) {
                Set<Class<? extends TopiaEntity>> result = TopiaEntityHelper.retainContracts(this.contracts, this.detectedTypes);
                return result;
            }
        };
        Set result = (Set)collector.detect(entities);
        return result;
    }

    public static Map<Class<? extends TopiaEntity>, List<TopiaEntity>> detectEntities(TopiaEntityEnum[] contracts, final Set<Class<? extends TopiaEntity>> types, TopiaEntity ... entities) throws TopiaException {
        Collector<Map<Class<? extends TopiaEntity>, List<TopiaEntity>>> collector = new Collector<Map<Class<? extends TopiaEntity>, List<TopiaEntity>>>(contracts){
            protected Map<Class<? extends TopiaEntity>, List<TopiaEntity>> detectedRefs;
            {
                super(x0);
                this.detectedRefs = new HashMap<Class<? extends TopiaEntity>, List<TopiaEntity>>();
            }

            @Override
            protected void onStarted(TopiaEntity e, boolean enter) {
                List<TopiaEntity> refs;
                super.onStarted(e, enter);
                Class<TopiaEntity> entityClass = this.getContractClass(e);
                if (entityClass == null || !types.contains(entityClass)) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(entityClass + " : " + e.getTopiaId()));
                }
                if ((refs = this.detectedRefs.get(entityClass)) == null) {
                    refs = new ArrayList<TopiaEntity>();
                    this.detectedRefs.put(entityClass, refs);
                }
                refs.add(e);
            }

            @Override
            protected Map<Class<? extends TopiaEntity>, List<TopiaEntity>> afterAll(Collector.CollectorVisitor visitor, TopiaEntity ... entities) {
                return this.detectedRefs;
            }
        };
        Map result = (Map)collector.detect(entities);
        return result;
    }

    public static TopiaEntityIdsMap detectEntityIds(TopiaEntityEnum[] contracts, final Set<Class<? extends TopiaEntity>> types, TopiaEntity ... entities) throws TopiaException {
        Collector<TopiaEntityIdsMap> collector = new Collector<TopiaEntityIdsMap>(contracts){
            protected TopiaEntityIdsMap detectedRefs;
            {
                super(x0);
                this.detectedRefs = new TopiaEntityIdsMap();
            }

            @Override
            protected void onStarted(TopiaEntity e, boolean enter) {
                ArrayList<String> refs;
                super.onStarted(e, enter);
                Class<TopiaEntity> entityClass = this.getContractClass(e);
                if (entityClass == null || !types.contains(entityClass)) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(entityClass + " : " + e.getTopiaId()));
                }
                if ((refs = (ArrayList<String>)this.detectedRefs.get(entityClass)) == null) {
                    refs = new ArrayList<String>();
                    this.detectedRefs.put(entityClass, refs);
                }
                refs.add(e.getTopiaId());
            }

            @Override
            protected TopiaEntityIdsMap afterAll(Collector.CollectorVisitor visitor, TopiaEntity ... entities) {
                return this.detectedRefs;
            }
        };
        TopiaEntityIdsMap result = (TopiaEntityIdsMap)collector.detect(entities);
        return result;
    }

    public static SortedMap<TopiaEntity, List<TopiaEntityRef>> detectReferences(TopiaEntityEnum[] contracts, String[] expressions, TopiaEntity entities) throws TopiaException {
        return TopiaEntityHelper.detectReferences(contracts, expressions, Collections.singleton(entities));
    }

    public static SortedMap<TopiaEntity, List<TopiaEntityRef>> detectReferences(TopiaEntityEnum[] contracts, final String[] expressions, Collection<? extends TopiaEntity> entities) throws TopiaException {
        Collector<SortedMap<TopiaEntity, List<TopiaEntityRef>>> collector = new Collector<SortedMap<TopiaEntity, List<TopiaEntityRef>>>(contracts){
            List<String> ids;
            SortedMap<TopiaEntity, List<TopiaEntityRef>> refs;
            Deque<TopiaEntity> path;
            StringBuilder accessorExpression;
            TopiaEntity root;
            {
                super(x0);
                this.ids = Arrays.asList(expressions);
                this.refs = new TreeMap<TopiaEntity, List<TopiaEntityRef>>(TopiaEntityHelper.getTopiaIdComparator());
                this.path = new LinkedList<TopiaEntity>();
                this.accessorExpression = new StringBuilder();
            }

            @Override
            protected void before(Collector.CollectorVisitor visitor, TopiaEntity entity) {
                super.before(visitor, entity);
                visitor.clear();
            }

            @Override
            protected boolean onStarting(TopiaEntity e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e.getTopiaId());
                }
                if (this.root == null) {
                    this.root = e;
                    this.addPath(e, "$root", -1);
                    if (this.accept(e)) {
                        this.registerEntity(e);
                    }
                }
                return true;
            }

            @Override
            protected void onEnded(TopiaEntity e, boolean enter) {
                super.onEnded(e, enter);
                if (this.root == e) {
                    this.root = null;
                    this.removePath();
                }
            }

            @Override
            protected boolean onVisiting(TopiaEntity e, String name, Class<?> type, Object value) {
                TopiaEntity e1 = this.getTopiaValue(value);
                if (e1 != null) {
                    block7: {
                        this.addPath(e1, name, -1);
                        if (this.accept(e1)) {
                            this.registerEntity(e1);
                        }
                        if (this.visitor.getAlreadyExplored().contains(e1)) {
                            boolean contains = this.visitor.getStack().contains(e1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("already enter " + e1.getTopiaId() + ", can reenter ? " + !contains));
                            }
                            if (!contains) {
                                try {
                                    e1.accept(this.visitor);
                                }
                                catch (TopiaException ex) {
                                    if (!log.isErrorEnabled()) break block7;
                                    log.error((Object)"Error on depth exploration", (Throwable)ex);
                                }
                            }
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            protected void onVisited(TopiaEntity e, String name, Class<?> type, Object value, boolean enter) {
                super.onVisited(e, name, type, value, enter);
                if (enter) {
                    this.removePath();
                }
            }

            @Override
            protected boolean onVisiting(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, int index, Object value) {
                TopiaEntity e1 = this.getTopiaValue(value);
                if (e1 != null) {
                    block7: {
                        this.addPath(e1, name, index);
                        if (this.accept(e1)) {
                            this.registerEntity(e1);
                        }
                        if (this.visitor.getAlreadyExplored().contains(e1)) {
                            boolean contains = this.visitor.getStack().contains(e1);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("already enter " + e1.getTopiaId() + ", can reenter ? " + !contains));
                            }
                            if (!contains) {
                                try {
                                    e1.accept(this.visitor);
                                }
                                catch (TopiaException ex) {
                                    if (!log.isErrorEnabled()) break block7;
                                    log.error((Object)"Error on depth exploration", (Throwable)ex);
                                }
                            }
                        }
                    }
                    return true;
                }
                return false;
            }

            @Override
            protected void onVisited(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, int index, Object value, boolean enter) {
                super.onVisited(e, name, collectionType, type, index, value, enter);
                if (enter) {
                    this.removePath();
                }
            }

            @Override
            protected SortedMap<TopiaEntity, List<TopiaEntityRef>> afterAll(Collector.CollectorVisitor visitor, TopiaEntity ... entities) {
                return this.refs;
            }

            @Override
            protected void clear() {
                super.clear();
                this.ids = null;
                this.refs = null;
                this.path.clear();
                this.path = null;
                this.accessorExpression = null;
                this.root = null;
            }

            boolean accept(TopiaEntity e) {
                return this.ids.contains(e.getTopiaId());
            }

            void addPath(TopiaEntity e, String name, int index) {
                this.path.add(e);
                if (this.accessorExpression.length() > 0) {
                    this.accessorExpression.append("/");
                }
                this.accessorExpression.append(name);
                if (index > -1) {
                    String association = String.format(TopiaEntityHelper.ASSOCIATION_PATTERN, "", e.getTopiaId());
                    this.accessorExpression.append(association);
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("add to stack : " + e.getTopiaId() + ", new size : " + this.path.size() + ", path : " + this.accessorExpression.toString()));
                }
            }

            void removePath() {
                TopiaEntity e = this.path.removeLast();
                if (this.path.isEmpty()) {
                    this.accessorExpression.setLength(0);
                } else {
                    int index = this.accessorExpression.lastIndexOf("/");
                    if (index > -1) {
                        this.accessorExpression.delete(index, this.accessorExpression.length());
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("remove from stack : " + e.getTopiaId() + ", new size : " + this.path.size() + ", path : " + this.accessorExpression.toString()));
                }
            }

            void registerEntity(TopiaEntity e) {
                ArrayList<TopiaEntityRef> list = (ArrayList<TopiaEntityRef>)this.refs.get(e);
                if (list == null) {
                    list = new ArrayList<TopiaEntityRef>();
                    this.refs.put(e, list);
                }
                String expression = this.accessorExpression.toString();
                list.add(new TopiaEntityRef(this.root, e, expression, this.path.toArray(new TopiaEntity[this.path.size()])));
                if (log.isDebugEnabled()) {
                    log.debug((Object)(expression + " (" + e.getTopiaId() + ") - " + list.size() + " , root:" + this.root.getTopiaId()));
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)(e.getTopiaId() + " : new size " + list.size() + ", path : " + expression));
                }
            }
        };
        SortedMap result = (SortedMap)collector.detect(entities.toArray(new TopiaEntity[entities.size()]));
        return result;
    }

    public static List<String> getTopiaIdList(Collection<? extends TopiaEntity> entities) {
        ArrayList<String> ids = new ArrayList<String>(entities.size());
        for (TopiaEntity topiaEntity : entities) {
            ids.add(topiaEntity.getTopiaId());
        }
        return ids;
    }

    public static String[] getTopiaIdArray(Collection<? extends TopiaEntity> entities) {
        String[] ids = new String[entities.size()];
        int i = 0;
        for (TopiaEntity topiaEntity : entities) {
            ids[i++] = topiaEntity.getTopiaId();
        }
        return ids;
    }

    public static <E extends TopiaEntity> List<E> retainEntities(Collection<E> list, List<String> topiaIds) {
        ArrayList<TopiaEntity> r = new ArrayList<TopiaEntity>(list == null ? 0 : list.size());
        if (list != null) {
            for (TopiaEntity e : list) {
                if (!topiaIds.contains(e.getTopiaId())) continue;
                r.add(e);
            }
        }
        return r;
    }

    public static <E extends TopiaEntity> DiffState.DiffStateMap buildDifferentiel(List<E> referentiel, List<E> locale) {
        DiffState.DiffStateMap result = DiffState.newMap();
        List<String> referentielIdList = TopiaEntityHelper.getTopiaIdList(referentiel);
        List<String> localeIdList = TopiaEntityHelper.getTopiaIdList(locale);
        for (TopiaEntity aReferentiel : referentiel) {
            TopiaEntity referentielEntity = aReferentiel;
            String refId = referentielEntity.getTopiaId();
            if (localeIdList.contains(refId)) {
                TopiaEntity localeEntity = (TopiaEntity)Iterables.find(locale, TopiaEntities.entityHasId(refId));
                boolean wasModified = referentielEntity.getTopiaVersion() > localeEntity.getTopiaVersion();
                if (!wasModified) continue;
                ((List)result.get((Object)DiffState.MODIFIED)).add(refId);
                continue;
            }
            ((List)result.get((Object)DiffState.NEW)).add(refId);
        }
        localeIdList.removeAll(referentielIdList);
        if (!localeIdList.isEmpty()) {
            List toRemove = (List)result.get((Object)DiffState.REMOVED);
            for (String id : localeIdList) {
                toRemove.add(id);
            }
        }
        referentielIdList.clear();
        localeIdList.clear();
        return result;
    }

    public static Set<Class<? extends TopiaEntity>> getInterfaces(Class<? extends TopiaEntity> klass, Set<Class<? extends TopiaEntity>> klassInterfaces) {
        if (klassInterfaces.contains(klass)) {
            return klassInterfaces;
        }
        if (klass.isInterface()) {
            TopiaEntityHelper.addInterface(klassInterfaces, klass);
            return klassInterfaces;
        }
        Class<?>[] interfaces = klass.getInterfaces();
        if (interfaces.length > 0) {
            for (Class<?> interfac : interfaces) {
                TopiaEntityHelper.getInterfaces(interfac, klassInterfaces);
            }
        }
        if (klass.getSuperclass() != null && TopiaEntity.class.isAssignableFrom(klass.getSuperclass())) {
            TopiaEntityHelper.getInterfaces(klass.getSuperclass(), klassInterfaces);
        }
        return klassInterfaces;
    }

    protected static void addInterface(Set<Class<? extends TopiaEntity>> interfaces, Class<? extends TopiaEntity> klass) {
        Iterator<Class<? extends TopiaEntity>> iterator = interfaces.iterator();
        while (iterator.hasNext()) {
            Class<? extends TopiaEntity> next = iterator.next();
            if (next.isAssignableFrom(klass)) {
                iterator.remove();
                continue;
            }
            if (!klass.isAssignableFrom(next)) continue;
            return;
        }
        interfaces.add(klass);
    }

    public static <E extends TopiaEntity> List<E> getEntities(TopiaPersistenceContext srcCtxt, List<E> entityList, boolean canBeNull) throws TopiaException {
        ArrayList srcList = new ArrayList(entityList.size());
        for (TopiaEntity e : entityList) {
            Object e2 = srcCtxt.findByTopiaId(e.getTopiaId());
            if (e2 == null && !canBeNull) continue;
            srcList.add(e2);
        }
        return srcList;
    }

    public static TopiaEntity[] getEntities(TopiaPersistenceContext srcCtxt, String ... entityList) throws TopiaException {
        TopiaEntity[] srcList = new TopiaEntity[entityList.length];
        int index = 0;
        for (String id : entityList) {
            Object e2 = srcCtxt.findByTopiaId(id);
            srcList[index++] = e2;
        }
        return srcList;
    }

    public static List<? extends TopiaEntity> getEntitiesList(TopiaPersistenceContext srcCtxt, String ... entityList) throws TopiaException {
        ArrayList srcList = new ArrayList(entityList.length);
        for (String id : entityList) {
            Object e2 = srcCtxt.findByTopiaId(id);
            srcList.add(e2);
        }
        return srcList;
    }

    public static void checkNotNull(String methodName, String parameterName, Object value) {
        Preconditions.checkNotNull((Object)value, (Object)String.format("The method '%1$s' requires a non null parameter '%2$s'.", methodName, parameterName));
    }

    public static void checkParameters(Class<?>[] paramsType, Object ... params) {
        TopiaEntityHelper.checkSize(paramsType.length, params);
        int j = paramsType.length;
        for (int i = 0; i < j; ++i) {
            TopiaEntityHelper.checkType(paramsType, i, params);
        }
    }

    public static void checkSize(int size, Object[] params) {
        Preconditions.checkArgument((params.length == size ? 1 : 0) != 0, (Object)String.format("Invalid parameters size. Expected:%d but was:%d", size, params.length));
    }

    public static void checkType(Class<?>[] paramsType, int index, Object[] params) {
        Class<?> requiredType = paramsType[index];
        Object value = params[index];
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)String.format("The parameter at index %d must not be null", index));
        Class<?> foundType = value.getClass();
        Preconditions.checkArgument((boolean)requiredType.isAssignableFrom(foundType), (Object)String.format("The parameter at index %d is not the expected type. Expected:%s but was:%s", index, requiredType, foundType));
    }

    public static String getNormalizedAssociationTableName(String table1, String table2) {
        String result = table1.compareTo(table2) > 0 ? table2 + "_" + table1 : table1 + "_" + table2;
        return result;
    }
}

