/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class HostNameTrustManager
implements X509TrustManager {
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private final boolean allowWildcards;
    private final Set<String> acceptableHostNames;

    public HostNameTrustManager(boolean allowWildcards, String ... acceptableHostNames) {
        this(allowWildcards, StaticUtils.toList(acceptableHostNames));
    }

    public HostNameTrustManager(boolean allowWildcards, Collection<String> acceptableHostNames) {
        Validator.ensureNotNull(acceptableHostNames);
        Validator.ensureFalse(acceptableHostNames.isEmpty(), "The set of acceptable host names must not be empty.");
        this.allowWildcards = allowWildcards;
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>(acceptableHostNames.size());
        for (String s : acceptableHostNames) {
            nameSet.add(StaticUtils.toLowerCase(s));
        }
        this.acceptableHostNames = Collections.unmodifiableSet(nameSet);
    }

    public boolean allowWildcards() {
        return this.allowWildcards;
    }

    public Set<String> getAcceptableHostNames() {
        return this.acceptableHostNames;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificate(chain[0]);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkCertificate(chain[0]);
    }

    private void checkCertificate(X509Certificate c) throws CertificateException {
        String subjectDN = c.getSubjectX500Principal().getName("RFC2253");
        try {
            DN dn = new DN(subjectDN);
            for (RDN rdn : dn.getRDNs()) {
                String[] names = rdn.getAttributeNames();
                String[] values = rdn.getAttributeValues();
                for (int i = 0; i < names.length; ++i) {
                    String lowerName = StaticUtils.toLowerCase(names[i]);
                    if (!lowerName.equals("cn") && !lowerName.equals("commonname") && !lowerName.equals("2.5.4.3")) continue;
                    String lowerValue = StaticUtils.toLowerCase(values[i]);
                    if (this.acceptableHostNames.contains(lowerValue)) {
                        return;
                    }
                    if (!this.allowWildcards || !lowerValue.startsWith("*.")) continue;
                    String withoutWildcard = lowerValue.substring(1);
                    for (String s : this.acceptableHostNames) {
                        if (!s.endsWith(withoutWildcard)) continue;
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        Collection<List<?>> subjectAltNames = c.getSubjectAlternativeNames();
        if (subjectAltNames != null) {
            block12: for (List<?> l : subjectAltNames) {
                try {
                    Integer type = (Integer)l.get(0);
                    switch (type) {
                        case 2: {
                            String dnsName = StaticUtils.toLowerCase((String)l.get(1));
                            if (this.acceptableHostNames.contains(dnsName)) {
                                return;
                            }
                            if (!this.allowWildcards || !dnsName.startsWith("*.")) break;
                            String withoutWildcard = dnsName.substring(1);
                            for (String s : this.acceptableHostNames) {
                                if (!s.endsWith(withoutWildcard)) continue;
                                return;
                            }
                            continue block12;
                        }
                        case 6: {
                            URI uri = new URI((String)l.get(1));
                            if (!this.acceptableHostNames.contains(StaticUtils.toLowerCase(uri.getHost()))) break;
                            return;
                        }
                        case 7: {
                            InetAddress inetAddress = InetAddress.getByName((String)l.get(1));
                            for (String s : this.acceptableHostNames) {
                                InetAddress a;
                                if (!Character.isDigit(s.charAt(0)) && s.indexOf(58) < 0 || !inetAddress.equals(a = InetAddress.getByName(s))) continue;
                                return;
                            }
                            continue block12;
                        }
                    }
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        throw new CertificateException(SSLMessages.ERR_HOSTNAME_NOT_FOUND.get(subjectDN));
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

