/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerExceptionHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.MinimalLogFormatter;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.StreamHandler;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class InMemoryDirectoryServerTool
extends CommandLineTool
implements Serializable,
LDAPListenerExceptionHandler {
    private static final long serialVersionUID = 6484637038039050412L;
    private BooleanArgument accessLogToStandardOutArgument = null;
    private BooleanArgument dontStartArgument = null;
    private BooleanArgument ldapDebugLogToStandardOutArgument = null;
    private BooleanArgument useDefaultSchemaArgument = null;
    private BooleanArgument useSSLArgument = null;
    private BooleanArgument useStartTLSArgument = null;
    private DNArgument additionalBindDNArgument = null;
    private DNArgument baseDNArgument = null;
    private FileArgument accessLogFileArgument = null;
    private FileArgument keyStorePathArgument = null;
    private FileArgument ldapDebugLogFileArgument = null;
    private FileArgument ldifFileArgument = null;
    private FileArgument trustStorePathArgument = null;
    private FileArgument useSchemaFileArgument = null;
    private InMemoryDirectoryServer directoryServer = null;
    private IntegerArgument maxChangeLogEntriesArgument = null;
    private IntegerArgument portArgument = null;
    private StringArgument additionalBindPasswordArgument = null;
    private StringArgument equalityIndexArgument = null;
    private StringArgument keyStorePasswordArgument = null;
    private StringArgument trustStorePasswordArgument = null;
    private StringArgument vendorNameArgument = null;
    private StringArgument vendorVersionArgument = null;

    public static void main(String ... args) {
        ResultCode resultCode = InMemoryDirectoryServerTool.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        InMemoryDirectoryServerTool tool = new InMemoryDirectoryServerTool(outStream, errStream);
        return tool.runTool(args);
    }

    public InMemoryDirectoryServerTool(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "in-memory-directory-server";
    }

    @Override
    public String getToolDescription() {
        return ListenerMessages.INFO_MEM_DS_TOOL_DESC.get(InMemoryDirectoryServer.class.getName());
    }

    @Override
    public String getToolVersion() {
        return "2.3.6";
    }

    @Override
    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.baseDNArgument = new DNArgument(Character.valueOf('b'), "baseDN", true, 0, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_BASE_DN.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_BASE_DN.get());
        parser.addArgument(this.baseDNArgument);
        this.portArgument = new IntegerArgument(Character.valueOf('p'), "port", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PORT.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_PORT.get(), 0, 65535);
        parser.addArgument(this.portArgument);
        this.ldifFileArgument = new FileArgument(Character.valueOf('l'), "ldifFile", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_LDIF_FILE.get(), true, true, true, false);
        parser.addArgument(this.ldifFileArgument);
        this.additionalBindDNArgument = new DNArgument(Character.valueOf('D'), "additionalBindDN", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_BIND_DN.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ADDITIONAL_BIND_DN.get());
        parser.addArgument(this.additionalBindDNArgument);
        this.additionalBindPasswordArgument = new StringArgument(Character.valueOf('w'), "additionalBindPassword", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PASSWORD.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ADDITIONAL_BIND_PW.get());
        parser.addArgument(this.additionalBindPasswordArgument);
        this.maxChangeLogEntriesArgument = new IntegerArgument(Character.valueOf('c'), "maxChangeLogEntries", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_COUNT.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_MAX_CHANGELOG_ENTRIES.get(), 0, Integer.MAX_VALUE, 0);
        parser.addArgument(this.maxChangeLogEntriesArgument);
        this.accessLogToStandardOutArgument = new BooleanArgument(Character.valueOf('A'), "accessLogToStandardOut", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ACCESS_LOG_TO_STDOUT.get());
        parser.addArgument(this.accessLogToStandardOutArgument);
        this.accessLogFileArgument = new FileArgument(Character.valueOf('a'), "accessLogFile", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_ACCESS_LOG_FILE.get(), false, true, true, false);
        parser.addArgument(this.accessLogFileArgument);
        this.ldapDebugLogToStandardOutArgument = new BooleanArgument(null, "ldapDebugLogToStandardOut", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_LDAP_DEBUG_LOG_TO_STDOUT.get());
        parser.addArgument(this.ldapDebugLogToStandardOutArgument);
        this.ldapDebugLogFileArgument = new FileArgument(Character.valueOf('d'), "ldapDebugLogFile", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_LDAP_DEBUG_LOG_FILE.get(), false, true, true, false);
        parser.addArgument(this.ldapDebugLogFileArgument);
        this.useDefaultSchemaArgument = new BooleanArgument(Character.valueOf('s'), "useDefaultSchema", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_USE_DEFAULT_SCHEMA.get());
        parser.addArgument(this.useDefaultSchemaArgument);
        this.useSchemaFileArgument = new FileArgument(Character.valueOf('S'), "useSchemaFile", false, 0, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_USE_SCHEMA_FILE.get(), true, true, false, false);
        parser.addArgument(this.useSchemaFileArgument);
        this.equalityIndexArgument = new StringArgument(Character.valueOf('I'), "equalityIndex", false, 0, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_ATTR.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_EQ_INDEX.get());
        parser.addArgument(this.equalityIndexArgument);
        this.useSSLArgument = new BooleanArgument(Character.valueOf('Z'), "useSSL", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_USE_SSL.get());
        parser.addArgument(this.useSSLArgument);
        this.useStartTLSArgument = new BooleanArgument(Character.valueOf('q'), "useStartTLS", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_USE_START_TLS.get());
        parser.addArgument(this.useStartTLSArgument);
        this.keyStorePathArgument = new FileArgument(Character.valueOf('K'), "keyStorePath", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_KEY_STORE_PATH.get(), true, true, true, false);
        parser.addArgument(this.keyStorePathArgument);
        this.keyStorePasswordArgument = new StringArgument(Character.valueOf('W'), "keyStorePassword", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PASSWORD.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_KEY_STORE_PW.get());
        parser.addArgument(this.keyStorePasswordArgument);
        this.trustStorePathArgument = new FileArgument(Character.valueOf('P'), "trustStorePath", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PATH.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_TRUST_STORE_PATH.get(), true, true, true, false);
        parser.addArgument(this.trustStorePathArgument);
        this.trustStorePasswordArgument = new StringArgument(Character.valueOf('T'), "trustStorePassword", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_PASSWORD.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_TRUST_STORE_PW.get());
        parser.addArgument(this.trustStorePasswordArgument);
        this.vendorNameArgument = new StringArgument(null, "vendorName", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_VALUE.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_VENDOR_NAME.get());
        parser.addArgument(this.vendorNameArgument);
        this.vendorVersionArgument = new StringArgument(null, "vendorVersion", false, 1, ListenerMessages.INFO_MEM_DS_TOOL_ARG_PLACEHOLDER_VALUE.get(), ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_VENDOR_VERSION.get());
        parser.addArgument(this.vendorVersionArgument);
        this.dontStartArgument = new BooleanArgument(null, "dontStart", ListenerMessages.INFO_MEM_DS_TOOL_ARG_DESC_DONT_START.get());
        this.dontStartArgument.setHidden(true);
        parser.addArgument(this.dontStartArgument);
        parser.addExclusiveArgumentSet(this.useDefaultSchemaArgument, this.useSchemaFileArgument, new Argument[0]);
        parser.addExclusiveArgumentSet(this.useSSLArgument, this.useStartTLSArgument, new Argument[0]);
        parser.addExclusiveArgumentSet(this.accessLogToStandardOutArgument, this.accessLogFileArgument, new Argument[0]);
        parser.addExclusiveArgumentSet(this.ldapDebugLogToStandardOutArgument, this.ldapDebugLogFileArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.additionalBindDNArgument, this.additionalBindPasswordArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.additionalBindPasswordArgument, this.additionalBindDNArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.useSSLArgument, this.keyStorePathArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.useSSLArgument, this.keyStorePasswordArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.useStartTLSArgument, this.keyStorePathArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.useStartTLSArgument, this.keyStorePasswordArgument, new Argument[0]);
        parser.addDependentArgumentSet(this.keyStorePathArgument, this.useSSLArgument, this.useStartTLSArgument);
        parser.addDependentArgumentSet(this.keyStorePasswordArgument, this.useSSLArgument, this.useStartTLSArgument);
        parser.addDependentArgumentSet(this.trustStorePathArgument, this.useSSLArgument, this.useStartTLSArgument);
        parser.addDependentArgumentSet(this.trustStorePasswordArgument, this.trustStorePathArgument, new Argument[0]);
    }

    @Override
    public ResultCode doToolProcessing() {
        InMemoryDirectoryServerConfig serverConfig;
        try {
            serverConfig = this.getConfig();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_INITIALIZING_CONFIG.get(le.getMessage()));
            return le.getResultCode();
        }
        try {
            this.directoryServer = new InMemoryDirectoryServer(serverConfig);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_CREATING_SERVER_INSTANCE.get(le.getMessage()));
            return le.getResultCode();
        }
        if (this.ldifFileArgument.isPresent()) {
            File ldifFile = this.ldifFileArgument.getValue();
            try {
                int numEntries = this.directoryServer.importFromLDIF(true, ldifFile.getAbsolutePath());
                this.out(ListenerMessages.INFO_MEM_DS_TOOL_ADDED_ENTRIES_FROM_LDIF.get(numEntries, ldifFile.getAbsolutePath()));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_POPULATING_SERVER_INSTANCE.get(ldifFile.getAbsolutePath(), le.getMessage()));
                return le.getResultCode();
            }
        }
        try {
            if (!this.dontStartArgument.isPresent()) {
                this.directoryServer.startListening();
                this.out(ListenerMessages.INFO_MEM_DS_TOOL_LISTENING.get(this.directoryServer.getListenPort()));
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_STARTING_SERVER.get(StaticUtils.getExceptionMessage(e)));
            return ResultCode.LOCAL_ERROR;
        }
        return ResultCode.SUCCESS;
    }

    private InMemoryDirectoryServerConfig getConfig() throws LDAPException {
        FileHandler handler;
        File logFile;
        StreamHandler handler2;
        List<DN> dnList = this.baseDNArgument.getValues();
        DN[] baseDNs = new DN[dnList.size()];
        dnList.toArray(baseDNs);
        InMemoryDirectoryServerConfig serverConfig = new InMemoryDirectoryServerConfig(baseDNs);
        int listenPort = 0;
        if (this.portArgument.isPresent()) {
            listenPort = this.portArgument.getValue();
        }
        if (this.useDefaultSchemaArgument.isPresent()) {
            serverConfig.setSchema(Schema.getDefaultStandardSchema());
        } else {
            if (this.useSchemaFileArgument.isPresent()) {
                ArrayList<File> schemaFiles = new ArrayList<File>(10);
                for (File f : this.useSchemaFileArgument.getValues()) {
                    if (f.exists()) {
                        if (f.isFile()) {
                            schemaFiles.add(f);
                            continue;
                        }
                        for (File subFile : f.listFiles()) {
                            if (!subFile.isFile()) continue;
                            schemaFiles.add(subFile);
                        }
                        continue;
                    }
                    throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_NO_SUCH_SCHEMA_FILE.get(f.getAbsolutePath()));
                }
                try {
                    serverConfig.setSchema(Schema.getSchema(schemaFiles));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    StringBuilder fileList = new StringBuilder();
                    Iterator<File> fileIterator = schemaFiles.iterator();
                    while (fileIterator.hasNext()) {
                        fileList.append(fileIterator.next().getAbsolutePath());
                        if (!fileIterator.hasNext()) continue;
                        fileList.append(", ");
                    }
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_ERROR_READING_SCHEMA.get(fileList, StaticUtils.getExceptionMessage(e)), e);
                }
            }
            serverConfig.setSchema(null);
        }
        if (this.additionalBindDNArgument.isPresent()) {
            serverConfig.addAdditionalBindCredentials(this.additionalBindDNArgument.getValue().toString(), this.additionalBindPasswordArgument.getValue());
        }
        if (this.maxChangeLogEntriesArgument.isPresent()) {
            serverConfig.setMaxChangeLogEntries(this.maxChangeLogEntriesArgument.getValue());
        }
        if (this.accessLogToStandardOutArgument.isPresent()) {
            handler2 = new StreamHandler(System.out, new MinimalLogFormatter(null, false, false, true));
            handler2.setLevel(Level.INFO);
            serverConfig.setAccessLogHandler(handler2);
        } else if (this.accessLogFileArgument.isPresent()) {
            logFile = this.accessLogFileArgument.getValue();
            try {
                handler = new FileHandler(logFile.getAbsolutePath(), true);
                handler.setLevel(Level.INFO);
                handler.setFormatter(new MinimalLogFormatter(null, false, false, true));
                serverConfig.setAccessLogHandler(handler);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_ERROR_CREATING_LOG_HANDLER.get(logFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.ldapDebugLogToStandardOutArgument.isPresent()) {
            handler2 = new StreamHandler(System.out, new MinimalLogFormatter(null, false, false, true));
            handler2.setLevel(Level.INFO);
            serverConfig.setLDAPDebugLogHandler(handler2);
        } else if (this.ldapDebugLogFileArgument.isPresent()) {
            logFile = this.ldapDebugLogFileArgument.getValue();
            try {
                handler = new FileHandler(logFile.getAbsolutePath(), true);
                handler.setLevel(Level.INFO);
                handler.setFormatter(new MinimalLogFormatter(null, false, false, true));
                serverConfig.setLDAPDebugLogHandler(handler);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_ERROR_CREATING_LOG_HANDLER.get(logFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.useSSLArgument.isPresent() || this.useStartTLSArgument.isPresent()) {
            try {
                X509TrustManager trustManager;
                KeyStoreKeyManager keyManager = new KeyStoreKeyManager(this.keyStorePathArgument.getValue(), this.keyStorePasswordArgument.getValue().toCharArray());
                if (this.trustStorePathArgument.isPresent()) {
                    char[] password = this.trustStorePasswordArgument.isPresent() ? this.trustStorePasswordArgument.getValue().toCharArray() : null;
                    trustManager = new TrustStoreTrustManager(this.trustStorePathArgument.getValue(), password, "JKS", true);
                } else {
                    trustManager = new TrustAllTrustManager();
                }
                SSLUtil serverSSLUtil = new SSLUtil(keyManager, trustManager);
                if (this.useSSLArgument.isPresent()) {
                    SSLUtil clientSSLUtil = new SSLUtil(new TrustAllTrustManager());
                    serverConfig.setListenerConfigs(InMemoryListenerConfig.createLDAPSConfig("LDAPS", null, listenPort, serverSSLUtil.createSSLServerSocketFactory(), clientSSLUtil.createSSLSocketFactory()));
                }
                serverConfig.setListenerConfigs(InMemoryListenerConfig.createLDAPConfig("LDAP+StartTLS", null, listenPort, serverSSLUtil.createSSLSocketFactory()));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_TOOL_ERROR_INITIALIZING_SSL.get(StaticUtils.getExceptionMessage(e)), e);
            }
        } else {
            serverConfig.setListenerConfigs(InMemoryListenerConfig.createLDAPConfig("LDAP", listenPort));
        }
        if (this.vendorNameArgument.isPresent()) {
            serverConfig.setVendorName(this.vendorNameArgument.getValue());
        }
        if (this.vendorVersionArgument.isPresent()) {
            serverConfig.setVendorVersion(this.vendorVersionArgument.getValue());
        }
        if (this.equalityIndexArgument.isPresent()) {
            serverConfig.setEqualityIndexAttributes(this.equalityIndexArgument.getValues());
        }
        return serverConfig;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleUsages = new LinkedHashMap<String[], String>(2);
        String[] example1Args = new String[]{"--baseDN", "dc=example,dc=com"};
        exampleUsages.put(example1Args, ListenerMessages.INFO_MEM_DS_TOOL_EXAMPLE_1.get());
        String[] example2Args = new String[]{"--baseDN", "dc=example,dc=com", "--port", "1389", "--ldifFile", "test.ldif", "--accessLogFile", "access.log", "--useDefaultSchema"};
        exampleUsages.put(example2Args, ListenerMessages.INFO_MEM_DS_TOOL_EXAMPLE_2.get());
        return exampleUsages;
    }

    public InMemoryDirectoryServer getDirectoryServer() {
        return this.directoryServer;
    }

    @Override
    public void connectionCreationFailure(Socket socket, Throwable cause) {
        this.err(ListenerMessages.ERR_MEM_DS_TOOL_ERROR_ACCEPTING_CONNECTION.get(StaticUtils.getExceptionMessage(cause)));
    }

    @Override
    public void connectionTerminated(LDAPListenerClientConnection connection, LDAPException cause) {
        this.err(ListenerMessages.ERR_MEM_DS_TOOL_CONNECTION_TERMINATED_BY_EXCEPTION.get(StaticUtils.getExceptionMessage(cause)));
    }
}

