package com.franciaflex.faxtomail.ui.swing.content.reply.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.*;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since 1.4
 */
public class OpenSigningSettingsAction extends AbstractFaxToMailAction<ReplyFormUIModel, ReplyFormUI, ReplyFormUIHandler> {

    /**
     * Logger.
     */
    private static final Log log = LogFactory.getLog(OpenSigningSettingsAction.class);

    public OpenSigningSettingsAction(ReplyFormUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        // do nothing
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        SigningSettingsUI signingSettingsUI = new SigningSettingsUI(getUI());
        handler.openDialog(signingSettingsUI, t("faxtomail.signings.settings.title"), new Dimension(700, 400));

        List<Stamp> signings = signingSettingsUI.getModel().getSignings();
        getContext().getCurrentUser().setSignings(signings);
        getUI().getStampComboBox().setData(signings);
    }
}
