/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply.actions;

import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.services.service.UserService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class DeleteSigningAction
extends AbstractFaxToMailAction<SigningSettingsUIModel, SigningSettingsUI, SigningSettingsUIHandler> {
    private static final Log log = LogFactory.getLog(DeleteSigningAction.class);

    public DeleteSigningAction(SigningSettingsUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        if (result) {
            result = this.askBeforeDelete(I18n.t((String)"faxtomail.signings.settings.action.delete.confirm.title", (Object[])new Object[0]), I18n.t((String)"faxtomail.signings.settings.action.delete.confirm.message", (Object[])new Object[]{((SigningSettingsUIModel)this.getModel()).getSelectedSigningName()}));
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        SigningSettingsUIModel model = (SigningSettingsUIModel)this.getModel();
        Stamp signing = model.getSelectedSigning();
        FaxToMailUser user = this.getContext().getCurrentUser();
        UserService userService = this.getContext().newServiceContext().getUserService();
        userService.deleteSigning(user, signing);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        SigningSettingsUIModel model = (SigningSettingsUIModel)this.getModel();
        model.setModified(false);
        Stamp selectedSigning = model.getSelectedSigning();
        model.setSelectedSigning(null);
        model.removeSigning(selectedSigning);
        model.updateSetDefaultButtonEnabled();
        ((SigningSettingsUI)this.getUI()).getSigningList().repaint();
    }
}

