/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.persistence.entities.Configuration;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.nuiton.i18n.I18n;

public class PrintOnDefaultPrinterAction
extends AbstractFaxToMailAction {
    protected Multimap<DemandeUIModel, AttachmentFile> attachmentsToPrintByDemand;
    protected boolean take;
    protected boolean printDemandDetails;
    protected List<DemandeUIModel> notPrintableDemands;

    public PrintOnDefaultPrinterAction(AbstractFaxToMailUIHandler handler, Multimap<DemandeUIModel, AttachmentFile> attachmentsToPrintByDemand, boolean take, boolean printDemandDetails) {
        super(handler, false);
        this.attachmentsToPrintByDemand = attachmentsToPrintByDemand;
        this.take = take;
        this.printDemandDetails = printDemandDetails;
        this.setActionDescription(I18n.t((String)"faxtomail.action.print.tip", (Object[])new Object[0]));
    }

    @Override
    public void doAction() throws Exception {
        FaxToMailUser currentUser = this.getContext().getCurrentUser();
        AbstractFaxToMailUIHandler handler = (AbstractFaxToMailUIHandler)this.getHandler();
        Configuration config = this.getContext().newServiceContext().getConfigurationService().getConfiguration();
        int printedFileNb = 0;
        HashMultimap nonPrintedAttachment = HashMultimap.create();
        this.notPrintableDemands = new ArrayList<DemandeUIModel>();
        for (DemandeUIModel demandeUIModel : this.attachmentsToPrintByDemand.keySet()) {
            if (!handler.isActionEnabled(demandeUIModel, MailAction.PRINT, config)) {
                this.notPrintableDemands.add(demandeUIModel);
                continue;
            }
            if (this.take) {
                demandeUIModel.setTakenBy(currentUser);
            }
            ArrayList<String> printedFiles = new ArrayList<String>();
            FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
            if (this.printDemandDetails) {
                Email email;
                EmailService emailService = serviceContext.getEmailService();
                AttachmentFile demandDetailAttachment = emailService.getEmailDetailAsAttachment(email = demandeUIModel.toEntity());
                if (FaxToMailUIUtil.print(demandDetailAttachment, true)) {
                    printedFiles.add(demandDetailAttachment.getFilename());
                } else {
                    nonPrintedAttachment.put((Object)demandeUIModel, (Object)demandDetailAttachment);
                }
            }
            for (AttachmentFile attachmentFile : this.attachmentsToPrintByDemand.get((Object)demandeUIModel)) {
                if (attachmentFile == null) continue;
                boolean printable = FaxToMailUIUtil.isFileTypeEditable(attachmentFile.getFilename());
                if (printable && FaxToMailUIUtil.print(attachmentFile, true)) {
                    printedFiles.add(attachmentFile.getFilename());
                    continue;
                }
                nonPrintedAttachment.put((Object)demandeUIModel, (Object)attachmentFile);
            }
            Email email = serviceContext.getEmailService().addToHistory(demandeUIModel.getTopiaId(), HistoryType.PRINTING, this.getContext().getCurrentUser(), new Date(), printedFiles.toArray(new String[printedFiles.size()]));
            printedFileNb += printedFiles.size();
            demandeUIModel.setHistory(email.getHistory());
        }
        if (!nonPrintedAttachment.isEmpty()) {
            String errorPageContent = this.generateErrorPageStream((Multimap<DemandeUIModel, AttachmentFile>)nonPrintedAttachment);
            FaxToMailUIUtil.printText("nonprintedattachement", errorPageContent, true);
        }
        handler.showInformationMessage(I18n.t((String)"faxtomail.print.success.message", (Object[])new Object[]{printedFileNb}));
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (!this.notPrintableDemands.isEmpty()) {
            String notPrintableDemandTitles = "";
            for (DemandeUIModel demandeUIModel : this.notPrintableDemands) {
                notPrintableDemandTitles = notPrintableDemandTitles + "- " + demandeUIModel.getTitle() + "<br/>";
            }
            this.displayWarningMessage(I18n.t((String)"faxtomail.action.print.notPrintableDemands.title", (Object[])new Object[0]), I18n.t((String)"faxtomail.action.print.notPrintableDemands.message", (Object[])new Object[]{notPrintableDemandTitles}));
        }
    }

    protected String generateErrorPageStream(Multimap<DemandeUIModel, AttachmentFile> nonPrintedAttachment) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nLes pi\u00e8ces-jointes suivantes n'ont pas pu \u00eatre imprim\u00e9es:\n");
        for (DemandeUIModel email : nonPrintedAttachment.keySet()) {
            Collection attachments = nonPrintedAttachment.get((Object)email);
            builder.append(" * ");
            if (!Strings.isNullOrEmpty((String)email.getCompanyReference())) {
                builder.append(email.getCompanyReference() + " - ");
            }
            builder.append(Strings.nullToEmpty((String)email.getObject()) + " : \n");
            for (AttachmentFile attachmentFile : attachments) {
                builder.append("    - " + attachmentFile.getFilename() + "\n");
            }
        }
        return builder.toString();
    }
}

