/*
 * Decompiled with CFR 0.152.
 */
package gui.ava.html.parser;

import gui.ava.html.parser.HtmlParser;
import gui.ava.html.parser.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class HtmlParserImpl
implements HtmlParser {
    private DOMParser domParser = new DOMParser((XMLParserConfiguration)new HTMLConfiguration());
    private Document document;

    public HtmlParserImpl() {
        try {
            this.domParser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
        }
        catch (SAXNotRecognizedException e) {
            throw new ParseException("Can't create HtmlParserImpl", e);
        }
        catch (SAXNotSupportedException e) {
            throw new ParseException("Can't create HtmlParserImpl", e);
        }
    }

    @Override
    public DOMParser getDomParser() {
        return this.domParser;
    }

    @Override
    public void setDomParser(DOMParser domParser) {
        this.domParser = domParser;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public void load(Reader reader) {
        try {
            this.domParser.parse(new InputSource(reader));
            this.document = this.domParser.getDocument();
        }
        catch (SAXException e) {
            throw new ParseException("SAXException while parsing HTML.", e);
        }
        catch (IOException e) {
            throw new ParseException("IOException while parsing HTML.", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ignore) {}
        }
    }

    @Override
    public void load(InputStream inputStream) {
        try {
            this.domParser.parse(new InputSource(inputStream));
            this.document = this.domParser.getDocument();
        }
        catch (SAXException e) {
            throw new ParseException("SAXException while parsing HTML.", e);
        }
        catch (IOException e) {
            throw new ParseException("IOException while parsing HTML.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignore) {}
        }
    }

    @Override
    public void loadURI(String uri) {
        try {
            this.domParser.parse(new InputSource(uri));
            this.document = this.domParser.getDocument();
        }
        catch (SAXException e) {
            throw new ParseException(String.format("SAXException while parsing HTML from \"%s\".", uri), e);
        }
        catch (IOException e) {
            throw new ParseException(String.format("SAXException while parsing HTML from \"%s\".", uri), e);
        }
    }

    @Override
    public void load(File file) {
        this.load(file.toURI());
    }

    @Override
    public void load(URL url) {
        this.loadURI(url.toExternalForm());
    }

    @Override
    public void load(URI uri) {
        this.loadURI(uri.toString());
    }

    @Override
    public void loadHtml(String html) {
        this.load(new StringReader(html));
    }
}

