/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.attachment.actions;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.services.service.UserService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.nuiton.i18n.I18n;

public class EditAttachmentAction
extends AbstractFaxToMailAction<AttachmentEditorUIModel, AttachmentEditorUI, AttachmentEditorUIHandler> {
    protected Attachment attachment;
    protected Collection<Stamp> stamps;
    protected JFrame frame;

    public EditAttachmentAction(AttachmentEditorUIHandler handler, Attachment attachment) {
        super(handler, false);
        this.attachment = attachment;
        String attachmentName = attachment.getEditedFileName() != null ? attachment.getEditedFileName() : attachment.getOriginalFileName();
        this.setActionDescription(I18n.t((String)"faxtomail.action.attachment.edit.tip", (Object[])new Object[]{attachmentName}));
    }

    @Override
    public void doAction() throws Exception {
        ((AttachmentEditorUIModel)this.getModel()).fireAttachmentOpened(this.attachment, false);
        FaxToMailUIUtil.forceAttachmentFileLoading(this.getContext(), this.attachment);
        FaxToMailUser currentUser = this.getContext().getCurrentUser();
        UserService userService = this.getContext().newServiceContext().getUserService();
        this.stamps = userService.getPdfEditorStamps(currentUser);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        final PDFEditorUI dialogContent = new PDFEditorUI((FaxToMailUI)this.getUI());
        PDFEditorUIModel pdfEditorUIModel = dialogContent.getModel();
        pdfEditorUIModel.fromEntity(this.attachment);
        pdfEditorUIModel.setDemand(this.getContext().getCurrentEmail());
        pdfEditorUIModel.setStamps(this.stamps);
        MainUI mainUI = this.getContext().getMainUI();
        this.frame = ((AttachmentEditorUIHandler)this.getHandler()).openFrame(dialogContent, this.attachment.getOriginalFileName(), mainUI.getSize());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                dialogContent.getModel().toEntity(EditAttachmentAction.this.attachment);
            }
        });
        this.getContext().addPropertyChangeListener("busy", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!EditAttachmentAction.this.getContext().isBusy()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditAttachmentAction.this.getContext().getFrameForDemande(EditAttachmentAction.this.getContext().getCurrentEmail()).toFront();
                            if (EditAttachmentAction.this.frame != null) {
                                EditAttachmentAction.this.frame.toFront();
                                EditAttachmentAction.this.frame = null;
                            }
                        }
                    });
                    EditAttachmentAction.this.getContext().removePropertyChangeListener("busy", this);
                }
            }
        });
    }

    protected void releaseAction() {
        super.releaseAction();
        this.stamps = null;
    }
}

