/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.reply;

import com.franciaflex.faxtomail.persistence.entities.Stamp;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.SigningSettingsUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.actions.SaveSigningAction;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.Cancelable;

public class SigningSettingsUIHandler
extends AbstractFaxToMailUIHandler<SigningSettingsUIModel, SigningSettingsUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SigningSettingsUIHandler.class);

    public void beforeInit(SigningSettingsUI ui) {
        super.beforeInit((ApplicationUI)ui);
        SigningSettingsUIModel model = new SigningSettingsUIModel();
        ((SigningSettingsUI)this.ui).setContextValue(model);
    }

    public void afterInit(SigningSettingsUI ui) {
        this.initUI(ui);
        SigningSettingsUIModel model = (SigningSettingsUIModel)((Object)this.getModel());
        model.addPropertyChangeListener("signings", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List signings = (List)evt.getNewValue();
                JList<Stamp> signingList = ((SigningSettingsUI)SigningSettingsUIHandler.this.getUI()).getSigningList();
                signingList.setListData((Stamp[])signings.toArray(new Stamp[signings.size()]));
            }
        });
        model.addPropertyChangeListener("selectedSigning", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ((SigningSettingsUI)SigningSettingsUIHandler.this.getUI()).getSigningList().setSelectedValue(evt.getNewValue(), true);
            }
        });
        Collection stampSigning = this.getContext().getCurrentUser().getSignings();
        model.setSignings(stampSigning);
        JList<Stamp> signingList = ((SigningSettingsUI)this.getUI()).getSigningList();
        Decorator<Stamp> signingDecorator = this.getDecorator(Stamp.class, null);
        SigningListCellRenderer listCellRenderer = new SigningListCellRenderer(signingDecorator);
        signingList.setCellRenderer((ListCellRenderer<Stamp>)((Object)listCellRenderer));
        signingList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SigningSettingsUIModel model = (SigningSettingsUIModel)((Object)SigningSettingsUIHandler.this.getModel());
                    JList list = (JList)e.getSource();
                    if (model.isModified()) {
                        int saveAnswer = SigningSettingsUIHandler.this.askSaveBeforeLeaving(I18n.t((String)"faxtomail.signings.settings.saveBeforeLeaving", (Object[])new Object[]{model.getSelectedSigningName()}));
                        switch (saveAnswer) {
                            case 2: {
                                model.setModified(false);
                                list.setSelectedValue(model.getSelectedSigning(), true);
                                model.setModified(true);
                                return;
                            }
                            case 0: {
                                SigningSettingsUIHandler.this.getContext().getActionEngine().runActionAndWait((AbstractApplicationUIHandler)SigningSettingsUIHandler.this, SaveSigningAction.class);
                                break;
                            }
                            case 1: {
                                model.resetSelectedSigning();
                            }
                        }
                    }
                    Stamp selectedValue = (Stamp)list.getSelectedValue();
                    model.setSelectedSigning(selectedValue);
                    model.setSelectedSigningDefault(selectedValue != null && selectedValue.equals(SigningSettingsUIHandler.this.getContext().getCurrentUser().getDefaultSigning()));
                }
            }
        });
    }

    public void cancel() {
        ((Dialog)this.getParentContainer(Dialog.class)).setVisible(false);
    }

    public void onCloseUI() {
    }

    @Override
    public Component getTopestUI() {
        return (Component)this.getUI();
    }

    public SwingValidator<SigningSettingsUIModel> getValidator() {
        return ((SigningSettingsUI)this.getUI()).getValidator();
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    private class SigningListCellRenderer
    extends DecoratorListCellRenderer {
        public SigningListCellRenderer(Decorator<Stamp> decorator) {
            super(decorator);
        }

        protected Object decorateValue(Object value, int index) {
            String label = (String)super.decorateValue(value, index);
            Stamp signing = (Stamp)value;
            if (signing != null && signing.equals(SigningSettingsUIHandler.this.getContext().getCurrentUser().getDefaultSigning())) {
                label = "<html><strong>" + label + "</strong></html>";
            }
            return label;
        }
    }
}

