/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class OpenReplyFormAction
extends AbstractFaxToMailAction<DemandeListUIModel, DemandeListUI, DemandeListUIHandler> {
    protected ReplyFormUI frameContent;
    protected JFrame frame;

    public OpenReplyFormAction(DemandeListUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        DemandeUIModel demand = ((DemandeListUIModel)this.getModel()).getSelectedEmails().get(0);
        if (StringUtils.isNotBlank((CharSequence)demand.getTopiaId())) {
            FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
            Email email = serviceContext.getEmailService().getFullEmailById(demand.getTopiaId(), this.getContext().getCurrentUser());
            demand.fromEntity(email);
            this.getContext().setCurrentEmail(demand);
            this.frameContent = new ReplyFormUI((FaxToMailUI)this.getUI());
            ReplyFormUIModel model = this.frameContent.getModel();
            model.setOriginalDemand(demand);
            String sender = JAXXUtil.getStringValue((Object)demand.getSender());
            if (demand.isFax()) {
                MailFolder selectedFolder = ((DemandeListUIModel)this.getModel()).getSelectedFolder();
                sender = FaxToMailServiceUtils.addFaxDomainToFaxNumber((String)sender, (MailFolder)selectedFolder);
            }
            model.setTo(sender);
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.frame = ((DemandeListUIHandler)this.getHandler()).openModalFrame(this.frameContent, I18n.t((String)"faxtomail.reply.title", (Object[])new Object[]{this.getContext().getCurrentEmail().getTitle()}), new Dimension(800, 600));
    }

    protected void releaseAction() {
        super.releaseAction();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OpenReplyFormAction.this.frame != null) {
                    OpenReplyFormAction.this.frame.toFront();
                    OpenReplyFormAction.this.frame = null;
                }
            }
        });
    }
}

