/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing;

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.RessourceClassLoader;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailTopiaApplicationContext;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.InitFaxToMailService;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.services.service.UserService;
import com.franciaflex.faxtomail.services.service.ldap.AuthenticationException;
import com.franciaflex.faxtomail.services.service.ldap.Contact;
import com.franciaflex.faxtomail.ui.swing.FaxToMailActionFactory;
import com.franciaflex.faxtomail.ui.swing.FaxToMailScreen;
import com.franciaflex.faxtomail.ui.swing.content.MainUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;
import com.franciaflex.faxtomail.ui.swing.util.UIMessageNotifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.session.BeanDoubleListState;
import jaxx.runtime.swing.session.BeanFilterableComboBoxState;
import jaxx.runtime.swing.session.SwingSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.error.ErrorInfo;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.ClassPathI18nInitializer;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.ApplicationConfiguration;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.ApplicationActionEngine;
import org.nuiton.jaxx.application.swing.action.ApplicationActionFactory;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.action.ApplicationUIAction;
import org.nuiton.jaxx.application.swing.util.ApplicationErrorHelper;
import org.nuiton.jaxx.application.swing.util.Cancelable;
import org.nuiton.util.converter.ConverterUtil;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class FaxToMailUIContext
extends AbstractBean
implements Closeable,
UIMessageNotifier,
ApplicationUIContext {
    private static final Log log = LogFactory.getLog(FaxToMailUIContext.class);
    public static final String PROPERTY_SCREEN = "screen";
    public static final String PROPERTY_LOCALE = "locale";
    public static final Set<String> PROPERTIES_TO_SAVE = Sets.newHashSet((Object[])new String[]{"locale"});
    public static final String PROPERTY_BUSY = "busy";
    public static final String PROPERTY_HIDE_BODY = "hideBody";
    public static final String PROPERTY_ACTION_IN_PROGRESS = "actionInProgress";
    private static FaxToMailUIContext applicationContext;
    protected final FaxToMailConfiguration config;
    protected final RessourceClassLoader resourceLoader;
    protected FaxToMailTopiaApplicationContext topiaApplicationContext;
    protected final SwingSession swingSession;
    protected final ApplicationErrorHelper errorHelper;
    protected FaxToMailScreen screen;
    protected Locale locale;
    protected boolean busy;
    protected boolean hideBody;
    protected boolean actionInProgress;
    protected final Set<UIMessageNotifier> messageNotifiers;
    private MainUI mainUI;
    private ApplicationActionUI actionUI;
    private JFrame secondaryFrame;
    private final ApplicationActionFactory faxToMailActionFactory;
    private final ApplicationActionEngine faxToMailActionEngine;
    protected FaxToMailUser currentUser;
    protected MailFolder currentMailFolder;
    protected PaginationParameter currentPaginationParameter;
    protected DemandeUIModel currentEmail;
    protected Map<DemandeUIModel, JFrame> demandesFrames = new HashMap<DemandeUIModel, JFrame>();
    protected boolean useFolderCache;
    protected FolderData currentFolderEmails = new FolderData();
    protected List<MailFolder> listExpandedFolders = new ArrayList<MailFolder>();
    protected List<MailFolder> transmitExpandedFolders = new ArrayList<MailFolder>();
    protected SearchUIModel search;
    protected List<FaxToMailUser> faxtomailUserCache;
    protected List<WaitingState> waitingStateCache;
    protected List<DemandType> demandTypeCache;
    protected List<Priority> priorityCache;
    protected List<Range> rangeCache;
    protected List<Contact> contactCache;
    protected EmailFilter emailFilter = new EmailFilter();

    public static FaxToMailUIContext newContext(FaxToMailConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkState((applicationContext == null ? 1 : 0) != 0, (Object)"Application context was already opened!");
        applicationContext = new FaxToMailUIContext(config);
        return applicationContext;
    }

    public static FaxToMailUIContext getApplicationContext() {
        return applicationContext;
    }

    public ApplicationErrorHelper getErrorHelper() {
        return FaxToMailUIContext.applicationContext.errorHelper;
    }

    public String getI18nPrefix() {
        return "faxtomail.property.";
    }

    public String getDateFormat() {
        return this.getConfig().getDateFormat();
    }

    protected FaxToMailUIContext(FaxToMailConfiguration config) {
        this.config = config;
        this.resourceLoader = new RessourceClassLoader(Thread.currentThread().getContextClassLoader());
        this.topiaApplicationContext = new FaxToMailTopiaApplicationContext(config.getTopiaProperties());
        FaxToMailServiceContext serviceContext = this.newServiceContext();
        this.useFolderCache = serviceContext.getApplicationConfig().isUseFolderCache();
        InitFaxToMailService initFaxToMailService = serviceContext.getInitFaxToMailService();
        initFaxToMailService.init();
        HashMap additionalStates = Maps.newHashMap();
        additionalStates.put(BeanFilterableComboBox.class, new BeanFilterableComboBoxState());
        additionalStates.put(BeanDoubleList.class, new BeanDoubleListState());
        File uiConfigFile = this.getConfig().getUIConfigFile();
        this.swingSession = new SwingSession(uiConfigFile, false, (Map)additionalStates);
        if (!uiConfigFile.exists()) {
            this.swingSession.loadSafeStates();
        }
        this.errorHelper = new ApplicationErrorHelper(this){

            public void showWarningDialog(String message) {
                JOptionPane.showMessageDialog((Component)this.context.getActionUI(), "<html><body>" + message + "</body></html>", I18n.t((String)"application.error.ui.business.warning", (Object[])new Object[0]), 2);
            }

            public void showErrorDialog(String message, Throwable cause) {
                if (log.isErrorEnabled()) {
                    log.error((Object)message, cause);
                }
                super.showErrorDialog(message, cause);
            }

            public void reportError(ErrorInfo errorInfo) throws NullPointerException {
            }
        };
        UIMessageNotifier logMessageNotifier = new UIMessageNotifier(){

            @Override
            public void showInformationMessage(String message) {
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    message = message.replaceAll("\\<strong\\>", "");
                    message = message.replaceAll("\\<.strong\\>", "");
                    message = message.replaceAll("\\<li\\>", "");
                    message = message.replaceAll("\\<.li\\>", "");
                    message = message.replaceAll("\\<ul\\>", "");
                    message = message.replaceAll("\\<.ul\\>", "");
                    if (log.isInfoEnabled()) {
                        log.info((Object)message);
                    }
                }
            }
        };
        this.messageNotifiers = Sets.newHashSet();
        this.addMessageNotifier(logMessageNotifier);
        this.faxToMailActionFactory = new FaxToMailActionFactory();
        this.faxToMailActionEngine = new ApplicationActionEngine(this.faxToMailActionFactory);
    }

    public ApplicationConfiguration getConfiguration() {
        return this.config;
    }

    public Component getBodyUI() {
        MainUI mainUI = this.getMainUI();
        return mainUI == null ? null : mainUI.getBody();
    }

    public Component getStatusUI() {
        MainUI mainUI = this.getMainUI();
        return mainUI == null ? null : mainUI.getStatus();
    }

    public void init() {
        this.config.prepareDirectories();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.getResourceLoader());
        ConverterUtil.deregister();
        ConverterUtil.initConverters();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Close context on shutdown");
                }
                FaxToMailUIContext.this.close();
            }
        }));
        Locale i18nLocale = this.config.getI18nLocale();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Starts i18n with locale [%s]", i18nLocale));
        }
        try {
            I18n.init((I18nInitializer)new DefaultI18nInitializer("faxtomail-i18n"), (Locale)i18nLocale);
        }
        catch (RuntimeException ex) {
            I18n.init((I18nInitializer)new ClassPathI18nInitializer(), (Locale)i18nLocale);
        }
        this.autologinUser();
        this.initContextCache();
        this.setActionUI(new ApplicationActionUI(null, (ApplicationUIContext)this));
    }

    protected void initContextCache() {
        block4: {
            if (log.isInfoEnabled()) {
                log.info((Object)"Adding referentiel in cache");
            }
            FaxToMailServiceContext serviceContext = this.newServiceContext();
            ReferentielService referentielService = serviceContext.getReferentielService();
            this.setRangeCache(referentielService.getAllRange());
            this.setDemandTypeCache(referentielService.getAllDemandType());
            this.setWaitingStateCache(referentielService.getAllWaitingState());
            this.setPriorityCache(referentielService.getAllPriority());
            UserService userService = serviceContext.getUserService();
            this.setFaxtomailUserCache(userService.getAllActiveUsers());
            if (!this.config.isLdapMock()) {
                try {
                    this.setContactCache(serviceContext.getLdapService().getUserAndEmails());
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Error while getting contact from ldap", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autologinUser() {
        String principal = this.getLoggedInUsername();
        final FaxToMailServiceContext serviceContext = this.newServiceContext();
        try {
            block7: {
                try {
                    FaxToMailUser currentUser = serviceContext.getLdapService().getUserFromPrincipal(principal);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Connected as " + currentUser.getFirstName() + " " + currentUser.getLastName()));
                    }
                    this.setCurrentUser(currentUser);
                }
                catch (AuthenticationException ex) {
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)"Can't anthenticate user", (Throwable)ex);
                }
            }
            while (this.getCurrentUser() == null) {
                JXLoginPane pane = new JXLoginPane();
                pane.setLoginService(new LoginService(){

                    public boolean authenticate(String name, char[] password, String server) throws Exception {
                        boolean result;
                        block2: {
                            result = false;
                            try {
                                FaxToMailUser user = serviceContext.getLdapService().authenticateUser(name, String.valueOf(password));
                                FaxToMailUIContext.this.setCurrentUser(user);
                                result = true;
                            }
                            catch (AuthenticationException ex) {
                                if (!log.isWarnEnabled()) break block2;
                                log.warn((Object)"Can't anthenticate user", (Throwable)ex);
                            }
                        }
                        return result;
                    }
                });
                JXLoginPane.Status loginStatus = JXLoginPane.showLoginDialog(null, (JXLoginPane)pane);
                if (loginStatus != JXLoginPane.Status.CANCELLED) continue;
                throw new ApplicationBusinessException("Authentication canceled");
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)serviceContext);
        }
    }

    protected String getLoggedInUsername() {
        String result = this.getConfig().getLdapTestPrincipal();
        if (StringUtils.isBlank((CharSequence)result)) {
            result = System.getProperty("user.name");
        }
        return result;
    }

    public void open() {
        this.setLocale(this.config.getI18nLocale());
        this.saveContextToConfig();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PROPERTIES_TO_SAVE.contains(evt.getPropertyName())) {
                    FaxToMailUIContext.this.saveContextToConfig();
                }
            }
        });
    }

    @Override
    public void close() {
        PropertyChangeListener[] listeners;
        this.messageNotifiers.clear();
        this.setScreen(null);
        for (PropertyChangeListener listener : listeners = this.getPropertyChangeListeners()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            this.removePropertyChangeListener(listener);
        }
        this.setMainUI(null);
        if (this.actionUI != null) {
            this.actionUI.getModel().clear();
        }
        this.setActionUI(null);
    }

    public FaxToMailServiceContext newServiceContext() {
        FaxToMailServiceContext serviceContext = FaxToMailServiceContext.newServiceContext((FaxToMailTopiaApplicationContext)this.topiaApplicationContext);
        serviceContext.setApplicationConfig(this.config);
        return serviceContext;
    }

    public FaxToMailConfiguration getConfig() {
        return this.config;
    }

    protected void saveContextToConfig() {
        this.config.setI18nLocale(this.getLocale());
        this.config.save();
    }

    public MainUI getMainUI() {
        return this.mainUI;
    }

    public void setMainUI(MainUI mainUI) {
        this.mainUI = mainUI;
    }

    public JFrame getSecondaryFrame() {
        return this.secondaryFrame;
    }

    public void setSecondaryFrame(JFrame secondaryFrame) {
        this.secondaryFrame = secondaryFrame;
    }

    public void closeSecondaryFrame() {
        ApplicationUI dialogContent;
        AbstractApplicationUIHandler handler;
        Container contentPane;
        JFrame secondaryFrame = this.getSecondaryFrame();
        if (secondaryFrame != null && (contentPane = secondaryFrame.getContentPane()) instanceof ApplicationUI && (handler = (dialogContent = (ApplicationUI)contentPane).getHandler()) instanceof Cancelable) {
            ((Cancelable)handler).cancel();
        }
    }

    public ApplicationActionUI getActionUI() {
        return this.actionUI;
    }

    public ApplicationActionUI getExistingActionUI() {
        while (this.actionUI == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.actionUI;
    }

    public void setActionUI(ApplicationActionUI actionUI) {
        this.actionUI = actionUI;
    }

    public SwingSession getSwingSession() {
        return this.swingSession;
    }

    public FaxToMailScreen getScreen() {
        return this.screen;
    }

    public void setScreen(FaxToMailScreen screen) {
        FaxToMailScreen oldValue = this.getScreen();
        this.screen = screen;
        this.firePropertyChange(PROPERTY_SCREEN, (Object)oldValue, (Object)screen);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
        this.firePropertyChange(PROPERTY_BUSY, null, busy);
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    public void setHideBody(boolean hideBody) {
        this.hideBody = hideBody;
        this.firePropertyChange(PROPERTY_HIDE_BODY, null, hideBody);
    }

    public boolean isActionInProgress(ApplicationUIAction action) {
        return this.actionInProgress;
    }

    public void setActionInProgress(ApplicationUIAction action, boolean actionInProgress) {
        this.actionInProgress = actionInProgress;
        this.firePropertyChange(PROPERTY_ACTION_IN_PROGRESS, null, actionInProgress);
    }

    public Color getColorBlockingLayer() {
        return this.getConfig().getColorBlockingLayer();
    }

    public ApplicationActionFactory getActionFactory() {
        return this.faxToMailActionFactory;
    }

    public ApplicationActionEngine getActionEngine() {
        return this.faxToMailActionEngine;
    }

    public void addMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.add(messageNotifier);
    }

    public void removeMessageNotifier(UIMessageNotifier messageNotifier) {
        this.messageNotifiers.remove(messageNotifier);
    }

    @Override
    public void showInformationMessage(String message) {
        for (UIMessageNotifier messageNotifier : this.messageNotifiers) {
            messageNotifier.showInformationMessage(message);
        }
    }

    public RessourceClassLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.firePropertyChange(PROPERTY_LOCALE, null, locale);
    }

    public FaxToMailUser getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(FaxToMailUser currentUser) {
        this.currentUser = currentUser;
    }

    public MailFolder getCurrentMailFolder() {
        return this.currentMailFolder;
    }

    public void setCurrentMailFolder(MailFolder currentMailFolder) {
        this.currentMailFolder = currentMailFolder;
    }

    public PaginationParameter getCurrentPaginationParameter() {
        return this.currentPaginationParameter;
    }

    public void setCurrentPaginationParameter(PaginationParameter currentPaginationParameter) {
        this.currentPaginationParameter = currentPaginationParameter;
    }

    public DemandeUIModel getCurrentEmail() {
        return this.currentEmail;
    }

    public void setCurrentEmail(DemandeUIModel currentEmail) {
        this.currentEmail = currentEmail;
    }

    public FolderData getCurrentFolderEmails() {
        return this.currentFolderEmails;
    }

    public List<MailFolder> getListExpandedFolders() {
        return this.listExpandedFolders;
    }

    public void setListExpandedFolders(List<MailFolder> listExpandedFolders) {
        this.listExpandedFolders = listExpandedFolders;
    }

    public List<MailFolder> getTransmitExpandedFolders() {
        return this.transmitExpandedFolders;
    }

    public void setTransmitExpandedFolders(List<MailFolder> transmitExpandedFolders) {
        this.transmitExpandedFolders = transmitExpandedFolders;
    }

    public SearchUIModel getSearch() {
        return this.search;
    }

    public void setSearch(SearchUIModel search) {
        this.search = search;
    }

    public List<FaxToMailUser> getFaxtomailUserCache() {
        return this.faxtomailUserCache;
    }

    public void setFaxtomailUserCache(List<FaxToMailUser> faxtomailUserCache) {
        this.faxtomailUserCache = faxtomailUserCache;
    }

    public List<WaitingState> getWaitingStateCache() {
        return this.waitingStateCache;
    }

    public void setWaitingStateCache(List<WaitingState> waitingStateCache) {
        this.waitingStateCache = waitingStateCache;
    }

    public List<DemandType> getDemandTypeCache() {
        return this.demandTypeCache;
    }

    public void setDemandTypeCache(List<DemandType> demandTypeCache) {
        this.demandTypeCache = demandTypeCache;
    }

    public List<Priority> getPriorityCache() {
        return this.priorityCache;
    }

    public void setPriorityCache(List<Priority> priorityCache) {
        this.priorityCache = priorityCache;
    }

    public List<Range> getRangeCache() {
        return this.rangeCache;
    }

    public void setRangeCache(List<Range> rangeCache) {
        this.rangeCache = rangeCache;
    }

    public List<Contact> getContactCache() {
        return this.contactCache;
    }

    public void setContactCache(List<Contact> contactCache) {
        this.contactCache = contactCache;
    }

    public boolean isUseFolderCache() {
        return this.useFolderCache;
    }

    public EmailFilter getEmailFilter() {
        return this.emailFilter;
    }

    public void setEmailFilter(EmailFilter emailFilter) {
        this.emailFilter = emailFilter;
    }

    public JFrame getFrameForDemande(DemandeUIModel demande) {
        return this.demandesFrames.get(demande);
    }

    public void setFrameForDemande(DemandeUIModel demande, JFrame frame) {
        this.demandesFrames.put(demande, frame);
    }

    public class FolderData {
        protected MailFolder folder;
        protected List<DemandeUIModel> demands;
        protected PaginationResult<Email> paginationResult;

        public MailFolder getFolder() {
            return this.folder;
        }

        public void setFolder(MailFolder folder) {
            this.folder = folder;
        }

        public List<DemandeUIModel> getDemands() {
            return this.demands;
        }

        public void setDemands(List<DemandeUIModel> demands) {
            this.demands = new ArrayList<DemandeUIModel>(demands);
        }

        public void removeDemand(DemandeUIModel demand) {
            this.demands.remove(demand);
        }

        public void removeAllDemands(Collection<DemandeUIModel> demands) {
            this.demands.removeAll(demands);
        }

        public PaginationResult<Email> getPaginationResult() {
            return this.paginationResult;
        }

        public void setPaginationResult(PaginationResult<Email> paginationResult) {
            this.paginationResult = paginationResult;
        }
    }
}

