/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ServerSideSortResponseControl
extends Control
implements DecodeableControl {
    public static final String SERVER_SIDE_SORT_RESPONSE_OID = "1.2.840.113556.1.4.474";
    private static final byte TYPE_ATTRIBUTE_TYPE = -128;
    private static final long serialVersionUID = -8707533262822875822L;
    private final ResultCode resultCode;
    private final String attributeName;

    ServerSideSortResponseControl() {
        this.resultCode = null;
        this.attributeName = null;
    }

    public ServerSideSortResponseControl(ResultCode resultCode, String attributeName, boolean isCritical) {
        super(SERVER_SIDE_SORT_RESPONSE_OID, isCritical, ServerSideSortResponseControl.encodeValue(resultCode, attributeName));
        this.resultCode = resultCode;
        this.attributeName = attributeName;
    }

    public ServerSideSortResponseControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        ASN1Sequence valueSequence;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_VALUE_NOT_SEQUENCE.get(ae), ae);
        }
        ASN1Element[] valueElements = valueSequence.elements();
        if (valueElements.length < 1 || valueElements.length > 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_INVALID_ELEMENT_COUNT.get(valueElements.length));
        }
        try {
            int rc = ASN1Enumerated.decodeAsEnumerated(valueElements[0]).intValue();
            this.resultCode = ResultCode.valueOf(rc);
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SORT_RESPONSE_FIRST_NOT_ENUM.get(ae), ae);
        }
        this.attributeName = valueElements.length == 2 ? ASN1OctetString.decodeAsOctetString(valueElements[1]).stringValue() : null;
    }

    public ServerSideSortResponseControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new ServerSideSortResponseControl(oid, isCritical, value);
    }

    public static ServerSideSortResponseControl get(SearchResult result) throws LDAPException {
        Control c = result.getResponseControl(SERVER_SIDE_SORT_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof ServerSideSortResponseControl) {
            return (ServerSideSortResponseControl)c;
        }
        return new ServerSideSortResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    private static ASN1OctetString encodeValue(ResultCode resultCode, String attributeName) {
        ASN1Element[] valueElements = attributeName == null ? new ASN1Element[]{new ASN1Enumerated(resultCode.intValue())} : new ASN1Element[]{new ASN1Enumerated(resultCode.intValue()), new ASN1OctetString(-128, attributeName)};
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_SORT_RESPONSE.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ServerSideSortResponseControl(resultCode=");
        buffer.append(this.resultCode);
        if (this.attributeName != null) {
            buffer.append(", attributeName='");
            buffer.append(this.attributeName);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

